/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.mail.service;

import org.kuali.rice.kew.api.action.ActionItem;


/**
 * A service which allows for the sending of email reminders triggered by the state
 * of a user's Action List.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public interface ActionListEmailService {

    public void sendImmediateReminder(ActionItem actionItem, Boolean skipOnApprovals);
    public void sendDailyReminder();
    public void sendWeeklyReminder();
    public void scheduleBatchEmailReminders() throws Exception;

}

