/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.notes;

import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.LogManager;
import org.kuali.rice.kew.api.document.Document;
import org.kuali.rice.krad.UserSession;


/**
 * Default implementation of the {@link CustomNoteAttribute}.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class CustomNoteAttributeImpl implements CustomNoteAttribute {

    private Document routeHeaderVO;
    private UserSession userSession;
    private static final Logger LOG = LogManager.getLogger(CustomNoteAttributeImpl.class);

    @Override
	public boolean isAuthorizedToAddNotes() throws Exception {
        return true;
    }

    /**
     * By default the individual who authored the note is the only one allowed to edit it.
     */
    @Override
	public boolean isAuthorizedToEditNote(Note note) throws Exception {
    	return note.getNoteAuthorWorkflowId().equalsIgnoreCase(userSession.getPrincipalId());
    }

    @Override
	public Document getRouteHeaderVO() {
        return routeHeaderVO;
    }

    @Override
	public void setRouteHeaderVO(Document routeHeaderVO) {
        this.routeHeaderVO = routeHeaderVO;
    }

	@Override
	public UserSession getUserSession() {
		return userSession;
	}

	@Override
	public void setUserSession(UserSession userSession) {
		this.userSession = userSession;
	}
	
    @Override
    public boolean isAuthorizedToRetrieveAttachments() throws Exception {
        LOG.info("CustomNoteAttribute override not found, defaulting attachment security result will be true.");
        return true;
    }

}
