/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.notification.service;

import java.util.List;

import org.kuali.rice.kew.api.action.ActionItem;



/**
 * A service which sends notifications regarding the generation of ActionItems.
 * 
 * @see ActionItem
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public interface NotificationService {

	/**
	 * Send out notifications in regards to the given ActionItems being generated.
	 */
	public void notify(List<ActionItem> actionItems);
	
	/**
	 * Remove notifications for action items that are being deleted
	 * @param actionItems actionItems that are being deleted
	 */
	public void removeNotification(List<ActionItem> actionItems);
}
