/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.rule;

import org.kuali.rice.core.api.uif.RemotableAttributeErrorContract;

import java.util.List;



/**
 * An interface which can be implemented by a {@link WorkflowRuleAttribute} to allow for
 * validation of client routing data.
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public interface WorkflowAttributeXmlValidator {

    /**
     * called after client has set properties on the attribute for 'xmlizing'.  Returns 
     * @return List<? extends AttributeError> objects
     */
    public List<? extends RemotableAttributeErrorContract> validateClientRoutingData();
    
}
