/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.xml;

import org.kuali.rice.core.api.exception.RiceRuntimeException;
import org.kuali.rice.core.framework.impex.xml.XmlLoader;

import java.io.InputStream;

public class UserXmlServiceImpl implements XmlLoader {

    @Override
    public void loadXml(InputStream inputStream, String principalId) {
        UserXmlParser parser = new UserXmlParser();
        try {
            parser.parseUsers(inputStream);
        } catch (Exception e) {
            throw new RiceRuntimeException("Error loading xml file", e);
        }
    }

}
