/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.notes.service.impl;

import java.util.List;
import org.kuali.rice.kew.notes.Attachment;
import org.kuali.rice.kew.notes.Note;
import org.kuali.rice.kew.notes.dao.NoteDAO;
import org.kuali.rice.kew.notes.service.AttachmentService;
import org.kuali.rice.kew.notes.service.NoteService;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.data.PersistenceOption;
import org.springframework.beans.factory.annotation.Required;

public class NoteServiceImpl
implements NoteService {
    private NoteDAO noteDAO;
    private AttachmentService attachmentService;
    private DataObjectService dataObjectService;

    @Override
    public Note getNoteByNoteId(String noteId) {
        return (Note)this.getDataObjectService().find(Note.class, (Object)noteId);
    }

    @Override
    public List<Note> getNotesByDocumentId(String documentId) {
        return this.getNoteDAO().getNotesByDocumentId(documentId);
    }

    @Override
    public Note saveNote(Note note) {
        try {
            if (!note.getAttachments().isEmpty()) {
                for (Attachment attachment : note.getAttachments()) {
                    if (attachment.getAttachedObject() == null) continue;
                    this.attachmentService.persistAttachedFileAndSetAttachmentBusinessObjectValue(attachment);
                }
            }
            return (Note)this.getDataObjectService().save((Object)note, new PersistenceOption[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void deleteNote(Note note) {
        try {
            if (note != null && !note.getAttachments().isEmpty()) {
                for (Attachment attachment : note.getAttachments()) {
                    this.attachmentService.deleteAttachedFile(attachment);
                }
            }
            if (note != null) {
                this.getDataObjectService().delete((Object)note);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("caught exception deleting attachment", e);
        }
    }

    @Override
    public void deleteAttachment(Attachment attachment) {
        this.getDataObjectService().delete((Object)attachment);
        try {
            this.attachmentService.deleteAttachedFile(attachment);
        }
        catch (Exception e) {
            throw new RuntimeException("caught exception deleting attachment", e);
        }
    }

    @Override
    public byte[] findAttachmentFile(Attachment attachment) {
        try {
            return this.attachmentService.findAttachedFile(attachment);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Attachment findAttachment(String attachmentId) {
        return (Attachment)this.getDataObjectService().find(Attachment.class, (Object)attachmentId);
    }

    public AttachmentService getAttachmentService() {
        return this.attachmentService;
    }

    public void setAttachmentService(AttachmentService attachmentService) {
        this.attachmentService = attachmentService;
    }

    public DataObjectService getDataObjectService() {
        return this.dataObjectService;
    }

    @Required
    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }

    public NoteDAO getNoteDAO() {
        return this.noteDAO;
    }

    public void setNoteDAO(NoteDAO noteDAO) {
        this.noteDAO = noteDAO;
    }
}

