/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.rule.dao.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Subquery;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.criteria.Predicate;
import org.kuali.rice.core.api.criteria.PredicateFactory;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.core.api.exception.RiceRuntimeException;
import org.kuali.rice.kew.rule.RuleBaseValues;
import org.kuali.rice.kew.rule.RuleDelegationBo;
import org.kuali.rice.kew.rule.RuleExtensionBo;
import org.kuali.rice.kew.rule.RuleResponsibilityBo;
import org.kuali.rice.kew.rule.dao.RuleDelegationDAO;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.data.PersistenceOption;
import org.springframework.beans.factory.annotation.Required;

public class RuleDelegationDAOJpa
implements RuleDelegationDAO {
    private EntityManager entityManager;
    private DataObjectService dataObjectService;

    @Override
    public List<RuleDelegationBo> findByDelegateRuleId(String ruleId) {
        QueryByCriteria.Builder builder = QueryByCriteria.Builder.create();
        builder.setPredicates(new Predicate[]{PredicateFactory.equal((String)"delegateRuleId", (Object)ruleId)});
        return this.getDataObjectService().findMatching(RuleDelegationBo.class, builder.build()).getResults();
    }

    @Override
    public void save(RuleDelegationBo ruleDelegation) {
        this.getDataObjectService().save((Object)ruleDelegation, new PersistenceOption[0]);
    }

    @Override
    public List<RuleDelegationBo> findAllCurrentRuleDelegations() {
        QueryByCriteria.Builder builder = QueryByCriteria.Builder.create();
        builder.setPredicates(new Predicate[]{PredicateFactory.equal((String)"delegationRule.currentInd", (Object)true)});
        return this.getDataObjectService().findMatching(RuleDelegationBo.class, builder.build()).getResults();
    }

    @Override
    public RuleDelegationBo findByRuleDelegationId(String ruleDelegationId) {
        return (RuleDelegationBo)((Object)this.getDataObjectService().find(RuleDelegationBo.class, (Object)ruleDelegationId));
    }

    @Override
    public void delete(String ruleDelegationId) {
        this.getDataObjectService().delete((Object)this.findByRuleDelegationId(ruleDelegationId));
    }

    @Override
    public List<RuleDelegationBo> findByResponsibilityIdWithCurrentRule(String responsibilityId) {
        if (StringUtils.isBlank((String)responsibilityId)) {
            return null;
        }
        QueryByCriteria.Builder builder = QueryByCriteria.Builder.create();
        builder.setPredicates(new Predicate[]{PredicateFactory.equal((String)"delegationRule.currentInd", (Object)true), PredicateFactory.equal((String)"responsibilityId", (Object)responsibilityId)});
        return this.getDataObjectService().findMatching(RuleDelegationBo.class, builder.build()).getResults();
    }

    private Subquery<RuleResponsibilityBo> getResponsibilitySubQuery(String ruleResponsibilityName, CriteriaQuery<RuleBaseValues> query) {
        CriteriaBuilder criteriaBuilder = this.getEntityManager().getCriteriaBuilder();
        Subquery ruleResponsibilitySubquery = query.subquery(RuleResponsibilityBo.class);
        Root fromResp = ruleResponsibilitySubquery.from(RuleResponsibilityBo.class);
        ruleResponsibilitySubquery.where((Expression)criteriaBuilder.equal((Expression)fromResp.get("ruleResponsibilityName"), (Object)ruleResponsibilityName));
        ruleResponsibilitySubquery.select((Expression)fromResp.get("ruleBaseValuesId"));
        return ruleResponsibilitySubquery;
    }

    private Subquery<RuleResponsibilityBo> getResponsibilitySubQuery(CriteriaQuery<RuleBaseValues> query, Collection<String> kimGroupIds, String principalId, Boolean searchUser, Boolean searchUserInWorkgroups) {
        ArrayList<String> workgroupIdStrings = new ArrayList<String>();
        for (String workgroupId : kimGroupIds) {
            workgroupIdStrings.add(workgroupId.toString());
        }
        return this.getResponsibilitySubQuery(query, workgroupIdStrings, principalId, new ArrayList(), searchUser, searchUserInWorkgroups);
    }

    private Subquery<RuleResponsibilityBo> getResponsibilitySubQuery(CriteriaQuery<RuleBaseValues> query, Collection<String> workgroupIds, String principalId, Collection actionRequestCodes, Boolean searchUser, Boolean searchUserInWorkgroups) {
        javax.persistence.criteria.Predicate[] preds;
        Path exp;
        CriteriaBuilder criteriaBuilder = this.getEntityManager().getCriteriaBuilder();
        Subquery ruleResponsibilityBoSubquery = query.subquery(RuleResponsibilityBo.class);
        Root fromResp = ruleResponsibilityBoSubquery.from(RuleResponsibilityBo.class);
        ArrayList<javax.persistence.criteria.Predicate> respPredicates = new ArrayList<javax.persistence.criteria.Predicate>();
        ArrayList<javax.persistence.criteria.Predicate> ruleRespNamePredicates = new ArrayList<javax.persistence.criteria.Predicate>();
        ArrayList<javax.persistence.criteria.Predicate> userNamePreds = new ArrayList<javax.persistence.criteria.Predicate>();
        ArrayList<javax.persistence.criteria.Predicate> workgroupPreds = new ArrayList<javax.persistence.criteria.Predicate>();
        if (actionRequestCodes != null && !actionRequestCodes.isEmpty()) {
            exp = fromResp.get("actionRequestedCd");
            javax.persistence.criteria.Predicate actionRequestPredicate = exp.in(actionRequestCodes);
            respPredicates.add(actionRequestPredicate);
        }
        if (!StringUtils.isEmpty((String)principalId)) {
            if (searchUser != null && searchUser.booleanValue()) {
                userNamePreds.add(criteriaBuilder.like((Expression)fromResp.get("ruleResponsibilityName"), principalId));
                userNamePreds.add(criteriaBuilder.equal((Expression)fromResp.get("ruleResponsibilityType"), (Object)"F"));
                preds = userNamePreds.toArray(new javax.persistence.criteria.Predicate[userNamePreds.size()]);
                ruleRespNamePredicates.add(criteriaBuilder.and(preds));
            }
            if (searchUserInWorkgroups != null && searchUserInWorkgroups.booleanValue() && workgroupIds != null && !workgroupIds.isEmpty()) {
                exp = fromResp.get("ruleResponsibilityName");
                groupIdPredicate = exp.in(workgroupIds);
                workgroupPreds.add(groupIdPredicate);
                workgroupPreds.add(criteriaBuilder.equal((Expression)fromResp.get("ruleResponsibilityType"), (Object)"G"));
                javax.persistence.criteria.Predicate[] preds2 = workgroupPreds.toArray(new javax.persistence.criteria.Predicate[workgroupPreds.size()]);
                ruleRespNamePredicates.add(criteriaBuilder.and(preds2));
            }
        } else if (workgroupIds != null && workgroupIds.size() == 1) {
            workgroupPreds.add(criteriaBuilder.like((Expression)fromResp.get("ruleResponsibilityName"), workgroupIds.iterator().next()));
            workgroupPreds.add(criteriaBuilder.equal((Expression)fromResp.get("ruleResponsibilityType"), (Object)"G"));
            preds = workgroupPreds.toArray(new javax.persistence.criteria.Predicate[workgroupPreds.size()]);
            ruleRespNamePredicates.add(criteriaBuilder.and(preds));
        } else if (workgroupIds != null && workgroupIds.size() > 1) {
            exp = fromResp.get("ruleResponsibilityName");
            groupIdPredicate = exp.in(workgroupIds);
            workgroupPreds.add(criteriaBuilder.equal((Expression)fromResp.get("ruleResponsibilityType"), (Object)"G"));
            javax.persistence.criteria.Predicate[] preds3 = workgroupPreds.toArray(new javax.persistence.criteria.Predicate[workgroupPreds.size()]);
            ruleRespNamePredicates.add(criteriaBuilder.and(preds3));
        }
        if (!ruleRespNamePredicates.isEmpty()) {
            preds = ruleRespNamePredicates.toArray(new javax.persistence.criteria.Predicate[ruleRespNamePredicates.size()]);
            respPredicates.add(criteriaBuilder.or(preds));
        }
        if (!respPredicates.isEmpty()) {
            preds = respPredicates.toArray(new javax.persistence.criteria.Predicate[respPredicates.size()]);
            ruleResponsibilityBoSubquery.where(preds);
            ruleResponsibilityBoSubquery.select((Expression)fromResp.get("ruleBaseValuesId"));
            return ruleResponsibilityBoSubquery;
        }
        return null;
    }

    private Subquery<RuleBaseValues> getRuleBaseValuesSubQuery(String docTypeName, String ruleTemplateId, String ruleDescription, Collection<String> workgroupIds, String principalId, Boolean activeInd, Map<String, String> extensionValues, Collection actionRequestCodes, CriteriaQuery<RuleDelegationBo> query) {
        CriteriaBuilder criteriaBuilder = this.getEntityManager().getCriteriaBuilder();
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(RuleBaseValues.class);
        Subquery ruleBaseValuesSubquery = query.subquery(RuleBaseValues.class);
        Root root = ruleBaseValuesSubquery.from(RuleBaseValues.class);
        List<javax.persistence.criteria.Predicate> predicates = this.getSearchCriteria((Root<RuleBaseValues>)root, (CriteriaQuery<RuleBaseValues>)criteriaQuery, docTypeName, ruleTemplateId, ruleDescription, activeInd, extensionValues);
        Subquery<RuleResponsibilityBo> subquery = this.getResponsibilitySubQuery((CriteriaQuery<RuleBaseValues>)criteriaQuery, workgroupIds, principalId, actionRequestCodes, principalId != null, workgroupIds != null && !workgroupIds.isEmpty());
        predicates.add((javax.persistence.criteria.Predicate)criteriaBuilder.in((Expression)root.get("id")).value(subquery));
        ruleBaseValuesSubquery.where((Expression)criteriaBuilder.equal((Expression)root.get("delegateRule"), (Object)Boolean.TRUE));
        ruleBaseValuesSubquery.select((Expression)root.get("id"));
        return ruleBaseValuesSubquery;
    }

    private Subquery<RuleBaseValues> getRuleBaseValuesSubQuery(String docTypeName, String ruleId, String ruleTemplateId, String ruleDescription, String workgroupId, String principalId, Boolean activeInd, Map<String, String> extensionValues, String workflowIdDirective, CriteriaQuery<RuleDelegationBo> query) {
        CriteriaBuilder criteriaBuilder = this.getEntityManager().getCriteriaBuilder();
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(RuleBaseValues.class);
        Subquery ruleBaseValuesSubquery = query.subquery(RuleBaseValues.class);
        Root fromResp = ruleBaseValuesSubquery.from(RuleBaseValues.class);
        List<javax.persistence.criteria.Predicate> predicates = this.getSearchCriteria((Root<RuleBaseValues>)fromResp, (CriteriaQuery<RuleBaseValues>)criteriaQuery, docTypeName, ruleTemplateId, ruleDescription, activeInd, extensionValues);
        if (ruleId != null) {
            predicates.add(criteriaBuilder.equal((Expression)fromResp.get("id"), (Object)ruleId));
        }
        if (workgroupId != null) {
            predicates.add((javax.persistence.criteria.Predicate)criteriaBuilder.in((Expression)fromResp.get("id")).value(this.getResponsibilitySubQuery(workgroupId, (CriteriaQuery<RuleBaseValues>)criteriaQuery)));
        }
        Collection<String> kimGroupIds = new HashSet<String>();
        Boolean searchUser = Boolean.FALSE;
        Boolean searchUserInWorkgroups = Boolean.FALSE;
        if ("group".equals(workflowIdDirective)) {
            searchUserInWorkgroups = Boolean.TRUE;
        } else if (StringUtils.isBlank((String)workflowIdDirective)) {
            searchUser = Boolean.TRUE;
            searchUserInWorkgroups = Boolean.TRUE;
        } else {
            searchUser = Boolean.TRUE;
        }
        if (!StringUtils.isEmpty((String)principalId) && searchUserInWorkgroups.booleanValue()) {
            Principal principal = null;
            principal = KimApiServiceLocator.getIdentityService().getPrincipal(principalId);
            if (principal == null) {
                throw new RiceRuntimeException("Failed to locate user for the given principal id: " + principalId);
            }
            kimGroupIds = KimApiServiceLocator.getGroupService().getGroupIdsByPrincipalId(principalId);
        }
        Subquery<RuleResponsibilityBo> subquery = this.getResponsibilitySubQuery((CriteriaQuery<RuleBaseValues>)criteriaQuery, kimGroupIds, principalId, searchUser, searchUserInWorkgroups);
        if (CollectionUtils.isNotEmpty(kimGroupIds) || StringUtils.isNotBlank((String)principalId)) {
            predicates.add((javax.persistence.criteria.Predicate)criteriaBuilder.in((Expression)fromResp.get("id")).value(subquery));
        }
        predicates.add(criteriaBuilder.equal((Expression)fromResp.get("delegateRule"), (Object)Boolean.TRUE));
        javax.persistence.criteria.Predicate[] preds = predicates.toArray(new javax.persistence.criteria.Predicate[predicates.size()]);
        ruleBaseValuesSubquery.where(preds);
        ruleBaseValuesSubquery.select((Expression)fromResp.get("id"));
        return ruleBaseValuesSubquery;
    }

    private Subquery<RuleResponsibilityBo> getRuleResponsibilitySubQuery(Long ruleBaseValuesId, CriteriaQuery<RuleDelegationBo> query) {
        CriteriaBuilder criteriaBuilder = this.getEntityManager().getCriteriaBuilder();
        Subquery ruleResponsibilityBoSubquery = query.subquery(RuleResponsibilityBo.class);
        Root fromResp = ruleResponsibilityBoSubquery.from(RuleResponsibilityBo.class);
        ruleResponsibilityBoSubquery.where((Expression)criteriaBuilder.equal((Expression)fromResp.get("ruleBaseValuesId"), (Object)ruleBaseValuesId));
        ruleResponsibilityBoSubquery.select((Expression)fromResp.get("responsibilityId"));
        return ruleResponsibilityBoSubquery;
    }

    private List<javax.persistence.criteria.Predicate> getSearchCriteria(Root<RuleBaseValues> root, CriteriaQuery<RuleBaseValues> query, String docTypeName, String ruleTemplateId, String ruleDescription, Boolean activeInd, Map<String, String> extensionValues) {
        ArrayList<javax.persistence.criteria.Predicate> predicates = new ArrayList<javax.persistence.criteria.Predicate>();
        CriteriaBuilder criteribaBuilder = this.getEntityManager().getCriteriaBuilder();
        predicates.add(criteribaBuilder.equal((Expression)root.get("currentInd"), (Object)Boolean.TRUE));
        predicates.add(criteribaBuilder.equal((Expression)root.get("templateRuleInd"), (Object)Boolean.FALSE));
        if (activeInd != null) {
            predicates.add(criteribaBuilder.equal((Expression)root.get("active"), (Object)activeInd));
        }
        if (docTypeName != null) {
            predicates.add(criteribaBuilder.like(criteribaBuilder.upper((Expression)root.get("docTypeName")), docTypeName.toUpperCase()));
        }
        if (ruleDescription != null && !ruleDescription.trim().equals("")) {
            predicates.add(criteribaBuilder.like(criteribaBuilder.upper((Expression)root.get("description")), ruleDescription.toUpperCase()));
        }
        if (ruleTemplateId != null) {
            predicates.add(criteribaBuilder.equal((Expression)root.get("ruleTemplateId"), (Object)ruleTemplateId));
        }
        if (extensionValues != null && !extensionValues.isEmpty()) {
            for (Map.Entry<String, String> entry : extensionValues.entrySet()) {
                if (StringUtils.isEmpty((String)entry.getValue())) continue;
                Subquery ruleExtSubQuery = query.subquery(RuleExtensionBo.class);
                Root ruleExtRoot = ruleExtSubQuery.from(RuleExtensionBo.class);
                javax.persistence.criteria.Predicate predAnd = criteribaBuilder.and((Expression)criteribaBuilder.equal((Expression)ruleExtRoot.get("extensionValues").get("key"), (Object)entry.getKey()), (Expression)criteribaBuilder.like((Expression)ruleExtRoot.get("extensionValues").get("value"), ("%" + entry.getValue() + "%").toUpperCase()));
                ruleExtSubQuery.where((Expression)predAnd);
                ruleExtSubQuery.select((Expression)ruleExtRoot.get("ruleBaseValuesId"));
                predicates.add((javax.persistence.criteria.Predicate)criteribaBuilder.in((Expression)root.get("id")).value((Expression)ruleExtSubQuery));
            }
        }
        return predicates;
    }

    @Override
    public List<RuleDelegationBo> search(String parentRuleBaseVaueId, String parentResponsibilityId, String docTypeName, String ruleId, String ruleTemplateId, String ruleDescription, String workgroupId, String principalId, String delegationType, Boolean activeInd, Map extensionValues, String workflowIdDirective) {
        Subquery<RuleBaseValues> ruleBaseValuesSubQuery;
        CriteriaBuilder criteriaBuilder = this.getEntityManager().getCriteriaBuilder();
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(RuleDelegationBo.class);
        Root root = criteriaQuery.from(RuleDelegationBo.class);
        ArrayList<Object> predicates = new ArrayList<Object>();
        if (StringUtils.isNotBlank((String)delegationType) && !delegationType.equals("E")) {
            predicates.add(criteriaBuilder.equal((Expression)root.get("delegationTypeCode"), (Object)delegationType));
        }
        if (StringUtils.isNotBlank((String)parentResponsibilityId) && StringUtils.isNumeric((String)parentResponsibilityId)) {
            predicates.add(criteriaBuilder.equal((Expression)root.get("responsibilityId"), (Object)parentResponsibilityId));
        }
        if (StringUtils.isNotBlank((String)parentRuleBaseVaueId) && StringUtils.isNumeric((String)parentRuleBaseVaueId)) {
            predicates.add(criteriaBuilder.in((Expression)root.get("responsibilityId")).value(this.getRuleResponsibilitySubQuery(new Long(parentRuleBaseVaueId), (CriteriaQuery<RuleDelegationBo>)criteriaQuery)));
        }
        if ((ruleBaseValuesSubQuery = this.getRuleBaseValuesSubQuery(docTypeName, ruleId, ruleTemplateId, ruleDescription, workgroupId, principalId, activeInd, extensionValues, workflowIdDirective, (CriteriaQuery<RuleDelegationBo>)criteriaQuery)) != null) {
            predicates.add(criteriaBuilder.in((Expression)root.get("delegateRuleId")).value(ruleBaseValuesSubQuery));
        }
        criteriaQuery.distinct(true);
        javax.persistence.criteria.Predicate[] preds = predicates.toArray(new javax.persistence.criteria.Predicate[predicates.size()]);
        criteriaQuery.where(preds);
        TypedQuery typedQuery = this.getEntityManager().createQuery(criteriaQuery);
        typedQuery.setMaxResults(500);
        return typedQuery.getResultList();
    }

    @Override
    public List<RuleDelegationBo> search(String parentRuleBaseVaueId, String parentResponsibilityId, String docTypeName, String ruleTemplateId, String ruleDescription, Collection<String> workgroupIds, String principalId, String delegationType, Boolean activeInd, Map extensionValues, Collection actionRequestCodes) {
        Subquery<RuleBaseValues> ruleBaseValuesSubQuery;
        CriteriaBuilder criteriaBuilder = this.getEntityManager().getCriteriaBuilder();
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(RuleDelegationBo.class);
        Root root = criteriaQuery.from(RuleDelegationBo.class);
        ArrayList<Object> predicates = new ArrayList<Object>();
        if (StringUtils.isNotBlank((String)delegationType) && !delegationType.equals("E")) {
            predicates.add(criteriaBuilder.equal((Expression)root.get("delegationTypeCode"), (Object)delegationType));
        }
        if (StringUtils.isNotBlank((String)parentResponsibilityId) && StringUtils.isNumeric((String)parentResponsibilityId)) {
            predicates.add(criteriaBuilder.equal((Expression)root.get("responsibilityId"), (Object)parentResponsibilityId));
        }
        if (StringUtils.isNotBlank((String)parentRuleBaseVaueId) && StringUtils.isNumeric((String)parentRuleBaseVaueId)) {
            predicates.add(criteriaBuilder.in((Expression)root.get("responsibilityId")).value(this.getRuleResponsibilitySubQuery(new Long(parentRuleBaseVaueId), (CriteriaQuery<RuleDelegationBo>)criteriaQuery)));
        }
        if ((ruleBaseValuesSubQuery = this.getRuleBaseValuesSubQuery(docTypeName, ruleTemplateId, ruleDescription, workgroupIds, principalId, activeInd, extensionValues, actionRequestCodes, (CriteriaQuery<RuleDelegationBo>)criteriaQuery)) != null) {
            predicates.add(criteriaBuilder.in((Expression)root.get("delegateRuleId")).value(ruleBaseValuesSubQuery));
        }
        criteriaQuery.distinct(true);
        TypedQuery typedQuery = this.getEntityManager().createQuery(criteriaQuery);
        typedQuery.setMaxResults(500);
        return typedQuery.getResultList();
    }

    public DataObjectService getDataObjectService() {
        return this.dataObjectService;
    }

    @Required
    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }

    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }
}

