/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.superuser.web;

import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.rice.kew.actionrequest.ActionRequestValue;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.WorkflowDocumentFactory;
import org.kuali.rice.kew.api.action.ActionRequestType;
import org.kuali.rice.kew.api.action.AdHocRevoke;
import org.kuali.rice.kew.api.action.DocumentActionParameters;
import org.kuali.rice.kew.api.action.ReturnPoint;
import org.kuali.rice.kew.api.action.WorkflowDocumentActionsService;
import org.kuali.rice.kew.api.document.WorkflowDocumentService;
import org.kuali.rice.kew.api.document.node.RouteNodeInstance;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kew.doctype.bo.DocumentType;
import org.kuali.rice.kew.exception.WorkflowServiceErrorException;
import org.kuali.rice.kew.exception.WorkflowServiceErrorImpl;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kew.superuser.web.SuperUserForm;
import org.kuali.rice.kew.web.AppSpecificRouteRecipient;
import org.kuali.rice.kew.web.KewKualiAction;
import org.kuali.rice.kim.api.group.GroupService;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.krad.UserSession;
import org.kuali.rice.krad.exception.ValidationException;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.ksb.api.KsbApiServiceLocator;

public class SuperUserAction
extends KewKualiAction {
    private static final Logger LOG = LogManager.getLogger(SuperUserAction.class);
    public static final String UNAUTHORIZED = "authorizationFailure";

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.initForm(request, form);
        return super.execute(mapping, form, request, response);
    }

    public ActionForward refresh(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ((SuperUserForm)form).getActionRequests().clear();
        this.initForm(request, form);
        return this.defaultDispatch(mapping, form, request, response);
    }

    public ActionForward displaySuperUserDocument(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        SuperUserForm superUserForm = (SuperUserForm)form;
        superUserForm.setDocHandlerUrl("DocHandler.do?docId=" + superUserForm.getDocumentId() + "&command=displaySuperUserView");
        return this.defaultDispatch(mapping, form, request, response);
    }

    public ActionForward routeLevelApprove(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        LOG.info("entering routeLevelApprove()...");
        SuperUserForm superUserForm = (SuperUserForm)form;
        String documentId = superUserForm.getRouteHeader().getDocumentId();
        WorkflowDocumentActionsService documentActions = this.getWorkflowDocumentActionsService(documentId);
        DocumentActionParameters parameters = DocumentActionParameters.create((String)documentId, (String)SuperUserAction.getUserSession(request).getPrincipalId(), (String)superUserForm.getAnnotation());
        documentActions.superUserNodeApprove(parameters, superUserForm.isRunPostProcessorLogic(), superUserForm.getDestNodeName());
        this.saveDocumentMessage("general.routing.superuser.routeLevelApproved", request, superUserForm.getDocumentId(), null);
        LOG.info("exiting routeLevelApprove()...");
        superUserForm.getActionRequests().clear();
        this.initForm(request, form);
        return this.defaultDispatch(mapping, form, request, response);
    }

    public ActionForward approve(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        LOG.info("entering approve() ...");
        SuperUserForm superUserForm = (SuperUserForm)form;
        String documentId = superUserForm.getRouteHeader().getDocumentId();
        WorkflowDocumentActionsService documentActions = this.getWorkflowDocumentActionsService(documentId);
        DocumentActionParameters parameters = DocumentActionParameters.create((String)documentId, (String)SuperUserAction.getUserSession(request).getPrincipalId(), (String)superUserForm.getAnnotation());
        documentActions.superUserBlanketApprove(parameters, superUserForm.isRunPostProcessorLogic());
        this.saveDocumentMessage("general.routing.superuser.approved", request, superUserForm.getDocumentId(), null);
        LOG.info("exiting approve() ...");
        superUserForm.getActionRequests().clear();
        this.initForm(request, form);
        return this.defaultDispatch(mapping, form, request, response);
    }

    public ActionForward disapprove(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        LOG.info("entering disapprove() ...");
        SuperUserForm superUserForm = (SuperUserForm)form;
        String documentId = superUserForm.getRouteHeader().getDocumentId();
        WorkflowDocumentActionsService documentActions = this.getWorkflowDocumentActionsService(documentId);
        DocumentActionParameters parameters = DocumentActionParameters.create((String)documentId, (String)SuperUserAction.getUserSession(request).getPrincipalId(), (String)superUserForm.getAnnotation());
        documentActions.superUserDisapprove(parameters, superUserForm.isRunPostProcessorLogic());
        this.saveDocumentMessage("general.routing.superuser.disapproved", request, superUserForm.getDocumentId(), null);
        LOG.info("exiting disapprove() ...");
        superUserForm.getActionRequests().clear();
        this.initForm(request, form);
        return this.defaultDispatch(mapping, form, request, response);
    }

    public ActionForward cancel(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        LOG.info("entering cancel() ...");
        SuperUserForm superUserForm = (SuperUserForm)form;
        String documentId = superUserForm.getRouteHeader().getDocumentId();
        WorkflowDocumentActionsService documentActions = this.getWorkflowDocumentActionsService(documentId);
        DocumentActionParameters parameters = DocumentActionParameters.create((String)documentId, (String)SuperUserAction.getUserSession(request).getPrincipalId(), (String)superUserForm.getAnnotation());
        documentActions.superUserCancel(parameters, superUserForm.isRunPostProcessorLogic());
        this.saveDocumentMessage("general.routing.superuser.canceled", request, superUserForm.getDocumentId(), null);
        LOG.info("exiting cancel() ...");
        superUserForm.getActionRequests().clear();
        this.initForm(request, form);
        return this.defaultDispatch(mapping, form, request, response);
    }

    public ActionForward returnToPreviousNode(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        LOG.info("entering returnToPreviousNode() ...");
        SuperUserForm superUserForm = (SuperUserForm)form;
        String documentId = superUserForm.getRouteHeader().getDocumentId();
        WorkflowDocumentActionsService documentActions = this.getWorkflowDocumentActionsService(documentId);
        DocumentActionParameters parameters = DocumentActionParameters.create((String)documentId, (String)SuperUserAction.getUserSession(request).getPrincipalId(), (String)superUserForm.getAnnotation());
        documentActions.superUserReturnToPreviousNode(parameters, superUserForm.isRunPostProcessorLogic(), ReturnPoint.create((String)superUserForm.getReturnDestNodeName()));
        this.saveDocumentMessage("general.routing.returnedToPreviousNode", request, "document", superUserForm.getReturnDestNodeName().toString());
        LOG.info("exiting returnToPreviousRouteLevel() ...");
        superUserForm.getActionRequests().clear();
        this.initForm(request, form);
        return this.defaultDispatch(mapping, form, request, response);
    }

    public ActionForward actionRequestApprove(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        LOG.info("entering actionRequestApprove() ...");
        SuperUserForm superUserForm = (SuperUserForm)form;
        String methodToCallAttr = (String)request.getAttribute("methodToCallAttribute");
        superUserForm.setActionTakenRecipientCode(StringUtils.substringBetween((String)methodToCallAttr, (String)"(((", (String)")))"));
        superUserForm.setActionTakenNetworkId(StringUtils.substringBetween((String)methodToCallAttr, (String)"((`", (String)"`))"));
        superUserForm.setActionTakenWorkGroupId(StringUtils.substringBetween((String)methodToCallAttr, (String)"(([", (String)"]))"));
        superUserForm.setActionTakenActionRequestId(StringUtils.substringBetween((String)methodToCallAttr, (String)"((*", (String)"*))"));
        LOG.debug("Routing super user action request approve action");
        boolean runPostProcessorLogic = ArrayUtils.contains((Object[])superUserForm.getActionRequestRunPostProcessorCheck(), (Object)superUserForm.getActionTakenActionRequestId());
        String documentId = superUserForm.getRouteHeader().getDocumentId();
        WorkflowDocumentActionsService documentActions = this.getWorkflowDocumentActionsService(documentId);
        DocumentActionParameters parameters = DocumentActionParameters.create((String)documentId, (String)SuperUserAction.getUserSession(request).getPrincipalId(), (String)superUserForm.getAnnotation());
        documentActions.superUserTakeRequestedAction(parameters, runPostProcessorLogic, superUserForm.getActionTakenActionRequestId());
        String actionReqest = StringUtils.substringBetween((String)methodToCallAttr, (String)"((%", (String)"%))");
        String messageString = actionReqest.equalsIgnoreCase("acknowledge") ? "general.routing.superuser.actionRequestAcknowledged" : (actionReqest.equalsIgnoreCase("FYI") ? "general.routing.superuser.actionRequestFYI" : (actionReqest.equalsIgnoreCase("complete") ? "general.routing.superuser.actionRequestCompleted" : (actionReqest.equalsIgnoreCase("approved") ? "general.routing.superuser.actionRequestApproved" : "general.routing.superuser.actionRequestApproved")));
        this.saveDocumentMessage(messageString, request, superUserForm.getDocumentId(), superUserForm.getActionTakenActionRequestId());
        LOG.info("exiting actionRequestApprove() ...");
        superUserForm.getActionRequests().clear();
        this.initForm(request, form);
        int removalIndex = this.findAppSpecificRecipientIndex(superUserForm, superUserForm.getActionTakenActionRequestId());
        if (removalIndex >= 0) {
            superUserForm.getAppSpecificRouteList().remove(removalIndex);
        }
        return this.defaultDispatch(mapping, form, request, response);
    }

    private int findAppSpecificRecipientIndex(SuperUserForm superUserForm, String actionRequestId) {
        int tempIndex = 0;
        Iterator appRouteIter = superUserForm.getAppSpecificRouteList().iterator();
        while (appRouteIter.hasNext()) {
            String tempActnReqId = ((AppSpecificRouteRecipient)appRouteIter.next()).getActionRequestId();
            if (StringUtils.equals((String)tempActnReqId, (String)actionRequestId)) {
                return tempIndex;
            }
            ++tempIndex;
        }
        return -1;
    }

    public ActionForward initForm(HttpServletRequest request, ActionForm form) throws Exception {
        request.setAttribute("Constants", this.getServlet().getServletContext().getAttribute("KewApiConstants"));
        SuperUserForm superUserForm = (SuperUserForm)form;
        DocumentRouteHeaderValue routeHeader = KEWServiceLocator.getRouteHeaderService().getRouteHeader(superUserForm.getDocumentId());
        if (routeHeader == null) {
            throw new ValidationException("No route header ID found.  Try searching for the document again using the super user document search.");
        }
        superUserForm.setRouteHeader(routeHeader);
        String principalId = SuperUserAction.getUserSession(request).getPrincipalId();
        boolean isAuthorized = KEWServiceLocator.getDocumentTypePermissionService().canAdministerRouting(principalId, routeHeader.getDocumentType());
        superUserForm.setAuthorized(isAuthorized);
        if (!isAuthorized) {
            this.saveDocumentMessage("general.routing.superuser.notAuthorized", request, superUserForm.getDocumentId(), null);
            return null;
        }
        superUserForm.setFutureNodeNames(KEWServiceLocator.getRouteNodeService().findFutureNodeNames(routeHeader.getDocumentId()));
        List<ActionRequestValue> actionRequests = KEWServiceLocator.getActionRequestService().findPendingByDoc(routeHeader.getDocumentId());
        for (ActionRequestValue req : actionRequests) {
            superUserForm.getActionRequests().add(req);
        }
        superUserForm.setDocId(superUserForm.getDocumentId());
        if (superUserForm.getDocId() != null) {
            superUserForm.setWorkflowDocument(WorkflowDocumentFactory.loadDocument((String)SuperUserAction.getUserSession(request).getPrincipalId(), (String)superUserForm.getDocId()));
            superUserForm.establishVisibleActionRequestCds();
        }
        return null;
    }

    private void saveDocumentMessage(String messageKey, HttpServletRequest request, String subVariable1, String subVariable2) {
        if (subVariable2 == null) {
            GlobalVariables.getMessageMap().putInfo("document", messageKey, new String[]{subVariable1});
        } else {
            GlobalVariables.getMessageMap().putInfo("document", messageKey, new String[]{subVariable1, subVariable2});
        }
    }

    public ActionForward routeToAppSpecificRecipient(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        SuperUserForm superUserForm = (SuperUserForm)form;
        String routeType = StringUtils.substringBetween((String)((String)request.getAttribute("methodToCallAttribute")), (String)"(((", (String)")))");
        AppSpecificRouteRecipient recipient = null;
        if ("person".equals(routeType)) {
            recipient = superUserForm.getAppSpecificRouteRecipient();
            recipient.setActionRequested(superUserForm.getAppSpecificRouteActionRequestCd());
            superUserForm.setAppSpecificPersonId(recipient.getId());
        } else {
            recipient = superUserForm.getAppSpecificRouteRecipient2();
            recipient.setActionRequested(superUserForm.getAppSpecificRouteActionRequestCd2());
            superUserForm.setAppSpecificWorkgroupId(recipient.getId());
        }
        this.validateAppSpecificRoute(recipient);
        superUserForm.establishVisibleActionRequestCds();
        if (superUserForm.getAppSpecificRouteActionRequestCds().get(recipient.getActionRequested()) == null) {
            GlobalVariables.getMessageMap().putError("appSpecificRouteRecipient" + ("workgroup".equals(recipient.getType()) ? "2" : "") + ".id", "appspecificroute.actionrequested.invalid", new String[0]);
            throw new ValidationException("The requested action of '" + recipient.getActionRequested() + "' is no longer available for this document");
        }
        try {
            String routeNodeName = this.getAdHocRouteNodeName(superUserForm.getWorkflowDocument().getDocumentId());
            if ("person".equals(routeType)) {
                String recipientPrincipalId = KEWServiceLocator.getIdentityHelperService().getIdForPrincipalName(recipient.getId());
                superUserForm.getWorkflowDocument().adHocToPrincipal(ActionRequestType.fromCode((String)recipient.getActionRequested()), routeNodeName, superUserForm.getAnnotation(), recipientPrincipalId, "", true);
            } else {
                String recipientGroupId = KEWServiceLocator.getIdentityHelperService().getIdForGroupName(recipient.getNamespaceCode(), recipient.getId());
                superUserForm.getWorkflowDocument().adHocToGroup(ActionRequestType.fromCode((String)recipient.getActionRequested()), routeNodeName, superUserForm.getAnnotation(), recipientGroupId, "", true);
            }
        }
        catch (Exception e) {
            LOG.error("Error generating app specific route request", (Throwable)e);
            throw new WorkflowServiceErrorException("AppSpecific Route Error", (Throwable)e, new WorkflowServiceErrorImpl("AppSpecific Route Error", "appspecificroute.systemerror"));
        }
        superUserForm.getActionRequests().clear();
        this.initForm(request, form);
        ActionRequestValue latestActnReq = this.getLatestActionRequest(superUserForm);
        if (latestActnReq != null) {
            recipient.setActionRequestId(latestActnReq.getActionRequestId());
        }
        superUserForm.getAppSpecificRouteList().add(recipient);
        superUserForm.resetAppSpecificRoute();
        return this.start(mapping, form, request, response);
    }

    private ActionRequestValue getLatestActionRequest(SuperUserForm superUserForm) {
        ActionRequestValue latestActnReq = null;
        List<ActionRequestValue> actionRequests = superUserForm.getActionRequests();
        if (actionRequests != null && actionRequests.size() > 0) {
            Collections.sort(actionRequests, new Comparator<ActionRequestValue>(this){

                @Override
                public int compare(ActionRequestValue o1, ActionRequestValue o2) {
                    if (o1 == null && o2 == null) {
                        return 0;
                    }
                    if (o1 == null) {
                        return -1;
                    }
                    if (o2 == null) {
                        return 1;
                    }
                    if (o1.getCreateDate() == null && o2.getCreateDate() == null) {
                        return 0;
                    }
                    if (o1.getCreateDate() == null) {
                        return -1;
                    }
                    if (o2.getCreateDate() == null) {
                        return 1;
                    }
                    return o2.getCreateDate().compareTo(o1.getCreateDate());
                }
            });
            latestActnReq = actionRequests.get(0);
        }
        return latestActnReq;
    }

    public ActionForward removeAppSpecificRecipient(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        SuperUserForm superUserForm = (SuperUserForm)form;
        String strIndex = StringUtils.substringBetween((String)((String)request.getAttribute("methodToCallAttribute")), (String)"(((", (String)")))");
        if (StringUtils.isBlank((String)strIndex)) {
            throw new WorkflowException("No adhoc route recipient index specified");
        }
        int removeIndex = Integer.parseInt(strIndex);
        if (removeIndex < 0 || removeIndex >= superUserForm.getAppSpecificRouteList().size()) {
            throw new WorkflowException("Invalid adhoc route recipient index specified");
        }
        AppSpecificRouteRecipient removedRec = (AppSpecificRouteRecipient)superUserForm.getAppSpecificRouteList().get(removeIndex);
        if (removedRec.getActionRequestId() != null) {
            superUserForm.getWorkflowDocument().revokeAdHocRequestById(removedRec.getActionRequestId().toString(), "");
        } else {
            AdHocRevoke adHocRevoke = null;
            adHocRevoke = "person".equals(removedRec.getType()) ? AdHocRevoke.createRevokeFromPrincipal((String)KEWServiceLocator.getIdentityHelperService().getIdForPrincipalName(removedRec.getId())) : AdHocRevoke.createRevokeFromGroup((String)KEWServiceLocator.getIdentityHelperService().getIdForGroupName(removedRec.getNamespaceCode(), removedRec.getId()));
            superUserForm.getWorkflowDocument().revokeAdHocRequests(adHocRevoke, "");
        }
        superUserForm.getAppSpecificRouteList().remove(removeIndex);
        superUserForm.getActionRequests().clear();
        this.initForm(request, form);
        return this.start(mapping, form, request, response);
    }

    private WorkflowDocumentActionsService getWorkflowDocumentActionsService(String documentId) {
        DocumentType documentType = KEWServiceLocator.getDocumentTypeService().findByDocumentId(documentId);
        String applicationId = documentType.getApplicationId();
        QName serviceName = new QName("http://rice.kuali.org/kew/v2_0", "workflowDocumentActionsService");
        WorkflowDocumentActionsService service = (WorkflowDocumentActionsService)KsbApiServiceLocator.getServiceBus().getService(serviceName, applicationId);
        if (service == null) {
            service = KewApiServiceLocator.getWorkflowDocumentActionsService();
        }
        return service;
    }

    protected void validateAppSpecificRoute(AppSpecificRouteRecipient recipient) {
        if (recipient.getId() == null || recipient.getId().trim().equals("")) {
            GlobalVariables.getMessageMap().putError("appSpecificRouteRecipient" + ("workgroup".equals(recipient.getType()) ? "2" : "") + ".id", "appspecificroute.recipient.required", new String[0]);
        } else if ("person".equals(recipient.getType())) {
            Principal principal = KimApiServiceLocator.getIdentityService().getPrincipalByPrincipalName(recipient.getId());
            if (principal == null) {
                LOG.error("App Specific user recipient not found");
                GlobalVariables.getMessageMap().putError("appSpecificRouteRecipient.id", "appspecificroute.user.invalid", new String[0]);
            }
        } else if ("workgroup".equals(recipient.getType()) && this.getGroupService().getGroupByNamespaceCodeAndName(recipient.getNamespaceCode(), recipient.getId()) == null) {
            GlobalVariables.getMessageMap().putError("appSpecificRouteRecipient2.id", "appspecificroute.workgroup.invalid", new String[0]);
        }
        if (GlobalVariables.getMessageMap().hasErrors()) {
            throw new ValidationException("AppSpecific Route validation Errors");
        }
    }

    protected String getAdHocRouteNodeName(String documentId) throws WorkflowException {
        WorkflowDocumentService workflowDocumentService = KewApiServiceLocator.getWorkflowDocumentService();
        List nodeInstances = workflowDocumentService.getActiveRouteNodeInstances(documentId);
        if (nodeInstances == null || nodeInstances.isEmpty()) {
            nodeInstances = workflowDocumentService.getTerminalRouteNodeInstances(documentId);
        }
        if (nodeInstances == null || nodeInstances.isEmpty()) {
            throw new WorkflowException("Could not locate a node on the document to send the ad hoc request to.");
        }
        return ((RouteNodeInstance)nodeInstances.get(0)).getName();
    }

    private GroupService getGroupService() {
        return KimApiServiceLocator.getGroupService();
    }

    public static UserSession getUserSession(HttpServletRequest request) {
        return GlobalVariables.getUserSession();
    }
}

