/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.inquiry;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import org.kuali.rice.coreservice.impl.namespace.NamespaceBo;
import org.kuali.rice.kim.impl.role.RoleBo;
import org.kuali.rice.kim.impl.type.KimTypeBo;
import org.kuali.rice.kim.lookup.RoleLookupableHelperServiceImpl;
import org.kuali.rice.kns.inquiry.KualiInquirableImpl;
import org.kuali.rice.kns.lookup.HtmlData;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.data.KradDataServiceLocator;
import org.kuali.rice.krad.uif.widget.Inquiry;

public class RoleInquirableImpl
extends KualiInquirableImpl {
    protected final String ROLE_NAME = "name";
    protected final String ROLE_ID = "id";
    protected final String NAMESPACE_CODE = "namespaceCode";

    public void buildInquirableLink(Object dataObject, String propertyName, Inquiry inquiry) {
        if ("name".equals(propertyName)) {
            HashMap<String, String> primaryKeys = new HashMap<String, String>();
            primaryKeys.put("id", "id");
            inquiry.buildInquiryLink(dataObject, propertyName, RoleBo.class, primaryKeys);
        } else if ("namespaceCode".equals(propertyName)) {
            HashMap<String, String> primaryKeys = new HashMap<String, String>();
            primaryKeys.put(propertyName, "code");
            inquiry.buildInquiryLink(dataObject, propertyName, NamespaceBo.class, primaryKeys);
        } else if ("kimRoleType.name".equals(propertyName)) {
            HashMap<String, String> primaryKeys = new HashMap<String, String>();
            primaryKeys.put("kimRoleType.id", "id");
            inquiry.buildInquiryLink(dataObject, propertyName, KimTypeBo.class, primaryKeys);
        } else {
            super.buildInquirableLink(dataObject, propertyName, inquiry);
        }
    }

    public HtmlData getInquiryUrl(BusinessObject businessObject, String attributeName, boolean forceInquiry) {
        if ("name".equals(attributeName)) {
            ArrayList<String> primaryKeys = new ArrayList<String>();
            primaryKeys.add("id");
            String href = this.getInquiryUrlForPrimaryKeys(RoleBo.class, businessObject, primaryKeys, null).getHref();
            HtmlData.AnchorHtmlData htmlData = new HtmlData.AnchorHtmlData();
            htmlData.setHref(RoleLookupableHelperServiceImpl.getCustomRoleInquiryHref(href));
            return htmlData;
        }
        if ("namespaceCode".equals(attributeName)) {
            ArrayList<String> primaryKeys = new ArrayList<String>();
            primaryKeys.add("code");
            NamespaceBo parameterNamespace = new NamespaceBo();
            String code = (String)KradDataServiceLocator.getDataObjectService().wrap((Object)businessObject).getPropertyValueNullSafe(attributeName);
            parameterNamespace.setCode(code);
            return this.getInquiryUrlForPrimaryKeys(NamespaceBo.class, parameterNamespace, primaryKeys, null);
        }
        if ("kimRoleType.name".equals(attributeName)) {
            KimTypeBo kimType = new KimTypeBo();
            kimType.setId(((RoleBo)businessObject).getKimTypeId());
            return this.getInquiryUrlForPrimaryKeys(KimTypeBo.class, kimType, Collections.singletonList("id"), null);
        }
        return super.getInquiryUrl(businessObject, attributeName, forceInquiry);
    }
}

