/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ken.web.spring;

import java.util.Collection;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.ken.bo.NotificationChannelBo;
import org.kuali.rice.ken.bo.UserChannelSubscriptionBo;
import org.kuali.rice.ken.service.NotificationChannelService;
import org.kuali.rice.ken.service.UserPreferenceService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;

@RequestMapping(value={"/ken"})
@Controller(value="userPreferencesController")
public class UserPreferencesController {
    private static String view = "";
    private static final Logger LOG = LogManager.getLogger(UserPreferencesController.class);
    @Autowired
    @Qualifier(value="notificationChannelService")
    protected NotificationChannelService notificationChannelService;
    @Autowired
    @Qualifier(value="userPreferenceService")
    protected UserPreferenceService userPreferenceService;

    @RequestMapping(value={"/DisplayActionListPreferences.form"})
    public ModelAndView displayActionListPreferences(HttpServletRequest request) {
        view = "ActionListPreferences";
        LOG.debug("remoteUser: " + request.getRemoteUser());
        HashMap model = new HashMap();
        return new ModelAndView(view, model);
    }

    @RequestMapping(value={"/DisplayUserPreferences.form"})
    public ModelAndView displayUserPreferences(HttpServletRequest request) {
        view = "UserPreferencesForm";
        String userid = request.getRemoteUser();
        LOG.debug("remoteUser: " + userid);
        Collection<NotificationChannelBo> channels = this.notificationChannelService.getSubscribableChannels();
        Collection<UserChannelSubscriptionBo> subscriptions = this.userPreferenceService.getCurrentSubscriptions(userid);
        HashMap<String, String> currentsubs = new HashMap<String, String>();
        for (UserChannelSubscriptionBo sub : subscriptions) {
            String subid = Long.toString(sub.getChannel().getId());
            currentsubs.put(subid, subid);
            LOG.debug("currently subscribed to: " + sub.getChannel().getId());
        }
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("channels", channels);
        model.put("currentsubs", currentsubs);
        return new ModelAndView(view, model);
    }

    @RequestMapping(value={"/SubscribeToChannel.form"})
    public ModelAndView subscribeToChannel(HttpServletRequest request) {
        view = "UserPreferencesForm";
        String userid = request.getRemoteUser();
        LOG.debug("remoteUser: " + userid);
        String channelid = request.getParameter("channelid");
        NotificationChannelBo newChannel = this.notificationChannelService.getNotificationChannel(channelid);
        LOG.debug("newChannel name:" + newChannel.getName());
        UserChannelSubscriptionBo newSub = new UserChannelSubscriptionBo();
        newSub.setUserId(userid);
        newSub.setChannel(newChannel);
        LOG.debug("Calling service to subscribe to channel: " + newChannel.getName());
        this.userPreferenceService.subscribeToChannel(newSub);
        Collection<UserChannelSubscriptionBo> subscriptions = this.userPreferenceService.getCurrentSubscriptions(userid);
        HashMap<String, String> currentsubs = new HashMap<String, String>();
        for (UserChannelSubscriptionBo sub : subscriptions) {
            String subid = Long.toString(sub.getChannel().getId());
            currentsubs.put(subid, subid);
            LOG.debug("currently subscribed to: " + sub.getChannel().getId());
        }
        Collection<NotificationChannelBo> channels = this.notificationChannelService.getSubscribableChannels();
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("channels", channels);
        model.put("currentsubs", currentsubs);
        return new ModelAndView(view, model);
    }

    @RequestMapping(value={"/UnsubscribeFromChannel.form"})
    public ModelAndView unsubscribeFromChannel(HttpServletRequest request) {
        view = "UserPreferencesForm";
        String userid = request.getRemoteUser();
        LOG.debug("remoteUser: " + userid);
        String channelid = request.getParameter("channelid");
        NotificationChannelBo newChannel = this.notificationChannelService.getNotificationChannel(channelid);
        LOG.debug("getting channel (id, user): " + channelid + "," + userid);
        UserChannelSubscriptionBo oldsub = this.userPreferenceService.getSubscription(channelid, userid);
        oldsub.setChannel(newChannel);
        LOG.debug("Calling service to unsubscribe: " + newChannel.getName());
        this.userPreferenceService.unsubscribeFromChannel(oldsub);
        LOG.debug("Finished unsubscribe service: " + newChannel.getName());
        Collection<UserChannelSubscriptionBo> subscriptions = this.userPreferenceService.getCurrentSubscriptions(userid);
        HashMap<String, String> currentsubs = new HashMap<String, String>();
        for (UserChannelSubscriptionBo sub : subscriptions) {
            String subid = Long.toString(sub.getChannel().getId());
            currentsubs.put(subid, subid);
            LOG.debug("currently subscribed to: " + sub.getChannel().getId());
        }
        Collection<NotificationChannelBo> channels = this.notificationChannelService.getSubscribableChannels();
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("channels", channels);
        model.put("currentsubs", currentsubs);
        return new ModelAndView(view, model);
    }

    public NotificationChannelService getNotificationChannelService() {
        return this.notificationChannelService;
    }

    public UserPreferenceService getUserPreferenceService() {
        return this.userPreferenceService;
    }

    public void setNotificationChannelService(NotificationChannelService notificationChannelService) {
        this.notificationChannelService = notificationChannelService;
    }

    public void setUserPreferenceService(UserPreferenceService userPreferenceService) {
        this.userPreferenceService = userPreferenceService;
    }
}

