/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.kew.actionitem.ActionItem;
import org.kuali.rice.kew.actionlist.service.ActionListService;
import org.kuali.rice.kew.actionrequest.ActionRequestValue;
import org.kuali.rice.kew.actions.ActionTakenEvent;
import org.kuali.rice.kew.actiontaken.ActionTakenValue;
import org.kuali.rice.kew.api.exception.InvalidActionTakenException;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kim.api.identity.principal.PrincipalContract;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;

public class TakeWorkgroupAuthority
extends ActionTakenEvent {
    private String groupId;

    public TakeWorkgroupAuthority(DocumentRouteHeaderValue routeHeader, PrincipalContract principal) {
        super("w", routeHeader, principal);
    }

    public TakeWorkgroupAuthority(DocumentRouteHeaderValue routeHeader, PrincipalContract principal, String annotation, String groupId) {
        super("w", routeHeader, principal, annotation);
        this.groupId = groupId;
    }

    @Override
    public String validateActionRules() {
        if (this.groupId != null && !KimApiServiceLocator.getGroupService().isMemberOfGroup(this.getPrincipal().getPrincipalId(), this.groupId)) {
            return this.getPrincipal().getPrincipalName() + " not a member of workgroup " + this.groupId;
        }
        return "";
    }

    @Override
    public String validateActionRules(List<ActionRequestValue> actionRequests) {
        return this.validateActionRules();
    }

    @Override
    public void recordAction() throws InvalidActionTakenException {
        String errorMessage = this.validateActionRules();
        if (!StringUtils.isEmpty((String)errorMessage)) {
            throw new InvalidActionTakenException(errorMessage);
        }
        List<ActionRequestValue> documentRequests = this.getActionRequestService().findPendingByDoc(this.getDocumentId());
        ArrayList<ActionRequestValue> workgroupRequests = new ArrayList<ActionRequestValue>();
        for (ActionRequestValue actionRequest : documentRequests) {
            if (!actionRequest.isGroupRequest() || !actionRequest.getGroup().getId().equals(this.groupId)) continue;
            workgroupRequests.add(actionRequest);
        }
        ActionTakenValue actionTaken = this.saveActionTaken(this.findDelegatorForActionRequests(workgroupRequests));
        this.notifyActionTaken(actionTaken);
        ActionListService actionListService = KEWServiceLocator.getActionListService();
        Collection<ActionItem> actionItems = actionListService.findByDocumentId(this.getDocumentId());
        for (ActionItem actionItem : actionItems) {
            if (!actionItem.isWorkgroupItem() || !actionItem.getGroupId().equals(this.groupId) || actionItem.getPrincipalId().equals(this.getPrincipal().getPrincipalId())) continue;
            actionListService.deleteActionItem(actionItem);
        }
    }
}

