/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.engine.node.dao.impl;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.sql.DataSource;
import org.kuali.rice.core.api.criteria.Predicate;
import org.kuali.rice.core.api.criteria.PredicateFactory;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.kew.doctype.bo.DocumentType;
import org.kuali.rice.kew.engine.RouteHelper;
import org.kuali.rice.kew.engine.node.NodeState;
import org.kuali.rice.kew.engine.node.RouteNode;
import org.kuali.rice.kew.engine.node.RouteNodeInstance;
import org.kuali.rice.kew.engine.node.dao.RouteNodeDAO;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.krad.data.DataObjectService;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCallback;
import org.springframework.jdbc.core.PreparedStatementCreator;

public class RouteNodeDAOJpa
implements RouteNodeDAO {
    private EntityManager entityManager;
    private DataObjectService dataObjectService;
    public static final String FIND_INITIAL_NODE_INSTANCES_NAME = "RouteNodeInstance.FindInitialNodeInstances";
    public static final String FIND_INITIAL_NODE_INSTANCES_QUERY = "select d.initialRouteNodeInstances from DocumentRouteHeaderValue d where d.documentId = :documentId";
    private static final String CURRENT_ROUTE_NODE_NAMES_SQL = "SELECT rn.nm, rn.typ FROM krew_rte_node_t rn,      krew_rte_node_instn_t rni LEFT JOIN krew_rte_node_instn_lnk_t rnl   ON rnl.from_rte_node_instn_id = rni.rte_node_instn_id WHERE rn.rte_node_id = rni.rte_node_id AND       rni.doc_hdr_id = ? AND       rnl.from_rte_node_instn_id IS NULL";

    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    @Override
    public RouteNodeInstance findRouteNodeInstanceById(String nodeInstanceId) {
        QueryByCriteria.Builder queryByCriteria = QueryByCriteria.Builder.create().setPredicates(new Predicate[]{PredicateFactory.equal((String)"routeNodeInstanceId", (Object)nodeInstanceId)});
        List routeNodeInstances = this.getDataObjectService().findMatching(RouteNodeInstance.class, queryByCriteria.build()).getResults();
        if (routeNodeInstances != null && routeNodeInstances.size() > 0) {
            return (RouteNodeInstance)routeNodeInstances.get(0);
        }
        return null;
    }

    @Override
    public List<RouteNodeInstance> getActiveNodeInstances(String documentId) {
        QueryByCriteria.Builder queryByCriteria = QueryByCriteria.Builder.create().setPredicates(new Predicate[]{PredicateFactory.equal((String)"documentId", (Object)documentId), PredicateFactory.equal((String)"active", (Object)true)});
        return this.getDataObjectService().findMatching(RouteNodeInstance.class, queryByCriteria.build()).getResults();
    }

    @Override
    public List<String> getCurrentRouteNodeNames(final String documentId) {
        DataSource dataSource = KEWServiceLocator.getDataSource();
        JdbcTemplate template = new JdbcTemplate(dataSource);
        List names = (List)template.execute(new PreparedStatementCreator(this){

            public PreparedStatement createPreparedStatement(Connection connection) throws SQLException {
                return connection.prepareStatement(RouteNodeDAOJpa.CURRENT_ROUTE_NODE_NAMES_SQL);
            }
        }, (PreparedStatementCallback)new PreparedStatementCallback<List<String>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public List<String> doInPreparedStatement(PreparedStatement statement) throws SQLException, DataAccessException {
                ArrayList<String> routeNodeNames = new ArrayList<String>();
                statement.setString(1, documentId);
                try (ResultSet rs = statement.executeQuery();){
                    while (rs.next()) {
                        String name = rs.getString("nm");
                        routeNodeNames.add(name);
                    }
                }
                return routeNodeNames;
            }
        });
        return names;
    }

    @Override
    public List<String> getCurrentSimpleRouteNodeNames(final String documentId) {
        DataSource dataSource = KEWServiceLocator.getDataSource();
        JdbcTemplate template = new JdbcTemplate(dataSource);
        List names = (List)template.execute(new PreparedStatementCreator(this){

            public PreparedStatement createPreparedStatement(Connection connection) throws SQLException {
                return connection.prepareStatement(RouteNodeDAOJpa.CURRENT_ROUTE_NODE_NAMES_SQL);
            }
        }, (PreparedStatementCallback)new PreparedStatementCallback<List<String>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public List<String> doInPreparedStatement(PreparedStatement statement) throws SQLException, DataAccessException {
                ArrayList<String> routeNodeNames = new ArrayList<String>();
                statement.setString(1, documentId);
                try (ResultSet rs = statement.executeQuery();){
                    while (rs.next()) {
                        String name = rs.getString("nm");
                        String type = rs.getString("typ");
                        if (!RouteNodeDAOJpa.this.isSimpleNode(type)) continue;
                        routeNodeNames.add(name);
                    }
                }
                return routeNodeNames;
            }
        });
        return names;
    }

    @Override
    public List<String> getActiveRouteNodeNames(final String documentId) {
        DataSource dataSource = KEWServiceLocator.getDataSource();
        JdbcTemplate template = new JdbcTemplate(dataSource);
        List names = (List)template.execute(new PreparedStatementCreator(this){

            public PreparedStatement createPreparedStatement(Connection connection) throws SQLException {
                PreparedStatement statement = connection.prepareStatement("SELECT rn.nm FROM krew_rte_node_t rn, krew_rte_node_instn_t rni WHERE rn.rte_node_id = rni.rte_node_id AND rni.doc_hdr_id = ? AND rni.actv_ind = ?");
                return statement;
            }
        }, (PreparedStatementCallback)new PreparedStatementCallback<List<String>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public List<String> doInPreparedStatement(PreparedStatement statement) throws SQLException, DataAccessException {
                ArrayList<String> routeNodeNames = new ArrayList<String>();
                statement.setString(1, documentId);
                statement.setBoolean(2, Boolean.TRUE);
                try (ResultSet rs = statement.executeQuery();){
                    while (rs.next()) {
                        String name = rs.getString("nm");
                        routeNodeNames.add(name);
                    }
                }
                return routeNodeNames;
            }
        });
        return names;
    }

    @Override
    public List<String> getActiveSimpleRouteNodeNames(final String documentId) {
        DataSource dataSource = KEWServiceLocator.getDataSource();
        JdbcTemplate template = new JdbcTemplate(dataSource);
        List names = (List)template.execute(new PreparedStatementCreator(this){

            public PreparedStatement createPreparedStatement(Connection connection) throws SQLException {
                PreparedStatement statement = connection.prepareStatement("SELECT rn.nm, rn.typ FROM krew_rte_node_t rn, krew_rte_node_instn_t rni WHERE rn.rte_node_id = rni.rte_node_id AND rni.doc_hdr_id = ? AND rni.actv_ind = ?");
                return statement;
            }
        }, (PreparedStatementCallback)new PreparedStatementCallback<List<String>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public List<String> doInPreparedStatement(PreparedStatement statement) throws SQLException, DataAccessException {
                ArrayList<String> routeNodeNames = new ArrayList<String>();
                statement.setString(1, documentId);
                statement.setBoolean(2, Boolean.TRUE);
                try (ResultSet rs = statement.executeQuery();){
                    while (rs.next()) {
                        String name = rs.getString("nm");
                        String type = rs.getString("typ");
                        if (!RouteNodeDAOJpa.this.isSimpleNode(type)) continue;
                        routeNodeNames.add(name);
                    }
                }
                return routeNodeNames;
            }
        });
        return names;
    }

    private boolean isSimpleNode(String type) {
        RouteNode routeNode = new RouteNode();
        routeNode.setNodeType(type);
        routeNode.setDocumentType(new DocumentType());
        return new RouteHelper().isSimpleNode(routeNode);
    }

    @Override
    public List<RouteNodeInstance> getTerminalNodeInstances(String documentId) {
        QueryByCriteria.Builder queryByCriteria = QueryByCriteria.Builder.create().setPredicates(new Predicate[]{PredicateFactory.equal((String)"documentId", (Object)documentId), PredicateFactory.equal((String)"active", (Object)false), PredicateFactory.equal((String)"complete", (Object)true)});
        ArrayList<RouteNodeInstance> terminalNodes = new ArrayList<RouteNodeInstance>();
        List routeNodeInstances = this.getDataObjectService().findMatching(RouteNodeInstance.class, queryByCriteria.build()).getResults();
        for (RouteNodeInstance routeNodeInstance : routeNodeInstances) {
            if (!routeNodeInstance.getNextNodeInstances().isEmpty()) continue;
            terminalNodes.add(routeNodeInstance);
        }
        return terminalNodes;
    }

    @Override
    public List<String> getTerminalRouteNodeNames(final String documentId) {
        DataSource dataSource = KEWServiceLocator.getDataSource();
        JdbcTemplate template = new JdbcTemplate(dataSource);
        List names = (List)template.execute(new PreparedStatementCreator(this){

            public PreparedStatement createPreparedStatement(Connection connection) throws SQLException {
                PreparedStatement statement = connection.prepareStatement("SELECT rn.nm  FROM krew_rte_node_t rn,       krew_rte_node_instn_t rni  LEFT JOIN krew_rte_node_instn_lnk_t rnl    ON rnl.from_rte_node_instn_id = rni.rte_node_instn_id  WHERE rn.rte_node_id = rni.rte_node_id AND        rni.doc_hdr_id = ? AND        rni.actv_ind = ? AND        rni.cmplt_ind = ? AND        rnl.from_rte_node_instn_id IS NULL");
                return statement;
            }
        }, (PreparedStatementCallback)new PreparedStatementCallback<List<String>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public List<String> doInPreparedStatement(PreparedStatement statement) throws SQLException, DataAccessException {
                ArrayList<String> routeNodeNames = new ArrayList<String>();
                statement.setString(1, documentId);
                statement.setBoolean(2, Boolean.FALSE);
                statement.setBoolean(3, Boolean.TRUE);
                try (ResultSet rs = statement.executeQuery();){
                    while (rs.next()) {
                        String name = rs.getString("nm");
                        routeNodeNames.add(name);
                    }
                }
                return routeNodeNames;
            }
        });
        return names;
    }

    @Override
    public List getInitialNodeInstances(String documentId) {
        Query query = this.entityManager.createNamedQuery(FIND_INITIAL_NODE_INSTANCES_NAME);
        query.setParameter("documentId", (Object)documentId);
        return query.getResultList();
    }

    @Override
    public NodeState findNodeState(Long nodeInstanceId, String key) {
        QueryByCriteria.Builder queryByCriteria = QueryByCriteria.Builder.create().setPredicates(new Predicate[]{PredicateFactory.equal((String)"routeNodeInstanceId", (Object)nodeInstanceId.toString()), PredicateFactory.equal((String)"key", (Object)key)});
        List nodeStates = this.getDataObjectService().findMatching(NodeState.class, queryByCriteria.build()).getResults();
        if (nodeStates != null && nodeStates.size() > 0) {
            return (NodeState)((Object)nodeStates.get(0));
        }
        return null;
    }

    @Override
    public RouteNode findRouteNodeByName(String documentTypeId, String name) {
        QueryByCriteria.Builder queryByCriteria = QueryByCriteria.Builder.create().setPredicates(new Predicate[]{PredicateFactory.equal((String)"documentTypeId", (Object)documentTypeId), PredicateFactory.equal((String)"routeNodeName", (Object)name)});
        List routeNodes = this.getDataObjectService().findMatching(RouteNode.class, queryByCriteria.build()).getResults();
        if (routeNodes != null && routeNodes.size() > 0) {
            return (RouteNode)routeNodes.get(0);
        }
        return null;
    }

    @Override
    public List<RouteNode> findFinalApprovalRouteNodes(String documentTypeId) {
        QueryByCriteria.Builder queryByCriteria = QueryByCriteria.Builder.create().setPredicates(new Predicate[]{PredicateFactory.equal((String)"documentTypeId", (Object)documentTypeId), PredicateFactory.equal((String)"finalApprovalInd", (Object)Boolean.TRUE)});
        return this.getDataObjectService().findMatching(RouteNode.class, queryByCriteria.build()).getResults();
    }

    @Override
    public List findProcessNodeInstances(RouteNodeInstance process) {
        QueryByCriteria.Builder queryByCriteria = QueryByCriteria.Builder.create().setPredicates(new Predicate[]{PredicateFactory.equal((String)"processId", (Object)process.getRouteNodeInstanceId())});
        return this.getDataObjectService().findMatching(RouteNodeInstance.class, queryByCriteria.build()).getResults();
    }

    @Override
    public List findRouteNodeInstances(String documentId) {
        QueryByCriteria.Builder queryByCriteria = QueryByCriteria.Builder.create().setPredicates(new Predicate[]{PredicateFactory.equal((String)"documentId", (Object)documentId)});
        return this.getDataObjectService().findMatching(RouteNodeInstance.class, queryByCriteria.build()).getResults();
    }

    @Override
    public void deleteLinksToPreNodeInstances(RouteNodeInstance routeNodeInstance) {
        List<RouteNodeInstance> preNodeInstances = routeNodeInstance.getPreviousNodeInstances();
        for (RouteNodeInstance preNodeInstance : preNodeInstances) {
            List<RouteNodeInstance> nextInstances = preNodeInstance.getNextNodeInstances();
            nextInstances.remove(routeNodeInstance);
            this.getEntityManager().merge((Object)preNodeInstance);
        }
    }

    @Override
    public void deleteRouteNodeInstancesHereAfter(RouteNodeInstance routeNodeInstance) {
        RouteNodeInstance rnInstance = this.findRouteNodeInstanceById(routeNodeInstance.getRouteNodeInstanceId());
        this.entityManager.remove((Object)rnInstance);
    }

    @Override
    public void deleteNodeStateById(Long nodeStateId) {
        QueryByCriteria.Builder queryByCriteria = QueryByCriteria.Builder.create().setPredicates(new Predicate[]{PredicateFactory.equal((String)"nodeStateId", (Object)nodeStateId)});
        List nodeStates = this.getDataObjectService().findMatching(NodeState.class, queryByCriteria.build()).getResults();
        NodeState nodeState = null;
        if (nodeStates != null && nodeStates.size() > 0) {
            nodeState = (NodeState)((Object)nodeStates.get(0));
        }
        this.getDataObjectService().delete(nodeState);
    }

    @Override
    public void deleteNodeStates(List statesToBeDeleted) {
        for (Long stateId : statesToBeDeleted) {
            this.deleteNodeStateById(stateId);
        }
    }

    public DataObjectService getDataObjectService() {
        return this.dataObjectService;
    }

    @Required
    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }
}

