/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.engine.transition;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.kuali.rice.kew.engine.RouteContext;
import org.kuali.rice.kew.engine.node.DynamicNode;
import org.kuali.rice.kew.engine.node.DynamicResult;
import org.kuali.rice.kew.engine.node.ProcessResult;
import org.kuali.rice.kew.engine.node.RouteNode;
import org.kuali.rice.kew.engine.node.RouteNodeInstance;
import org.kuali.rice.kew.engine.transition.Transition;
import org.kuali.rice.kew.engine.transition.TransitionEngine;
import org.kuali.rice.kew.exception.RouteManagerException;

public class DynamicTransitionEngine
extends TransitionEngine {
    @Override
    public RouteNodeInstance transitionTo(RouteNodeInstance dynamicNodeInstance, RouteContext context) throws Exception {
        dynamicNodeInstance.setInitial(false);
        dynamicNodeInstance.setActive(false);
        DynamicNode dynamicNode = (DynamicNode)this.getNode(dynamicNodeInstance.getRouteNode(), DynamicNode.class);
        DynamicResult result = dynamicNode.transitioningInto(context, dynamicNodeInstance, this.getRouteHelper());
        RouteNodeInstance nextNodeInstance = result.getNextNodeInstance();
        RouteNodeInstance finalNodeInstance = null;
        if (result.isComplete()) {
            dynamicNodeInstance.setComplete(true);
            finalNodeInstance = this.getFinalNodeInstance(dynamicNodeInstance, context);
            if (nextNodeInstance == null) {
                nextNodeInstance = finalNodeInstance;
            }
        }
        if (nextNodeInstance != null) {
            this.initializeNodeGraph(context, dynamicNodeInstance, nextNodeInstance, new HashSet<RouteNodeInstance>(), finalNodeInstance);
        }
        return nextNodeInstance;
    }

    @Override
    public ProcessResult isComplete(RouteContext context) throws Exception {
        throw new UnsupportedOperationException("isComplete() should not be invoked on a Dynamic node!");
    }

    @Override
    public Transition transitionFrom(RouteContext context, ProcessResult processResult) throws Exception {
        Transition transition = new Transition();
        RouteNodeInstance dynamicNodeInstance = context.getNodeInstance().getProcess();
        DynamicNode dynamicNode = (DynamicNode)this.getNode(dynamicNodeInstance.getRouteNode(), DynamicNode.class);
        DynamicResult result = dynamicNode.transitioningOutOf(context, this.getRouteHelper());
        if (result.getNextNodeInstance() == null && result.getNextNodeInstances().isEmpty() && result.isComplete()) {
            dynamicNodeInstance.setComplete(true);
            RouteNodeInstance finalNodeInstance = this.getFinalNodeInstance(dynamicNodeInstance, context);
            if (finalNodeInstance != null) {
                transition.getNextNodeInstances().add(finalNodeInstance);
            }
        } else {
            if (result.getNextNodeInstance() != null) {
                result.getNextNodeInstance().setProcess(dynamicNodeInstance);
                transition.getNextNodeInstances().add(result.getNextNodeInstance());
            }
            for (RouteNodeInstance nextNodeInstance : result.getNextNodeInstances()) {
                nextNodeInstance.setProcess(dynamicNodeInstance);
            }
            transition.getNextNodeInstances().addAll(result.getNextNodeInstances());
        }
        return transition;
    }

    private void initializeNodeGraph(RouteContext context, RouteNodeInstance dynamicNodeInstance, RouteNodeInstance nodeInstance, Set<RouteNodeInstance> nodeInstances, RouteNodeInstance finalNodeInstance) throws Exception {
        if (nodeInstances.contains(nodeInstance)) {
            throw new RouteManagerException("A cycle was detected in the node graph returned from the dynamic node.", context);
        }
        nodeInstances.add(nodeInstance);
        nodeInstance.setProcess(dynamicNodeInstance);
        List<RouteNodeInstance> nextNodeInstances = nodeInstance.getNextNodeInstances();
        if (nextNodeInstances.size() > 1) {
            // empty if block
        }
        for (RouteNodeInstance nextNodeInstance : nextNodeInstances) {
            this.initializeNodeGraph(context, dynamicNodeInstance, nextNodeInstance, nodeInstances, finalNodeInstance);
        }
        if (nextNodeInstances.isEmpty() && finalNodeInstance != null) {
            nodeInstance.addNextNodeInstance(finalNodeInstance);
        }
    }

    private RouteNodeInstance getFinalNodeInstance(RouteNodeInstance dynamicNodeInstance, RouteContext context) throws Exception {
        List<RouteNode> nextNodes = dynamicNodeInstance.getRouteNode().getNextNodes();
        if (nextNodes.size() > 1) {
            throw new RouteManagerException("There should only be 1 next node following a dynamic node, there were " + nextNodes.size(), context);
        }
        RouteNodeInstance finalNodeInstance = null;
        if (!nextNodes.isEmpty()) {
            finalNodeInstance = this.getRouteHelper().getNodeFactory().createRouteNodeInstance(context.getDocument().getDocumentId(), nextNodes.get(0));
            finalNodeInstance.setBranch(dynamicNodeInstance.getBranch());
            finalNodeInstance.setProcess(dynamicNodeInstance.getProcess());
        }
        return finalNodeInstance;
    }
}

