/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.impl.doctype;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.kew.api.doctype.DocumentType;
import org.kuali.rice.kew.api.doctype.DocumentTypeService;
import org.kuali.rice.kew.api.doctype.ProcessDefinition;
import org.kuali.rice.kew.api.doctype.ProcessDefinitionContract;
import org.kuali.rice.kew.api.doctype.RoutePath;
import org.kuali.rice.kew.api.document.node.RouteNodeInstance;
import org.kuali.rice.kew.doctype.dao.DocumentTypeDAO;
import org.kuali.rice.kew.engine.node.ProcessDefinitionBo;
import org.kuali.rice.kew.engine.node.RouteNode;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.krad.data.DataObjectService;
import org.springframework.beans.factory.annotation.Required;

public class DocumentTypeServiceImpl
implements DocumentTypeService {
    private static final Logger LOG = LogManager.getLogger(DocumentTypeServiceImpl.class);
    private DocumentTypeDAO documentTypeDao;
    private DataObjectService dataObjectService;

    public String getIdByName(String documentTypeName) {
        if (StringUtils.isBlank((String)documentTypeName)) {
            throw new RiceIllegalArgumentException("documentTypeName was null or blank");
        }
        return this.documentTypeDao.findDocumentTypeIdByName(documentTypeName);
    }

    public String getNameById(String documentTypeId) {
        if (StringUtils.isBlank((String)documentTypeId)) {
            throw new RiceIllegalArgumentException("documentTypeId was null or blank");
        }
        return this.documentTypeDao.findDocumentTypeNameById(documentTypeId);
    }

    public DocumentType getDocumentTypeById(String documentTypeId) {
        if (StringUtils.isBlank((String)documentTypeId)) {
            throw new RiceIllegalArgumentException("documentTypeId was null or blank");
        }
        org.kuali.rice.kew.doctype.bo.DocumentType documentTypeBo = (org.kuali.rice.kew.doctype.bo.DocumentType)this.getDataObjectService().find(org.kuali.rice.kew.doctype.bo.DocumentType.class, (Object)documentTypeId);
        return org.kuali.rice.kew.doctype.bo.DocumentType.to(documentTypeBo);
    }

    public DocumentType getDocumentTypeByName(String documentTypeName) {
        if (StringUtils.isBlank((String)documentTypeName)) {
            throw new RiceIllegalArgumentException("documentTypeName was null or blank");
        }
        org.kuali.rice.kew.doctype.bo.DocumentType documentTypeBo = this.documentTypeDao.findByName(documentTypeName);
        return org.kuali.rice.kew.doctype.bo.DocumentType.to(documentTypeBo);
    }

    public List<DocumentType> findAllDocumentTypes() {
        List documentTypeBos = this.documentTypeDao.findAllCurrent();
        ArrayList<DocumentType> currentDocTypes = new ArrayList<DocumentType>();
        for (org.kuali.rice.kew.doctype.bo.DocumentType dt : documentTypeBos) {
            currentDocTypes.add(org.kuali.rice.kew.doctype.bo.DocumentType.to(dt));
        }
        return Collections.unmodifiableList(currentDocTypes);
    }

    public boolean isSuperUserForDocumentTypeId(String principalId, String documentTypeId) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Determining super user status [principalId=" + principalId + ", documentTypeId=" + documentTypeId + "]");
        }
        if (StringUtils.isBlank((String)principalId)) {
            throw new RiceIllegalArgumentException("principalId was null or blank");
        }
        if (StringUtils.isBlank((String)documentTypeId)) {
            throw new RiceIllegalArgumentException("documentTypeId was null or blank");
        }
        org.kuali.rice.kew.doctype.bo.DocumentType documentType = KEWServiceLocator.getDocumentTypeService().findById(documentTypeId);
        boolean isSuperUser = KEWServiceLocator.getDocumentTypePermissionService().canAdministerRouting(principalId, documentType);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Super user status is " + isSuperUser + ".");
        }
        return isSuperUser;
    }

    public boolean isSuperUserForDocumentTypeName(String principalId, String documentTypeName) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Determining super user status [principalId=" + principalId + ", documentTypeName=" + documentTypeName + "]");
        }
        if (StringUtils.isBlank((String)principalId)) {
            throw new RiceIllegalArgumentException("principalId was null or blank");
        }
        if (StringUtils.isBlank((String)documentTypeName)) {
            throw new RiceIllegalArgumentException("documentTypeId was null or blank");
        }
        org.kuali.rice.kew.doctype.bo.DocumentType documentType = KEWServiceLocator.getDocumentTypeService().findByName(documentTypeName);
        boolean isSuperUser = KEWServiceLocator.getDocumentTypePermissionService().canAdministerRouting(principalId, documentType);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Super user status is " + isSuperUser + ".");
        }
        return isSuperUser;
    }

    public boolean canSuperUserApproveSingleActionRequest(String principalId, String documentTypeName, List<RouteNodeInstance> routeNodeInstances, String routeStatusCode) {
        this.checkSuperUserInput(principalId, documentTypeName);
        org.kuali.rice.kew.doctype.bo.DocumentType documentType = KEWServiceLocator.getDocumentTypeService().findByName(documentTypeName);
        List<org.kuali.rice.kew.engine.node.RouteNodeInstance> currentNodeInstances = null;
        if (routeNodeInstances != null && !routeNodeInstances.isEmpty()) {
            currentNodeInstances = KEWServiceLocator.getRouteNodeService().getCurrentNodeInstances(routeNodeInstances.get(0).getDocumentId());
        }
        boolean isSuperUser = KEWServiceLocator.getDocumentTypePermissionService().canSuperUserApproveSingleActionRequest(principalId, documentType, currentNodeInstances, routeStatusCode);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Super user approve single action request status is " + isSuperUser + ".");
        }
        return isSuperUser;
    }

    public boolean canSuperUserApproveDocument(String principalId, String documentTypeName, List<RouteNodeInstance> routeNodeInstances, String routeStatusCode) {
        this.checkSuperUserInput(principalId, documentTypeName);
        org.kuali.rice.kew.doctype.bo.DocumentType documentType = KEWServiceLocator.getDocumentTypeService().findByName(documentTypeName);
        List<org.kuali.rice.kew.engine.node.RouteNodeInstance> currentNodeInstances = null;
        if (routeNodeInstances != null && !routeNodeInstances.isEmpty()) {
            currentNodeInstances = KEWServiceLocator.getRouteNodeService().getCurrentNodeInstances(routeNodeInstances.get(0).getDocumentId());
        }
        boolean isSuperUser = KEWServiceLocator.getDocumentTypePermissionService().canSuperUserApproveDocument(principalId, documentType, currentNodeInstances, routeStatusCode);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Super user approve document status is " + isSuperUser + ".");
        }
        return isSuperUser;
    }

    public boolean canSuperUserDisapproveDocument(String principalId, String documentTypeName, List<RouteNodeInstance> routeNodeInstances, String routeStatusCode) {
        this.checkSuperUserInput(principalId, documentTypeName);
        org.kuali.rice.kew.doctype.bo.DocumentType documentType = KEWServiceLocator.getDocumentTypeService().findByName(documentTypeName);
        List<org.kuali.rice.kew.engine.node.RouteNodeInstance> currentNodeInstances = null;
        if (routeNodeInstances != null && !routeNodeInstances.isEmpty()) {
            currentNodeInstances = KEWServiceLocator.getRouteNodeService().getCurrentNodeInstances(routeNodeInstances.get(0).getDocumentId());
        }
        boolean isSuperUser = KEWServiceLocator.getDocumentTypePermissionService().canSuperUserDisapproveDocument(principalId, documentType, currentNodeInstances, routeStatusCode);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Super user disapprove document status is " + isSuperUser + ".");
        }
        return isSuperUser;
    }

    private void checkSuperUserInput(String principalId, String documentTypeName) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Determining super user status [principalId=" + principalId + ", documentTypeName=" + documentTypeName + "]");
        }
        if (StringUtils.isBlank((String)principalId)) {
            throw new RiceIllegalArgumentException("principalId was null or blank");
        }
        if (StringUtils.isBlank((String)documentTypeName)) {
            throw new RiceIllegalArgumentException("documentTypeId was null or blank");
        }
    }

    public boolean hasRouteNodeForDocumentTypeName(String routeNodeName, String documentTypeName) throws RiceIllegalArgumentException {
        if (StringUtils.isBlank((String)routeNodeName)) {
            throw new RiceIllegalArgumentException("routeNodeName was null or blank");
        }
        if (StringUtils.isBlank((String)documentTypeName)) {
            throw new RiceIllegalArgumentException("documentTypeName was null or blank");
        }
        DocumentType documentType = this.getDocumentTypeByName(documentTypeName);
        if (documentType == null) {
            throw new RiceIllegalArgumentException("Failed to locate a document type for the given name: " + documentTypeName);
        }
        RouteNode routeNode = KEWServiceLocator.getRouteNodeService().findRouteNodeByName(documentType.getId(), routeNodeName);
        if (routeNode == null) {
            if (documentType.getParentId() == null) {
                return false;
            }
            return this.hasRouteNodeForDocumentTypeId(routeNodeName, documentType.getParentId());
        }
        return true;
    }

    public boolean hasRouteNodeForDocumentTypeId(String routeNodeName, String documentTypeId) throws RiceIllegalArgumentException {
        if (StringUtils.isBlank((String)routeNodeName)) {
            throw new RiceIllegalArgumentException("routeNodeName was null or blank");
        }
        if (StringUtils.isBlank((String)documentTypeId)) {
            throw new RiceIllegalArgumentException("documentTypeId was null or blank");
        }
        DocumentType documentType = this.getDocumentTypeById(documentTypeId);
        if (documentType == null) {
            throw new RiceIllegalArgumentException("Failed to locate a document type for the given id: " + documentTypeId);
        }
        RouteNode routeNode = KEWServiceLocator.getRouteNodeService().findRouteNodeByName(documentType.getId(), routeNodeName);
        if (routeNode == null) {
            if (documentType.getParentId() == null) {
                return false;
            }
            return this.hasRouteNodeForDocumentTypeId(routeNodeName, documentType.getParentId());
        }
        return true;
    }

    public boolean isActiveById(String documentTypeId) {
        if (StringUtils.isBlank((String)documentTypeId)) {
            throw new RiceIllegalArgumentException("documentTypeId was null or blank");
        }
        org.kuali.rice.kew.doctype.bo.DocumentType docType = KEWServiceLocator.getDocumentTypeService().findById(documentTypeId);
        return docType != null && docType.isActive();
    }

    public boolean isActiveByName(String documentTypeName) {
        if (StringUtils.isBlank((String)documentTypeName)) {
            throw new RiceIllegalArgumentException("documentTypeName was null or blank");
        }
        org.kuali.rice.kew.doctype.bo.DocumentType docType = KEWServiceLocator.getDocumentTypeService().findByName(documentTypeName);
        return docType != null && docType.isActive();
    }

    public RoutePath getRoutePathForDocumentTypeId(String documentTypeId) {
        if (StringUtils.isBlank((String)documentTypeId)) {
            throw new RiceIllegalArgumentException("documentTypeId was null or blank");
        }
        org.kuali.rice.kew.doctype.bo.DocumentType docType = KEWServiceLocator.getDocumentTypeService().findById(documentTypeId);
        if (docType == null) {
            return null;
        }
        RoutePath.Builder builder = RoutePath.Builder.create();
        List processes = docType.getProcesses();
        for (ProcessDefinitionBo process : processes) {
            builder.getProcessDefinitions().add(ProcessDefinition.Builder.create((ProcessDefinitionContract)process));
        }
        return builder.build();
    }

    public RoutePath getRoutePathForDocumentTypeName(String documentTypeName) {
        if (StringUtils.isBlank((String)documentTypeName)) {
            throw new RiceIllegalArgumentException("documentTypeName was null or blank");
        }
        org.kuali.rice.kew.doctype.bo.DocumentType docType = KEWServiceLocator.getDocumentTypeService().findByName(documentTypeName);
        if (docType == null) {
            return null;
        }
        RoutePath.Builder builder = RoutePath.Builder.create();
        List processes = docType.getProcesses();
        for (ProcessDefinitionBo process : processes) {
            builder.getProcessDefinitions().add(ProcessDefinition.Builder.create((ProcessDefinitionContract)process));
        }
        return builder.build();
    }

    public void setDocumentTypeDao(DocumentTypeDAO documentTypeDao) {
        this.documentTypeDao = documentTypeDao;
    }

    public DataObjectService getDataObjectService() {
        return this.dataObjectService;
    }

    @Required
    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }
}

