/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.ken.service;

import java.util.Collection;

/**
 * The NotificationRecipientService class is responsible for housing user/group related services.
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public interface NotificationRecipientService {
    /**
     * This method handles figuring out which recipient type that you are deling with and calls
     * the appropriate validation method.
     * @param recipientId
     * @param recipientType
     * @return boolean
     */
    public boolean isRecipientValid(String recipientId, String recipientType);

    /**
     * This service method checks to make sure that the user recipient is a valid user in the system.
     * @param userRecipientId
     * @return boolean
     */
    public boolean isUserRecipientValid(String userRecipientId);

    /**
     * This service method checks to make sure that the group recipient is a valid group in the system.
     * @param groupRecipientId
     * @return boolean
     */
    public boolean isGroupRecipientValid(String groupRecipientId);

    /**
     * This service method will retrieve all of the user recipients ids that belong to a group.
     * @param groupRecipientId
     * @return A String array of user recipient ids that belong to the specified recipient group id.
     */
    public String[] getGroupMembers(String groupRecipientId);


    /**
     * This method retrieves the display name for a user.
     * @param userId
     * @return String
     */
    public String getUserDisplayName(String userId);
}
