/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.ken.util;

import java.io.ByteArrayInputStream;
import java.io.File;

import javax.xml.transform.stream.StreamSource;

import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.LogManager;

/**
 * This class is responsible for resolving Xsl from files and Strings.
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class XslSourceResolver {
    protected final Logger LOG = LogManager.getLogger(getClass());

    public XslSourceResolver() {
	super();

    }
    
    /**
     * 
     * This method resolves xsl from a file
     * @param path location of xsl file
     * @return a StreamSource
     */
    public StreamSource resolveXslFromFile(String path) {
	StreamSource xslsource = new StreamSource(new File(path));
	return xslsource;
    }
    
    /**
     * 
     * This method resolves xsl from a string
     * @param path location of xsl file
     * @return a StreamSource
     */
    public StreamSource resolveXslFromString(String s) {
	ByteArrayInputStream bytestream = new ByteArrayInputStream(s.getBytes());
	StreamSource xslsource = new StreamSource(bytestream);
	return xslsource;
    }
}
