/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.docsearch.dao;

import org.kuali.rice.core.api.uif.RemotableAttributeField;
import org.kuali.rice.kew.api.document.search.DocumentSearchCriteria;
import org.kuali.rice.kew.api.document.search.DocumentSearchResults;
import org.kuali.rice.kew.impl.document.search.DocumentSearchGenerator;

import java.util.List;


public interface DocumentSearchDAO {

    public DocumentSearchResults.Builder findDocuments(DocumentSearchGenerator docSearchGenerator, DocumentSearchCriteria criteria, boolean criteriaModified, List<RemotableAttributeField> searchFields);
    public int getMaxResultCap(DocumentSearchCriteria criteria);
    public int getFetchMoreIterationLimit();
}
