/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.engine.node;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Version;
import java.io.Serializable;

/**
 * Represents a Branch in the definition of a DocumentType.  This should not be confused with the
 * {@link Branch} class which represents the actual instance of a branch on a document. 
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
@Entity
@Table(name="KREW_RTE_BRCH_PROTO_T")
//@Sequence(name="KREW_RTE_NODE_S", property="branchId")
public class BranchPrototype implements Serializable {

	private static final long serialVersionUID = 8645994738204838275L;
    
    @Id
    @GeneratedValue(generator="KREW_RTE_NODE_S")
	@Column(name="RTE_BRCH_PROTO_ID")
	private String branchId;
	@Column(name="BRCH_NM")
	private String name;
	@Version
	@Column(name="VER_NBR")
	private Integer lockVerNbr;
	
	public String getBranchId() {
		return branchId;
	}
	
	public void setBranchId(String branchId) {
		this.branchId = branchId;
	}
	
	public String getName() {
		return name;
	}
	
	public void setName(String name) {
		this.name = name;
	}

	public Integer getLockVerNbr() {
		return lockVerNbr;
	}

	public void setLockVerNbr(Integer lockVerNbr) {
		this.lockVerNbr = lockVerNbr;
	}
	
}

