/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.lookupable;

import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.kew.rule.bo.RuleBaseValuesLookupableImpl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * A bean which wraps a List of {@link <KeyValue>} objects.
 * 
 * @see RuleBaseValuesLookupableImpl
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class MyColumns implements Serializable {

	private static final long serialVersionUID = -4669528607040709102L;
	private List<KeyValue> columns;

    public MyColumns() {
        columns = new ArrayList<KeyValue>();
    }

    public List<KeyValue> getColumns() {
        return columns;
    }
    public void setColumns(List<KeyValue> columns) {
        this.columns = columns;
    }
}
