/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.rule.xmlrouting;

import java.util.Map;

import org.kuali.rice.kew.rule.WorkflowRuleAttribute;
import org.kuali.rice.kew.rule.XmlConfiguredAttribute;


/**
 * A {@link WorkflowRuleAttribute} which is configured via an XML definition.
 * Since it has no specific getters and setters for it's various
 * properties, it uses a Map of parameters to represent it's
 * attribute properties.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public interface GenericXMLRuleAttribute extends WorkflowRuleAttribute, XmlConfiguredAttribute {

	public void setParamMap(Map paramMap);
	public Map getParamMap();
}
