/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.web;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.rice.kew.api.KewApiConstants;
import org.kuali.rice.kns.web.struts.action.KualiAction;

/**
 * A base action class for KEW screens.
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 *
 */
public abstract class KewKualiAction extends KualiAction {
	
	public static final String DEFAULT_MAPPING = "basic";
	
	@Override 
	protected String getReturnLocation(HttpServletRequest request, ActionMapping mapping) 
    {
    	String mappingPath = mapping.getPath();
    	String basePath = getApplicationBaseUrl();
        return basePath + KewApiConstants.WEBAPP_DIRECTORY + mappingPath + ".do";
    }

	@Override
	protected ActionForward defaultDispatch(ActionMapping mapping,
			ActionForm form, HttpServletRequest request,
			HttpServletResponse response) throws Exception {
		return start(mapping, form, request, response);
	}
	
	public ActionForward start(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
		return mapping.findForward(getDefaultMapping());
	}
	
	protected String getDefaultMapping() {
		return DEFAULT_MAPPING;
	}
	
}
