/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.xml;

import java.io.InputStream;

import org.jdom2.Element;
import org.kuali.rice.core.api.impex.ExportDataSet;
import org.kuali.rice.core.api.exception.RiceRuntimeException;
import org.kuali.rice.core.framework.impex.xml.XmlExporter;
import org.kuali.rice.core.framework.impex.xml.XmlLoader;
import org.kuali.rice.kew.xml.export.GroupXmlExporter;

public class GroupXmlServiceImpl implements XmlLoader, XmlExporter{
	
	@Override
    public void loadXml(InputStream inputStream, String principalId) {
        GroupXmlParser parser = new GroupXmlParser();
        try {
            parser.parseGroups(inputStream);
        } catch (Exception e) {
            throw new RiceRuntimeException("Error loading xml file", e);
        }
    }

	@Override
	public boolean supportPrettyPrint() {
		return true;
	}

    @Override
    public Element export(ExportDataSet dataSet) {
        GroupXmlExporter exporter = new GroupXmlExporter();
        return exporter.export(dataSet);
    }


}
