/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kim.document.authorization;

import org.kuali.rice.kim.api.KimConstants;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.bo.ui.PersonDocumentGroup;
import org.kuali.rice.kim.bo.ui.PersonDocumentRole;
import org.kuali.rice.kim.document.IdentityManagementPersonDocument;
import org.kuali.rice.kns.document.authorization.TransactionalDocumentAuthorizerBase;
import org.kuali.rice.krad.document.Document;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class IdentityManagementKimDocumentAuthorizer extends TransactionalDocumentAuthorizerBase {
	
	public Map<String,Set<String>> getUnpopulateableGroups(Document document, Person user) {
		Map<String,Set<String>> unpopulateableGroups = new HashMap<String,Set<String>>();
		for (PersonDocumentGroup personDocumentGroup : ((IdentityManagementPersonDocument)document).getGroups()) {
			Map<String,String> collectionOrFieldLevelPermissionDetails = new HashMap<String,String>();
			collectionOrFieldLevelPermissionDetails.put(KimConstants.AttributeConstants.NAMESPACE_CODE, personDocumentGroup.getNamespaceCode());
			collectionOrFieldLevelPermissionDetails.put(KimConstants.AttributeConstants.GROUP_NAME, personDocumentGroup.getGroupName());
			if (!isAuthorizedByTemplate(document, KimConstants.NAMESPACE_CODE, KimConstants.PermissionTemplateNames.POPULATE_GROUP, user.getPrincipalId(), collectionOrFieldLevelPermissionDetails, null)) {
				if (!unpopulateableGroups.containsKey(personDocumentGroup.getNamespaceCode())) {
					unpopulateableGroups.put(personDocumentGroup.getNamespaceCode(), new HashSet<String>());
				}
				unpopulateableGroups.get(personDocumentGroup.getNamespaceCode()).add(personDocumentGroup.getGroupName());
			}
		}
		return unpopulateableGroups;
	}
	
	public Map<String,Set<String>> getUnassignableRoles(Document document, Person user) {
		Map<String,Set<String>> unassignableRoles = new HashMap<String,Set<String>>();
		for (PersonDocumentRole personDocumentRole : ((IdentityManagementPersonDocument)document).getRoles()) {
			Map<String,String> collectionOrFieldLevelPermissionDetails = new HashMap<String,String>();
			collectionOrFieldLevelPermissionDetails.put(KimConstants.AttributeConstants.NAMESPACE_CODE, personDocumentRole.getNamespaceCode());
			collectionOrFieldLevelPermissionDetails.put(KimConstants.AttributeConstants.ROLE_NAME, personDocumentRole.getRoleName());
			if (!isAuthorizedByTemplate(document, KimConstants.NAMESPACE_CODE, KimConstants.PermissionTemplateNames.ASSIGN_ROLE, user.getPrincipalId(), collectionOrFieldLevelPermissionDetails, null)) {
				if (!unassignableRoles.containsKey(personDocumentRole.getNamespaceCode())) {
					unassignableRoles.put(personDocumentRole.getNamespaceCode(), new HashSet<String>());
				}
				unassignableRoles.get(personDocumentRole.getNamespaceCode()).add(personDocumentRole.getRoleName());
			}
		}
		return unassignableRoles;
	}
}
