/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kim.web.struts.form;

import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.LogManager;
import org.kuali.rice.coreservice.api.parameter.Parameter;
import org.kuali.rice.coreservice.framework.CoreFrameworkServiceLocator;
import org.kuali.rice.kim.api.KimConstants;
import org.kuali.rice.kns.util.PagingBannerUtils;
import org.kuali.rice.kns.web.struts.form.KualiTableRenderFormMetadata;
import org.kuali.rice.kns.web.struts.form.KualiTransactionalDocumentFormBase;
import org.kuali.rice.krad.util.KRADConstants;

import javax.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.List;

@SuppressWarnings("serial")
public abstract class IdentityManagementDocumentFormBase extends KualiTransactionalDocumentFormBase {
	protected static final Logger LOG = LogManager.getLogger(IdentityManagementDocumentFormBase.class);
    protected static final String MAX_MEMBERS_PER_PAGE_PARM = "MAX_MEMBERS_PER_PAGE";
	protected transient KualiTableRenderFormMetadata memberTableMetadata;
    protected int recordsPerPage = -1;
    protected boolean inquiry = false;
    
	protected static final String CHANGE_NAMESPACE_METHOD_TO_CALL = "methodToCall.changeNamespace";
	protected static final String CHANGE_MEMBER_TYPE_CODE_METHOD_TO_CALL = "methodToCall.changeMemberTypeCode";
	protected static final String CHANGE_DEL_ROLE_MEMBER_METHOD_TO_CALL = "methodToCall.changeDelegationRoleMember";

    @SuppressWarnings("unchecked")
	@Override
    public void populate(HttpServletRequest request) {
        super.populate(request);

        if (memberTableMetadata == null)
        	memberTableMetadata = new KualiTableRenderFormMetadata();

        if (KRADConstants.TableRenderConstants.SWITCH_TO_PAGE_METHOD.equals(getMethodToCall())) {
            final String paramPrefix = KRADConstants.DISPATCH_REQUEST_PARAMETER + "." + KRADConstants.TableRenderConstants.SWITCH_TO_PAGE_METHOD + ".";
            memberTableMetadata.setSwitchToPageNumber(
                    PagingBannerUtils.getNumbericalValueAfterPrefix(paramPrefix, request.getParameterNames()));
            if (memberTableMetadata.getSwitchToPageNumber() == -1) {
                throw new RuntimeException("Couldn't find page number");
            }
        } else if (KRADConstants.TableRenderConstants.SORT_METHOD.equals(getMethodToCall())) {
            final String paramPrefix = KRADConstants.DISPATCH_REQUEST_PARAMETER + "." + KRADConstants.TableRenderConstants.SORT_METHOD + ".";
            memberTableMetadata.setColumnToSortIndex(PagingBannerUtils.getNumbericalValueAfterPrefix(paramPrefix, request.getParameterNames()));
            if (memberTableMetadata.getColumnToSortIndex() == -1) {
                memberTableMetadata.setColumnToSortName(PagingBannerUtils.getStringValueAfterPrefix(paramPrefix, request.getParameterNames()));
            }
        }
    }

	public KualiTableRenderFormMetadata getMemberTableMetadata() {
		return this.memberTableMetadata;
	}

	public void setMemberTableMetadata(
			KualiTableRenderFormMetadata memberTableMetadata) {
		this.memberTableMetadata = memberTableMetadata;
	}

	public int getRecordsPerPage() {
		if ( recordsPerPage == -1 ) {
			Parameter param = CoreFrameworkServiceLocator.getParameterService().getParameter(KimConstants.NAMESPACE_CODE, KRADConstants.DetailTypes.DOCUMENT_DETAIL_TYPE, MAX_MEMBERS_PER_PAGE_PARM);
			if ( param != null ) {
				try {
					recordsPerPage = Integer.parseInt( param.getValue() );
				} catch ( NumberFormatException ex ) {
					LOG.error( "Unable to parse parameter " + KimConstants.NAMESPACE_CODE+"/"+ KRADConstants.DetailTypes.DOCUMENT_DETAIL_TYPE+"/"+MAX_MEMBERS_PER_PAGE_PARM + "(+"+param.getValue()+") as an int - defaulting to 1.", ex);
					recordsPerPage = 1;
				}
			} else {
				LOG.error( "Unable to find " + KimConstants.NAMESPACE_CODE+"/"+ KRADConstants.DetailTypes.DOCUMENT_DETAIL_TYPE+"/"+MAX_MEMBERS_PER_PAGE_PARM + " - defaulting to 1." );
				recordsPerPage = 1;
			}
		}
		return recordsPerPage;
	}

	// support for the inquiryControls tag since using same form
	public boolean isCanExport() {
		return false;
	}
	
	@SuppressWarnings("unchecked")
	public List getMemberRows() {
		return new ArrayList();
	}

	/**
	 * @return the inquiry
	 */
	public boolean isInquiry() {
		return this.inquiry;
	}

	/**
	 * @param inquiry the inquiry to set
	 */
	public void setInquiry(boolean inquiry) {
		this.inquiry = inquiry;
	}
}
