/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.ThreadContext;
import org.kuali.rice.kew.actionrequest.ActionRequestFactory;
import org.kuali.rice.kew.actionrequest.ActionRequestValue;
import org.kuali.rice.kew.actionrequest.Recipient;
import org.kuali.rice.kew.actions.ActionTakenEvent;
import org.kuali.rice.kew.actiontaken.ActionTakenValue;
import org.kuali.rice.kew.api.WorkflowRuntimeException;
import org.kuali.rice.kew.api.action.ActionRequestType;
import org.kuali.rice.kew.api.action.ActionType;
import org.kuali.rice.kew.api.doctype.DocumentTypePolicy;
import org.kuali.rice.kew.api.exception.InvalidActionTakenException;
import org.kuali.rice.kew.engine.CompatUtils;
import org.kuali.rice.kew.engine.RouteHelper;
import org.kuali.rice.kew.engine.node.NodeGraphSearchCriteria;
import org.kuali.rice.kew.engine.node.NodeGraphSearchResult;
import org.kuali.rice.kew.engine.node.RouteNode;
import org.kuali.rice.kew.engine.node.RouteNodeInstance;
import org.kuali.rice.kew.engine.node.service.RouteNodeService;
import org.kuali.rice.kew.framework.postprocessor.DocumentRouteLevelChange;
import org.kuali.rice.kew.framework.postprocessor.PostProcessor;
import org.kuali.rice.kew.framework.postprocessor.ProcessDocReport;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kim.api.identity.principal.PrincipalContract;

public class ReturnToPreviousNodeAction
extends ActionTakenEvent {
    protected static final Logger LOG = LogManager.getLogger(ReturnToPreviousNodeAction.class);
    protected static final String INITIAL_NODE_NAME = null;
    protected static final boolean DEFAULT_SEND_NOTIFICATIONS = true;
    private final RouteHelper helper = new RouteHelper();
    protected final String nodeName;
    private boolean superUserUsage;
    private final boolean sendNotifications;
    private final boolean sendNotificationsForPreviousRequests;

    public ReturnToPreviousNodeAction(DocumentRouteHeaderValue routeHeader, PrincipalContract principal) {
        this("Z", routeHeader, principal, DEFAULT_ANNOTATION, INITIAL_NODE_NAME, true);
    }

    public ReturnToPreviousNodeAction(DocumentRouteHeaderValue routeHeader, PrincipalContract principal, String annotation, String nodeName, boolean sendNotifications) {
        this("Z", routeHeader, principal, annotation, nodeName, sendNotifications);
    }

    public ReturnToPreviousNodeAction(DocumentRouteHeaderValue routeHeader, PrincipalContract principal, String annotation, String nodeName, boolean sendNotifications, boolean runPostProcessorLogic) {
        this("Z", routeHeader, principal, annotation, nodeName, sendNotifications, runPostProcessorLogic);
    }

    protected ReturnToPreviousNodeAction(String overrideActionTakenCode, DocumentRouteHeaderValue routeHeader, PrincipalContract principal, String annotation, String nodeName, boolean sendNotifications) {
        this(overrideActionTakenCode, routeHeader, principal, annotation, nodeName, sendNotifications, true);
    }

    protected ReturnToPreviousNodeAction(String overrideActionTakenCode, DocumentRouteHeaderValue routeHeader, PrincipalContract principal, String annotation, String nodeName, boolean sendNotifications, boolean runPostProcessorLogic) {
        super(overrideActionTakenCode, routeHeader, principal, annotation, runPostProcessorLogic);
        this.nodeName = nodeName;
        this.sendNotifications = ReturnToPreviousNodeAction.isPolicySet(routeHeader.getDocumentType(), DocumentTypePolicy.NOTIFY_PENDING_ON_RETURN, sendNotifications);
        this.sendNotificationsForPreviousRequests = ReturnToPreviousNodeAction.isPolicySet(routeHeader.getDocumentType(), DocumentTypePolicy.NOTIFY_COMPLETED_ON_RETURN);
    }

    private void revokePendingRequests(List<ActionRequestValue> pendingRequests, ActionTakenValue actionTaken, PrincipalContract principal, Recipient delegator) {
        pendingRequests = this.revokeRequests(pendingRequests);
        pendingRequests = this.getActionRequestService().deactivateRequests(actionTaken, pendingRequests);
        if (this.sendNotifications) {
            this.generateNotificationsForRevokedRequests(pendingRequests, principal, delegator);
        }
    }

    private List<ActionRequestValue> revokePreviousRequests(List<ActionRequestValue> actionRequests, PrincipalContract principal, Recipient delegator) {
        actionRequests = this.revokeRequests(actionRequests);
        if (this.sendNotificationsForPreviousRequests) {
            this.generateNotificationsForRevokedRequests(actionRequests, principal, delegator);
        }
        return actionRequests;
    }

    private void generateNotificationsForRevokedRequests(List<ActionRequestValue> revokedRequests, PrincipalContract principal, Recipient delegator) {
        ActionRequestFactory arFactory = new ActionRequestFactory(this.getRouteHeader());
        List<ActionRequestValue> notificationRequests = arFactory.generateNotifications(revokedRequests, principal, delegator, "F", this.getActionTakenCode());
        this.getActionRequestService().activateRequests(notificationRequests);
    }

    private List<ActionRequestValue> revokeRequests(List<ActionRequestValue> actionRequests) {
        ArrayList<ActionRequestValue> revokedRequests = new ArrayList<ActionRequestValue>();
        for (ActionRequestValue actionRequest : actionRequests) {
            actionRequest.setCurrentIndicator(Boolean.FALSE);
            if (actionRequest.getActionTaken() != null) {
                actionRequest.getActionTaken().setCurrentIndicator(Boolean.FALSE);
                actionRequest.setActionTaken(KEWServiceLocator.getActionTakenService().saveActionTaken(actionRequest.getActionTaken()));
            }
            actionRequest.setChildrenRequests(this.revokeRequests(actionRequest.getChildrenRequests()));
            revokedRequests.add(KEWServiceLocator.getActionRequestService().saveActionRequest(actionRequest));
        }
        return revokedRequests;
    }

    protected ActionRequestType getReturnToInitiatorActionRequestType() {
        return ActionRequestType.APPROVE;
    }

    public void processReturnToInitiator(RouteNodeInstance newNodeInstance) {
        RouteNode initialNode = newNodeInstance.getRouteNode().getDocumentType().getPrimaryProcess().getInitialRouteNode();
        if (initialNode != null && newNodeInstance.getRouteNode().getRouteNodeId().equals(initialNode.getRouteNodeId())) {
            LOG.debug("Document was returned to initiator");
            ActionRequestFactory arFactory = new ActionRequestFactory(this.getRouteHeader(), newNodeInstance);
            ActionRequestValue notificationRequest = arFactory.createNotificationRequest(this.getReturnToInitiatorActionRequestType().getCode(), this.determineInitialNodePrincipal(this.getRouteHeader()), this.getActionTakenCode(), this.getPrincipal(), "Document initiator");
            this.getActionRequestService().activateRequest(notificationRequest);
        }
    }

    protected PrincipalContract determineInitialNodePrincipal(DocumentRouteHeaderValue routeHeader) {
        return routeHeader.getInitiatorPrincipal();
    }

    @Override
    public String validateActionRules() {
        return this.validateActionRules(this.getActionRequestService().findAllPendingRequests(this.routeHeader.getDocumentId()));
    }

    @Override
    public String validateActionRules(List<ActionRequestValue> actionRequests) {
        if (!this.getRouteHeader().isValidActionToTake(this.getActionPerformedCode())) {
            String docStatus = this.getRouteHeader().getDocRouteStatus();
            return "Document of status '" + docStatus + "' cannot taken action 'RETURNED TO PREVIOUS ROUTE LEVEL' to node name " + this.nodeName;
        }
        List<ActionRequestValue> filteredActionRequests = this.findApplicableActionRequests(actionRequests);
        if (!(this.isActionCompatibleRequest(filteredActionRequests) || this.isSuperUserUsage() || this.canReturnToPreviousNode())) {
            return "No request for the user is compatible with the " + ActionType.fromCode((String)this.getActionTakenCode()).getLabel() + " action";
        }
        return "";
    }

    protected boolean canReturnToPreviousNode() {
        return KEWServiceLocator.getDocumentTypePermissionService().canReturnToPreviousRouteNode(this.getPrincipal().getPrincipalId(), this.getRouteHeader());
    }

    protected List<ActionRequestValue> findApplicableActionRequests(List<ActionRequestValue> actionRequests) {
        return this.filterActionRequestsByCode(actionRequests, "C");
    }

    @Override
    public boolean isActionCompatibleRequest(List<ActionRequestValue> requests) {
        String actionTakenCode = this.getActionPerformedCode();
        if ("M".equals(actionTakenCode)) {
            return true;
        }
        if (this.routeHeader.isStateInitiated() || this.routeHeader.isStateSaved()) {
            return true;
        }
        boolean actionCompatible = false;
        Iterator<ActionRequestValue> ars = requests.iterator();
        ActionRequestValue actionRequest = null;
        while (ars.hasNext()) {
            actionRequest = ars.next();
            String request = actionRequest.getActionRequested();
            if ("F".equals(request) || "K".equals(request) || "A".equals(request) || "C".equals(request)) {
                actionCompatible = true;
                break;
            }
            if (!"Z".equals(actionTakenCode) || !"C".equals(request) && !"A".equals(request)) continue;
            actionCompatible = true;
        }
        return actionCompatible;
    }

    @Override
    public void recordAction() throws InvalidActionTakenException {
        ThreadContext.put((String)"docId", (String)this.getRouteHeader().getDocumentId());
        this.updateSearchableAttributesIfPossible();
        LOG.debug("Returning document " + this.getRouteHeader().getDocumentId() + " to previous node: " + this.nodeName + ", annotation: " + this.annotation);
        List<ActionRequestValue> actionRequests = this.getActionRequestService().findAllValidRequests(this.getPrincipal().getPrincipalId(), this.getDocumentId(), "C");
        String errorMessage = this.validateActionRules(actionRequests);
        if (!StringUtils.isEmpty((String)errorMessage)) {
            throw new InvalidActionTakenException(errorMessage);
        }
        List<RouteNodeInstance> activeNodeInstances = KEWServiceLocator.getRouteNodeService().getActiveNodeInstances(this.getRouteHeader().getDocumentId());
        NodeGraphSearchCriteria criteria = new NodeGraphSearchCriteria(2, activeNodeInstances, this.nodeName);
        NodeGraphSearchResult result = KEWServiceLocator.getRouteNodeService().searchNodeGraph(criteria);
        this.validateReturnPoint(this.nodeName, activeNodeInstances, result);
        LOG.debug("Record the returnToPreviousNode action");
        Recipient delegator = this.findDelegatorForActionRequests(actionRequests);
        ActionTakenValue actionTaken = this.saveActionTaken(Boolean.FALSE, delegator);
        LOG.debug("Finding requests in return path and setting current indicator to FALSE");
        ArrayList<ActionRequestValue> doneRequests = new ArrayList<ActionRequestValue>();
        ArrayList<ActionRequestValue> pendingRequests = new ArrayList<ActionRequestValue>();
        for (RouteNodeInstance nodeInstance : result.getPath()) {
            KEWServiceLocator.getRouteNodeService().revokeNodeInstance(this.getRouteHeader(), nodeInstance);
            List<ActionRequestValue> nodeRequests = this.getActionRequestService().findRootRequestsByDocIdAtRouteNode(this.getRouteHeader().getDocumentId(), nodeInstance.getRouteNodeInstanceId());
            for (ActionRequestValue request : nodeRequests) {
                if (request.isDone()) {
                    doneRequests.add(request);
                    continue;
                }
                pendingRequests.add(request);
            }
        }
        this.revokePreviousRequests(doneRequests, this.getPrincipal(), delegator);
        LOG.debug("Change pending requests to FYI and activate for docId " + this.getRouteHeader().getDocumentId());
        this.revokePendingRequests(pendingRequests, actionTaken, this.getPrincipal(), delegator);
        this.notifyActionTaken(actionTaken);
        this.executeNodeChange(activeNodeInstances, result);
        this.sendAdditionalNotifications();
    }

    protected void sendAdditionalNotifications() {
    }

    private void validateReturnPoint(String nodeName, Collection activeNodeInstances, NodeGraphSearchResult result) throws InvalidActionTakenException {
        RouteNodeInstance resultNodeInstance = result.getResultNodeInstance();
        if (result.getResultNodeInstance() == null) {
            throw new InvalidActionTakenException("Could not locate return point for node name '" + nodeName + "'.");
        }
        this.assertValidNodeType(resultNodeInstance);
        this.assertValidBranch(resultNodeInstance, activeNodeInstances);
        this.assertValidProcess(resultNodeInstance, activeNodeInstances);
        this.assertFinalApprovalNodeNotInPath(result.getPath());
    }

    private void assertValidNodeType(RouteNodeInstance resultNodeInstance) throws InvalidActionTakenException {
        if (!this.helper.isSimpleNode(resultNodeInstance.getRouteNode()) && !this.helper.isSplitNode(resultNodeInstance.getRouteNode())) {
            throw new InvalidActionTakenException("Can only return to a simple or a split node, attempting to return to " + resultNodeInstance.getRouteNode().getNodeType());
        }
    }

    private void assertValidBranch(RouteNodeInstance resultNodeInstance, Collection activeNodeInstances) throws InvalidActionTakenException {
        boolean inValidBranch = false;
        if (resultNodeInstance.getBranch().getParentBranch() == null) {
            inValidBranch = true;
        } else {
            for (RouteNodeInstance nodeInstance : activeNodeInstances) {
                if (!nodeInstance.getBranch().getBranchId().equals(resultNodeInstance.getBranch().getBranchId())) continue;
                inValidBranch = true;
                break;
            }
        }
        if (!inValidBranch) {
            throw new InvalidActionTakenException("Returning to an illegal branch, can only return to node within the same branch as an active node or to the primary branch.");
        }
    }

    private void assertValidProcess(RouteNodeInstance resultNodeInstance, Collection activeNodeInstances) throws InvalidActionTakenException {
        if (resultNodeInstance.isInProcess()) {
            boolean inValidProcess = false;
            for (RouteNodeInstance nodeInstance : activeNodeInstances) {
                if (!nodeInstance.isInProcess() || !nodeInstance.getProcess().getRouteNodeInstanceId().equals(nodeInstance.getProcess().getRouteNodeInstanceId())) continue;
                inValidProcess = true;
                break;
            }
            if (!inValidProcess) {
                throw new InvalidActionTakenException("Returning into an illegal process, cannot return to node within a previously executing process.");
            }
        }
    }

    private void assertFinalApprovalNodeNotInPath(List path) throws InvalidActionTakenException {
        for (RouteNodeInstance nodeInstance : path) {
            if (!nodeInstance.isComplete() || !Boolean.TRUE.equals(nodeInstance.getRouteNode().getFinalApprovalInd())) continue;
            throw new InvalidActionTakenException("Cannot return past or through the final approval node '" + nodeInstance.getName() + "'.");
        }
    }

    public void executeNodeChange(Collection activeNodes, NodeGraphSearchResult result) throws InvalidActionTakenException {
        Integer oldRouteLevel = null;
        Integer newRouteLevel = null;
        if (CompatUtils.isRouteLevelCompatible(this.getRouteHeader())) {
            int returnPathLength = result.getPath().size() - 1;
            oldRouteLevel = this.getRouteHeader().getDocRouteLevel();
            newRouteLevel = oldRouteLevel - returnPathLength;
            LOG.debug("Changing route header " + this.getRouteHeader().getDocumentId() + " route level for backward compatibility to " + newRouteLevel);
            this.getRouteHeader().setDocRouteLevel(newRouteLevel);
            DocumentRouteHeaderValue routeHeaderValue = KEWServiceLocator.getRouteHeaderService().saveRouteHeader(this.routeHeader);
            this.setRouteHeader(routeHeaderValue);
        }
        List<RouteNodeInstance> startingNodes = this.determineStartingNodes(result.getPath(), activeNodes);
        RouteNodeInstance newNodeInstance = this.materializeReturnPoint(startingNodes, result);
        for (RouteNodeInstance activeNode : startingNodes) {
            this.notifyNodeChange(oldRouteLevel, newRouteLevel, activeNode, newNodeInstance);
        }
        this.processReturnToInitiator(newNodeInstance);
    }

    private void notifyNodeChange(Integer oldRouteLevel, Integer newRouteLevel, RouteNodeInstance oldNodeInstance, RouteNodeInstance newNodeInstance) throws InvalidActionTakenException {
        try {
            LOG.debug("Notifying post processor of route node change '" + oldNodeInstance.getName() + "'->'" + newNodeInstance.getName());
            PostProcessor postProcessor = this.routeHeader.getDocumentType().getPostProcessor();
            DocumentRouteHeaderValue routeHeaderValue = KEWServiceLocator.getRouteHeaderService().saveRouteHeader(this.getRouteHeader());
            this.setRouteHeader(routeHeaderValue);
            DocumentRouteLevelChange routeNodeChange = new DocumentRouteLevelChange(this.routeHeader.getDocumentId(), this.routeHeader.getAppDocId(), oldRouteLevel, newRouteLevel, oldNodeInstance.getName(), newNodeInstance.getName(), oldNodeInstance.getRouteNodeInstanceId(), newNodeInstance.getRouteNodeInstanceId());
            ProcessDocReport report = postProcessor.doRouteLevelChange(routeNodeChange);
            this.setRouteHeader(KEWServiceLocator.getRouteHeaderService().getRouteHeader(this.getDocumentId()));
            if (!report.isSuccess()) {
                LOG.warn(report.getMessage(), (Throwable)report.getProcessException());
                throw new InvalidActionTakenException(report.getMessage());
            }
        }
        catch (Exception ex) {
            throw new WorkflowRuntimeException(ex.getMessage(), (Throwable)ex);
        }
    }

    private List<RouteNodeInstance> determineStartingNodes(List path, Collection<RouteNodeInstance> activeNodes) {
        ArrayList<RouteNodeInstance> startingNodes = new ArrayList<RouteNodeInstance>();
        for (RouteNodeInstance activeNodeInstance : activeNodes) {
            if (!this.isInPath(activeNodeInstance, path)) continue;
            startingNodes.add(activeNodeInstance);
        }
        return startingNodes;
    }

    private boolean isInPath(RouteNodeInstance nodeInstance, List<RouteNodeInstance> path) {
        for (RouteNodeInstance pathNodeInstance : path) {
            if (!pathNodeInstance.getRouteNodeInstanceId().equals(nodeInstance.getRouteNodeInstanceId())) continue;
            return true;
        }
        return false;
    }

    private RouteNodeInstance materializeReturnPoint(Collection<RouteNodeInstance> startingNodes, NodeGraphSearchResult result) {
        RouteNodeService nodeService = KEWServiceLocator.getRouteNodeService();
        RouteNodeInstance returnInstance = result.getResultNodeInstance();
        RouteNodeInstance newNodeInstance = this.helper.getNodeFactory().createRouteNodeInstance(this.getDocumentId(), returnInstance.getRouteNode());
        newNodeInstance.setBranch(returnInstance.getBranch());
        newNodeInstance.setProcess(returnInstance.getProcess());
        newNodeInstance.setComplete(false);
        newNodeInstance.setActive(true);
        newNodeInstance = nodeService.save(newNodeInstance);
        for (RouteNodeInstance activeNodeInstance : startingNodes) {
            activeNodeInstance.setComplete(true);
            activeNodeInstance.setActive(false);
            activeNodeInstance.setInitial(false);
            activeNodeInstance.addNextNodeInstance(newNodeInstance);
        }
        for (RouteNodeInstance activeNodeInstance : startingNodes) {
            nodeService.save(activeNodeInstance);
        }
        return newNodeInstance;
    }

    public boolean isSuperUserUsage() {
        return this.superUserUsage;
    }

    public void setSuperUserUsage(boolean superUserUsage) {
        this.superUserUsage = superUserUsage;
    }
}

