/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.document;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.kuali.rice.core.api.exception.RiceRuntimeException;
import org.kuali.rice.kew.rule.RuleBaseValues;
import org.kuali.rice.kew.rule.RuleDelegationBo;
import org.kuali.rice.kew.rule.web.WebRuleUtils;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kns.document.MaintenanceDocument;
import org.kuali.rice.kns.maintenance.KualiMaintainableImpl;
import org.kuali.rice.kns.maintenance.Maintainable;
import org.kuali.rice.krad.maintenance.MaintenanceLock;

public class RoutingRuleDelegationMaintainable
extends KualiMaintainableImpl {
    public List getSections(MaintenanceDocument document, Maintainable oldMaintainable) {
        List sections = super.getSections(document, oldMaintainable);
        return WebRuleUtils.customizeSections(this.getThisRule(), sections, true);
    }

    public void processAfterNew(MaintenanceDocument document, Map<String, String[]> parameters) {
        this.initializeBusinessObjects(document);
        WebRuleUtils.validateRuleAndResponsibility(this.getOldRuleDelegation(document), this.getNewRuleDelegation(document), parameters);
        WebRuleUtils.validateRuleTemplateAndDocumentType(this.getOldRule(document), this.getNewRule(document), parameters);
        WebRuleUtils.establishDefaultRuleValues(this.getNewRule(document));
        this.getNewRule(document).setDocumentId(document.getDocumentHeader().getDocumentNumber());
    }

    private void initializeBusinessObjects(MaintenanceDocument document) {
        RuleDelegationBo oldRuleDelegation = this.getOldRuleDelegation(document);
        RuleDelegationBo newRuleDelegation = this.getNewRuleDelegation(document);
        if (oldRuleDelegation.getDelegationRule() == null) {
            oldRuleDelegation.setDelegationRule(new RuleBaseValues());
        }
        if (newRuleDelegation.getDelegationRule() == null) {
            newRuleDelegation.setDelegationRule(new RuleBaseValues());
        }
    }

    public void setGenerateDefaultValues(String docTypeName) {
    }

    public void saveBusinessObject() {
        WebRuleUtils.clearKeysForSave(this.getThisRuleDelegation());
        WebRuleUtils.translateResponsibilitiesForSave(this.getThisRule());
        WebRuleUtils.translateFieldValuesForSave(this.getThisRule());
        WebRuleUtils.processRuleForDelegationSave(this.getThisRuleDelegation());
        KEWServiceLocator.getRuleService().makeCurrent(this.getThisRuleDelegation(), true);
    }

    public void processAfterCopy(MaintenanceDocument document, Map<String, String[]> parameters) {
        WebRuleUtils.processRuleForCopy(document.getDocumentNumber(), this.getOldRule(document), this.getNewRule(document));
        super.processAfterCopy(document, parameters);
    }

    public void processAfterEdit(MaintenanceDocument document, Map<String, String[]> parameters) {
        if (!this.getOldRule(document).getCurrentInd().booleanValue()) {
            throw new RiceRuntimeException("Cannot edit a non-current version of a rule.");
        }
        WebRuleUtils.populateForCopyOrEdit(this.getOldRule(document), this.getNewRule(document));
        this.getNewRule(document).setPreviousRuleId(this.getOldRule(document).getId());
        this.getNewRule(document).setDocumentId(document.getDocumentHeader().getDocumentNumber());
        super.processAfterEdit(document, parameters);
    }

    public List<MaintenanceLock> generateMaintenanceLocks() {
        if (this.getThisRule().getId() == null) {
            return Collections.emptyList();
        }
        return super.generateMaintenanceLocks();
    }

    public String getDocumentTitle(MaintenanceDocument document) {
        StringBuffer title = new StringBuffer();
        RuleBaseValues rule = this.getThisRule();
        if (rule.getPreviousRuleId() != null) {
            title.append("Editing Rule Delegation '").append(rule.getDescription()).append("'");
        } else {
            title.append("Adding Rule Delegation '").append(rule.getDescription()).append("'");
        }
        return title.toString();
    }

    protected RuleDelegationBo getNewRuleDelegation(MaintenanceDocument document) {
        return (RuleDelegationBo)((Object)document.getNewMaintainableObject().getDataObject());
    }

    protected RuleDelegationBo getOldRuleDelegation(MaintenanceDocument document) {
        return (RuleDelegationBo)((Object)document.getOldMaintainableObject().getDataObject());
    }

    protected RuleDelegationBo getThisRuleDelegation() {
        return (RuleDelegationBo)((Object)this.getDataObject());
    }

    protected RuleBaseValues getNewRule(MaintenanceDocument document) {
        return this.getNewRuleDelegation(document).getDelegationRule();
    }

    protected RuleBaseValues getOldRule(MaintenanceDocument document) {
        return this.getOldRuleDelegation(document).getDelegationRule();
    }

    protected RuleBaseValues getThisRule() {
        return this.getThisRuleDelegation().getDelegationRule();
    }

    public void prepareForSave() {
        super.prepareForSave();
    }
}

