/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.impl.document;

import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.document.Document;
import org.kuali.rice.kew.api.document.DocumentContentUpdate;
import org.kuali.rice.kew.api.document.DocumentUpdate;
import org.kuali.rice.kew.impl.document.WorkflowDocumentPrototype;
import org.kuali.rice.kew.impl.document.WorkflowDocumentProvider;
import org.kuali.rice.kew.service.KEWServiceLocator;

public final class DefaultWorkflowDocumentProvider
implements WorkflowDocumentProvider {
    @Override
    public WorkflowDocument createDocument(String principalId, String documentTypeName, DocumentUpdate documentUpdate, DocumentContentUpdate documentContentUpdate) {
        Document document = KewApiServiceLocator.getWorkflowDocumentActionsService().create(documentTypeName, principalId, documentUpdate, documentContentUpdate);
        return this.initializePrototype(principalId, document);
    }

    @Override
    public WorkflowDocument loadDocument(String principalId, String documentId) {
        Document document = KewApiServiceLocator.getWorkflowDocumentService().getDocument(documentId);
        if (document == null) {
            throw new IllegalArgumentException("Failed to locate workflow document for given documentId: " + documentId);
        }
        return this.initializePrototype(principalId, document);
    }

    private WorkflowDocumentPrototype initializePrototype(String principalId, Document document) {
        WorkflowDocumentPrototype prototype = KEWServiceLocator.getWorkflowDocumentPrototype();
        prototype.init(principalId, document);
        return prototype;
    }
}

