/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.impl.mail;

import javax.xml.namespace.QName;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.kew.api.action.ActionItem;
import org.kuali.rice.kew.api.mail.ImmediateEmailReminderQueue;
import org.kuali.rice.kew.impl.mail.ImmediateEmailReminderQueueAsyncCapableImpl;
import org.kuali.rice.kew.mail.service.ActionListEmailService;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.ksb.api.messaging.AsyncCapableService;
import org.kuali.rice.ksb.api.messaging.AsyncWrappable;

public class ImmediateEmailReminderQueueImpl
implements ImmediateEmailReminderQueue,
AsyncWrappable<ImmediateEmailReminderQueue> {
    private ActionListEmailService actionListEmailService;
    private AsyncCapableService asyncCapableService;

    public void sendReminder(ActionItem actionItem, Boolean skipOnApprovals) {
        if (actionItem == null) {
            throw new RiceIllegalArgumentException("actionItem was null");
        }
        if (skipOnApprovals == null) {
            skipOnApprovals = false;
        }
        this.getActionListEmailService().sendImmediateReminder(actionItem, skipOnApprovals);
    }

    public ImmediateEmailReminderQueue wrap(QName qname, String applicationId) {
        return new ImmediateEmailReminderQueueAsyncCapableImpl(this.asyncCapableService, this, qname, applicationId);
    }

    private ActionListEmailService getActionListEmailService() {
        if (this.actionListEmailService == null) {
            this.actionListEmailService = (ActionListEmailService)KEWServiceLocator.getService("enActionListEmailService");
        }
        return this.actionListEmailService;
    }

    public void setActionListEmailService(ActionListEmailService actionListEmailService) {
        this.actionListEmailService = actionListEmailService;
    }

    public AsyncCapableService getAsyncCapableService() {
        return this.asyncCapableService;
    }

    public void setAsyncCapableService(AsyncCapableService asyncCapableService) {
        this.asyncCapableService = asyncCapableService;
    }
}

