/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.mail;

import javax.xml.transform.Templates;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.mail.EmailContent;
import org.kuali.rice.core.api.util.xml.XmlJotter;
import org.kuali.rice.kew.api.WorkflowRuntimeException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class EmailStyleHelper {
    private static final Logger LOG = LogManager.getLogger(EmailStyleHelper.class);

    public EmailContent generateEmailContent(Templates style, Document document) {
        DOMResult result = new DOMResult();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Input document: " + XmlJotter.jotNode((Node)document.getDocumentElement(), (boolean)true));
        }
        try {
            style.newTransformer().transform(new DOMSource(document), result);
        }
        catch (TransformerException te) {
            String message = "Error transforming immediate reminder DOM";
            LOG.error(message, (Throwable)te);
            throw new WorkflowRuntimeException(message, (Throwable)te);
        }
        Node node = result.getNode();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Email to be sent: " + XmlJotter.jotNode((Node)node));
        }
        XPathFactory xpf = XPathFactory.newInstance();
        XPath xpath = xpf.newXPath();
        try {
            String subject = (String)xpath.evaluate("/email/subject", node, XPathConstants.STRING);
            String body = (String)xpath.evaluate("/email/body", node, XPathConstants.STRING);
            return new EmailContent(subject, body, body.matches("(?msi).*<(\\w+:)?html.*"));
        }
        catch (XPathExpressionException xpee) {
            throw new WorkflowRuntimeException("Error evaluating generated email content", (Throwable)xpee);
        }
    }
}

