/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.mail.service.impl;

import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.coreservice.framework.CoreFrameworkServiceLocator;
import org.kuali.rice.kew.actionrequest.ActionRequestValue;
import org.kuali.rice.kew.api.action.ActionItem;
import org.kuali.rice.kew.api.action.ActionRequest;
import org.kuali.rice.kew.api.document.Document;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kew.doctype.bo.DocumentType;
import org.kuali.rice.kew.mail.CustomEmailAttribute;
import org.kuali.rice.kew.mail.service.EmailContentService;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kim.api.identity.Person;

public abstract class BaseEmailContentServiceImpl
implements EmailContentService {
    protected String defaultEmailFromAddress = "admin@localhost";
    protected String deploymentEnvironment;

    public void setDefaultEmailFromAddress(String defaultEmailFromAddress) {
        this.defaultEmailFromAddress = defaultEmailFromAddress;
    }

    @Override
    public String getApplicationEmailAddress() {
        String fromAddress = CoreFrameworkServiceLocator.getParameterService().getParameterValueAsString("KR-WKFLW", "Mailer", "FROM_ADDRESS");
        if (StringUtils.isEmpty((String)fromAddress)) {
            fromAddress = this.defaultEmailFromAddress;
        }
        return fromAddress;
    }

    @Override
    public String getDocumentTypeEmailAddress(DocumentType documentType) {
        String fromAddress;
        String string = fromAddress = documentType == null ? null : documentType.getNotificationFromAddress();
        if (StringUtils.isEmpty((String)fromAddress)) {
            fromAddress = this.getApplicationEmailAddress();
        }
        return fromAddress;
    }

    public String getDeploymentEnvironment() {
        return this.deploymentEnvironment;
    }

    public void setDeploymentEnvironment(String deploymentEnvironment) {
        this.deploymentEnvironment = deploymentEnvironment;
    }

    protected static CustomEmailAttribute getCustomEmailAttribute(Person user, ActionItem actionItem) throws WorkflowException {
        DocumentRouteHeaderValue routeHeader = KEWServiceLocator.getRouteHeaderService().getRouteHeader(actionItem.getDocumentId());
        CustomEmailAttribute customEmailAttribute = routeHeader.getCustomEmailAttribute();
        if (customEmailAttribute != null) {
            Document routeHeaderVO = DocumentRouteHeaderValue.to(routeHeader);
            ActionRequestValue actionRequest = KEWServiceLocator.getActionRequestService().findByActionRequestId(actionItem.getActionRequestId());
            ActionRequest actionRequestVO = ActionRequestValue.to(actionRequest);
            customEmailAttribute.setRouteHeaderVO(routeHeaderVO);
            customEmailAttribute.setActionRequestVO(actionRequestVO);
        }
        return customEmailAttribute;
    }

    protected String getActionListUrl() {
        return ConfigContext.getCurrentContextConfig().getProperty("workflow.url") + "/ActionList.do";
    }

    protected String getPreferencesUrl() {
        return ConfigContext.getCurrentContextConfig().getProperty("workflow.url") + "/Preferences.do";
    }

    protected String getRouteLogUrl() {
        return ConfigContext.getCurrentContextConfig().getProperty("workflow.url") + "/RouteLog.do?documentId=";
    }
}

