/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.rule.xmlrouting;

import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFunction;
import javax.xml.xpath.XPathFunctionResolver;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.kew.api.WorkflowRuntimeException;
import org.kuali.rice.kew.api.rule.RuleExtension;
import org.kuali.rice.kew.rule.xmlrouting.UpperCaseFunction;
import org.kuali.rice.kew.xml.xstream.XStreamSafeSearchFunction;
import org.w3c.dom.Node;

public class WorkflowFunctionResolver
implements XPathFunctionResolver {
    private List<RuleExtension> ruleExtensions;
    private Node rootNode;
    private XPath xpath;

    @Override
    public XPathFunction resolveFunction(QName fname, int arity) {
        if (fname == null) {
            throw new NullPointerException("The function name cannot be null.");
        }
        if (fname.equals(new QName("http://nothingfornowwf.com", "ruledata", "wf"))) {
            if (this.ruleExtensions == null) {
                throw new IllegalArgumentException("There are no rule extensions.");
            }
            return new XPathFunction(){

                public Object evaluate(List args) {
                    if (args.size() == 1) {
                        String name = (String)args.get(0);
                        for (RuleExtension ruleExtension : WorkflowFunctionResolver.this.ruleExtensions) {
                            for (Map.Entry entry : ruleExtension.getExtensionValuesMap().entrySet()) {
                                if (!((String)entry.getKey()).equals(name)) continue;
                                return entry.getValue();
                            }
                        }
                    }
                    return "";
                }
            };
        }
        if (fname.equals(new QName("http://nothingfornowwf.com", "xstreamsafe", "wf"))) {
            return new XStreamSafeSearchFunction(this.rootNode, this.getXpath());
        }
        if (fname.equals(new QName("http://nothingfornowwf.com", "upper-case", "wf"))) {
            return new UpperCaseFunction();
        }
        if (fname.equals(new QName("http://nothingfornowwf.com", "field", "wf"))) {
            return new XPathFunction(){

                public Object evaluate(List args) {
                    if (args.size() == 1) {
                        String name = (String)args.get(0);
                        try {
                            return WorkflowFunctionResolver.this.field(name);
                        }
                        catch (Exception e) {
                            throw new WorkflowRuntimeException("Failed to find field to validate.", (Throwable)e);
                        }
                    }
                    return "";
                }
            };
        }
        if (fname.equals(new QName("http://nothingfornowwf.com", "empty", "wf"))) {
            return new XPathFunction(){

                public Object evaluate(List args) {
                    return WorkflowFunctionResolver.this.empty(args.get(0));
                }
            };
        }
        return null;
    }

    public String field(String fieldName) throws Exception {
        return this.xpath.evaluate("//edlContent/data/version[@current='true']/field[@name='" + fieldName + "']/value", this.rootNode);
    }

    public boolean empty(Object object) {
        if (object instanceof String) {
            return StringUtils.isBlank((String)((String)object));
        }
        return object == null;
    }

    public List<RuleExtension> getRuleExtensions() {
        return this.ruleExtensions;
    }

    public void setRuleExtensions(List<RuleExtension> ruleExtensions) {
        this.ruleExtensions = ruleExtensions;
    }

    public Node getRootNode() {
        return this.rootNode;
    }

    public void setRootNode(Node rootNode) {
        this.rootNode = rootNode;
    }

    public XPath getXpath() {
        return this.xpath;
    }

    public void setXpath(XPath xpath) {
        this.xpath = xpath;
    }
}

