/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.util;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClassDumper {
    private static final Logger LOG = LogManager.getLogger(ClassDumper.class);

    public static void dumpFieldsToLog(Object o) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(ClassDumper.dumpFields(o));
        } else if (LOG.isInfoEnabled()) {
            if (o == null) {
                LOG.info("null");
            } else {
                LOG.info(String.valueOf(o.getClass()) + ": " + o.toString());
            }
        }
    }

    public static String dumpFields(Object o) {
        StringBuffer buf = new StringBuffer();
        if (o == null) {
            return "NULL";
        }
        Class<?> clazz = o.getClass();
        Field[] fields = clazz.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            try {
                String methodName = "get" + fields[i].getName().substring(0, 1).toUpperCase() + fields[i].getName().substring(1);
                Method method = clazz.getMethod(methodName, null);
                Object value = method.invoke(o, null);
                buf.append(fields[i].getName()).append(" : ");
                if (value == null) {
                    buf.append("null\n");
                    continue;
                }
                buf.append(value.toString()).append("\n");
                continue;
            }
            catch (IllegalAccessException e) {
                buf.append(fields[i].getName()).append(" unavailable by security policy\n");
                continue;
            }
            catch (NoSuchMethodException ex) {
                buf.append(fields[i].getName()).append(" no getter method for this field\n");
                continue;
            }
            catch (InvocationTargetException ex) {
                buf.append(fields[i].getName()).append(" unable to invoke the method on target\n");
            }
        }
        return buf.toString();
    }
}

