/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.document.rule;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.membership.MemberType;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.core.api.uif.RemotableAttributeError;
import org.kuali.rice.core.api.util.VersionHelper;
import org.kuali.rice.kim.api.KimConstants;
import org.kuali.rice.kim.api.identity.IdentityService;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kim.api.permission.Permission;
import org.kuali.rice.kim.api.responsibility.Responsibility;
import org.kuali.rice.kim.api.responsibility.ResponsibilityContract;
import org.kuali.rice.kim.api.role.Role;
import org.kuali.rice.kim.api.role.RoleService;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kim.api.type.KimAttributeField;
import org.kuali.rice.kim.api.type.KimType;
import org.kuali.rice.kim.bo.ui.KimDocumentRoleMember;
import org.kuali.rice.kim.bo.ui.KimDocumentRolePermission;
import org.kuali.rice.kim.bo.ui.KimDocumentRoleQualifier;
import org.kuali.rice.kim.bo.ui.KimDocumentRoleResponsibility;
import org.kuali.rice.kim.bo.ui.KimDocumentRoleResponsibilityAction;
import org.kuali.rice.kim.bo.ui.RoleDocumentDelegationMember;
import org.kuali.rice.kim.bo.ui.RoleDocumentDelegationMemberQualifier;
import org.kuali.rice.kim.document.IdentityManagementRoleDocument;
import org.kuali.rice.kim.document.rule.ActiveRoleMemberHelper;
import org.kuali.rice.kim.document.rule.AttributeValidationHelper;
import org.kuali.rice.kim.framework.role.RoleTypeService;
import org.kuali.rice.kim.framework.services.KimFrameworkServiceLocator;
import org.kuali.rice.kim.framework.type.KimTypeService;
import org.kuali.rice.kim.impl.common.attribute.KimAttributeBo;
import org.kuali.rice.kim.impl.responsibility.AddResponsibilityEvent;
import org.kuali.rice.kim.impl.responsibility.AddResponsibilityRule;
import org.kuali.rice.kim.impl.responsibility.KimDocumentResponsibilityRule;
import org.kuali.rice.kim.impl.responsibility.ResponsibilityBo;
import org.kuali.rice.kim.impl.responsibility.ResponsibilityInternalService;
import org.kuali.rice.kim.impl.services.KimImplServiceLocator;
import org.kuali.rice.kim.impl.type.KimTypeLookupableHelperServiceImpl;
import org.kuali.rice.kim.rule.event.ui.AddDelegationEvent;
import org.kuali.rice.kim.rule.event.ui.AddDelegationMemberEvent;
import org.kuali.rice.kim.rule.event.ui.AddMemberEvent;
import org.kuali.rice.kim.rule.event.ui.AddPermissionEvent;
import org.kuali.rice.kim.rule.ui.AddDelegationMemberRule;
import org.kuali.rice.kim.rule.ui.AddDelegationRule;
import org.kuali.rice.kim.rule.ui.AddMemberRule;
import org.kuali.rice.kim.rule.ui.AddPermissionRule;
import org.kuali.rice.kim.rules.ui.KimDocumentMemberRule;
import org.kuali.rice.kim.rules.ui.KimDocumentPermissionRule;
import org.kuali.rice.kim.rules.ui.RoleDocumentDelegationMemberRule;
import org.kuali.rice.kim.rules.ui.RoleDocumentDelegationRule;
import org.kuali.rice.kns.kim.type.DataDictionaryTypeServiceHelper;
import org.kuali.rice.kns.rules.TransactionalDocumentRuleBase;
import org.kuali.rice.krad.data.KradDataServiceLocator;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.MessageMap;
import org.kuali.rice.ksb.api.KsbApiServiceLocator;
import org.kuali.rice.ksb.api.bus.Endpoint;
import org.kuali.rice.ksb.api.bus.ServiceBus;

public class IdentityManagementRoleDocumentRule
extends TransactionalDocumentRuleBase
implements AddPermissionRule,
AddResponsibilityRule,
AddMemberRule,
AddDelegationRule,
AddDelegationMemberRule {
    public static final int PRIORITY_NUMBER_MIN_VALUE = 1;
    public static final int PRIORITY_NUMBER_MAX_VALUE = 11;
    protected AddResponsibilityRule addResponsibilityRule;
    protected AddPermissionRule addPermissionRule;
    protected AddMemberRule addMemberRule;
    protected AddDelegationRule addDelegationRule;
    protected AddDelegationMemberRule addDelegationMemberRule;
    protected Class<? extends AddResponsibilityRule> addResponsibilityRuleClass = KimDocumentResponsibilityRule.class;
    protected Class<? extends AddPermissionRule> addPermissionRuleClass = KimDocumentPermissionRule.class;
    protected Class<? extends AddMemberRule> addMemberRuleClass = KimDocumentMemberRule.class;
    protected Class<? extends AddDelegationRule> addDelegationRuleClass = RoleDocumentDelegationRule.class;
    protected Class<? extends AddDelegationMemberRule> addDelegationMemberRuleClass = RoleDocumentDelegationMemberRule.class;
    private static IdentityService identityService;
    private static ResponsibilityInternalService responsibilityInternalService;
    protected AttributeValidationHelper attributeValidationHelper = new AttributeValidationHelper();
    protected ActiveRoleMemberHelper activeRoleMemberHelper = new ActiveRoleMemberHelper();

    protected IdentityService getIdentityService() {
        if (identityService == null) {
            identityService = KimApiServiceLocator.getIdentityService();
        }
        return identityService;
    }

    protected boolean processCustomSaveDocumentBusinessRules(Document document) {
        if (!(document instanceof IdentityManagementRoleDocument)) {
            return false;
        }
        IdentityManagementRoleDocument roleDoc = (IdentityManagementRoleDocument)document;
        boolean valid = true;
        GlobalVariables.getMessageMap().addToErrorPath("document");
        boolean validRoleNamespace = this.validRoleNamespace(roleDoc);
        boolean validRoleName = this.validRoleName(roleDoc);
        if (!validRoleNamespace || !validRoleName) {
            return false;
        }
        valid &= this.validDuplicateRoleName(roleDoc);
        valid &= this.validPermissions(roleDoc);
        valid &= this.validResponsibilities(roleDoc);
        valid &= this.validRoleMemberPrincipalIDs(roleDoc.getModifiedMembers());
        this.getDictionaryValidationService().validateDocumentAndUpdatableReferencesRecursively(document, this.getMaxDictionaryValidationDepth(), true, false);
        if (!KimTypeLookupableHelperServiceImpl.hasDerivedRoleTypeService(roleDoc.getKimType()) && this.canUserAssignRoleMembers(roleDoc)) {
            List<KimDocumentRoleMember> activeRoleMembers = this.activeRoleMemberHelper.getActiveRoleMembers(roleDoc.getMembers());
            List<KimDocumentRoleMember> newActiveRoleMembers = this.activeRoleMemberHelper.getActiveRoleMembers(roleDoc.getModifiedMembers());
            List<RoleDocumentDelegationMember> activeRoleDelegationMembers = this.activeRoleMemberHelper.getActiveDelegationRoleMembers(roleDoc.getDelegationMembers());
            valid &= this.validateRoleQualifier(newActiveRoleMembers, roleDoc.getKimType());
            valid &= this.validRoleMemberActiveDates(roleDoc.getModifiedMembers());
            valid &= this.validateDelegationMemberRoleQualifier(newActiveRoleMembers, activeRoleDelegationMembers, roleDoc.getKimType(), activeRoleMembers);
            valid &= this.validDelegationMemberActiveDates(roleDoc.getDelegationMembers());
            valid &= this.validRoleMembersResponsibilityActions(roleDoc.getModifiedMembers());
        }
        GlobalVariables.getMessageMap().removeFromErrorPath("document");
        return valid &= this.validRoleResponsibilitiesActions(roleDoc.getResponsibilities());
    }

    protected boolean validRoleNamespace(IdentityManagementRoleDocument roleDoc) {
        boolean validRoleNamespace = false;
        if (StringUtils.isNotBlank((String)roleDoc.getRoleNamespace())) {
            validRoleNamespace = true;
        } else {
            GlobalVariables.getMessageMap().putError("document.roleNamespace", "error.empty.entry", new String[]{"Role Namespace"});
        }
        return validRoleNamespace;
    }

    protected boolean validRoleName(IdentityManagementRoleDocument roleDoc) {
        boolean validRoleName = false;
        if (StringUtils.isNotBlank((String)roleDoc.getRoleName())) {
            validRoleName = true;
        } else {
            GlobalVariables.getMessageMap().putError("document.roleName", "error.empty.entry", new String[]{"Role Name"});
        }
        return validRoleName;
    }

    protected boolean canUserAssignRoleMembers(IdentityManagementRoleDocument document) {
        boolean rulePassed = true;
        HashMap<String, String> additionalPermissionDetails = new HashMap<String, String>();
        additionalPermissionDetails.put("namespaceCode", document.getRoleNamespace());
        additionalPermissionDetails.put("roleName", document.getRoleName());
        if ((document.getMembers() != null && document.getMembers().size() > 0 || document.getDelegationMembers() != null && document.getDelegationMembers().size() > 0) && !IdentityManagementRoleDocumentRule.getDocumentDictionaryService().getDocumentAuthorizer((Document)document).isAuthorizedByTemplate((Object)document, "KR-IDM", "Assign Role", GlobalVariables.getUserSession().getPrincipalId(), additionalPermissionDetails, null)) {
            rulePassed = false;
        }
        return rulePassed;
    }

    protected boolean validRoleMemberPrincipalIDs(List<KimDocumentRoleMember> roleMembers) {
        boolean valid = true;
        ArrayList<String> principalIds = new ArrayList<String>();
        for (KimDocumentRoleMember roleMember : roleMembers) {
            if (!StringUtils.equals((String)roleMember.getMemberTypeCode(), (String)KimConstants.KimGroupMemberTypes.PRINCIPAL_MEMBER_TYPE.getCode())) continue;
            principalIds.add(roleMember.getMemberId());
        }
        if (!principalIds.isEmpty()) {
            List validPrincipals = this.getIdentityService().getPrincipals(principalIds);
            for (KimDocumentRoleMember roleMember : roleMembers) {
                if (!StringUtils.equals((String)roleMember.getMemberTypeCode(), (String)MemberType.PRINCIPAL.getCode())) continue;
                boolean validPrincipalId = false;
                if (validPrincipals != null && !validPrincipals.isEmpty()) {
                    for (Principal validPrincipal : validPrincipals) {
                        if (!roleMember.getMemberId().equals(validPrincipal.getPrincipalId())) continue;
                        validPrincipalId = true;
                    }
                }
                if (validPrincipalId) continue;
                GlobalVariables.getMessageMap().putError("document.member.memberId", "error.memberid.membertype.mismatch", new String[]{roleMember.getMemberId()});
                valid = false;
            }
        }
        return valid;
    }

    protected boolean validDuplicateRoleName(IdentityManagementRoleDocument roleDoc) {
        Role role = KimApiServiceLocator.getRoleService().getRoleByNamespaceCodeAndName(roleDoc.getRoleNamespace(), roleDoc.getRoleName());
        boolean rulePassed = true;
        if (role != null) {
            if (role.getId().equals(roleDoc.getRoleId())) {
                rulePassed = true;
            } else {
                GlobalVariables.getMessageMap().putError("document.roleName", "error.duplicate.entry", new String[]{"Role Name"});
                rulePassed = false;
            }
        }
        return rulePassed;
    }

    protected boolean validRoleMemberActiveDates(List<KimDocumentRoleMember> roleMembers) {
        boolean valid = true;
        int i = 0;
        for (KimDocumentRoleMember roleMember : roleMembers) {
            valid &= this.validateActiveDate("document.members[" + i + "].activeToDate", roleMember.getActiveFromDate(), roleMember.getActiveToDate());
            ++i;
        }
        return valid;
    }

    protected boolean validDelegationMemberActiveDates(List<RoleDocumentDelegationMember> delegationMembers) {
        boolean valid = true;
        int i = 0;
        for (RoleDocumentDelegationMember delegationMember : delegationMembers) {
            valid &= this.validateActiveDate("document.delegationMembers[" + i + "].activeToDate", delegationMember.getActiveFromDate(), delegationMember.getActiveToDate());
            ++i;
        }
        return valid;
    }

    protected boolean validPermissions(IdentityManagementRoleDocument document) {
        boolean valid = true;
        int i = 0;
        for (KimDocumentRolePermission permission : document.getPermissions()) {
            Permission kimPermissionInfo = permission.getPermission();
            if (!permission.isActive() && !this.hasPermissionToGrantPermission(permission.getPermission(), document)) {
                GlobalVariables.getMessageMap().putError("permissions[" + i + "].active", "error.assign.perimssion", new String[]{kimPermissionInfo.getNamespaceCode(), kimPermissionInfo.getTemplate().getName()});
                valid = false;
            }
            ++i;
        }
        return valid;
    }

    protected boolean validResponsibilities(IdentityManagementRoleDocument document) {
        boolean valid = true;
        int i = 0;
        for (KimDocumentRoleResponsibility responsibility : document.getResponsibilities()) {
            ResponsibilityBo kimResponsibilityImpl = responsibility.getKimResponsibility();
            if (!responsibility.isActive() && !this.hasPermissionToGrantResponsibility(ResponsibilityBo.to((ResponsibilityContract)responsibility.getKimResponsibility()), document)) {
                GlobalVariables.getMessageMap().putError("responsibilities[" + i + "].active", "error.assign.responsibility", new String[]{kimResponsibilityImpl.getNamespaceCode(), kimResponsibilityImpl.getTemplate().getName()});
                valid = false;
            }
            ++i;
        }
        return valid;
    }

    protected boolean validRoleResponsibilitiesActions(List<KimDocumentRoleResponsibility> roleResponsibilities) {
        int i = 0;
        boolean rulePassed = true;
        for (KimDocumentRoleResponsibility roleResponsibility : roleResponsibilities) {
            if (!this.getResponsibilityInternalService().areActionsAtAssignmentLevelById(roleResponsibility.getResponsibilityId())) {
                this.validateRoleResponsibilityAction("document.responsibilities[" + i + "].roleRspActions[0].priorityNumber", roleResponsibility.getRoleRspActions().get(0));
            }
            ++i;
        }
        return rulePassed;
    }

    protected boolean validRoleMembersResponsibilityActions(List<KimDocumentRoleMember> roleMembers) {
        int i = 0;
        boolean rulePassed = true;
        for (KimDocumentRoleMember roleMember : roleMembers) {
            int j = 0;
            if (roleMember.getRoleRspActions() != null && !roleMember.getRoleRspActions().isEmpty()) {
                for (KimDocumentRoleResponsibilityAction roleRspAction : roleMember.getRoleRspActions()) {
                    this.validateRoleResponsibilityAction("document.members[" + i + "].roleRspActions[" + j + "].priorityNumber", roleRspAction);
                    ++j;
                }
            }
            ++i;
        }
        return rulePassed;
    }

    protected boolean validateRoleResponsibilityAction(String errorPath, KimDocumentRoleResponsibilityAction roleRspAction) {
        boolean rulePassed = true;
        if (roleRspAction.getPriorityNumber() != null && (roleRspAction.getPriorityNumber() < 1 || roleRspAction.getPriorityNumber() > 11)) {
            GlobalVariables.getMessageMap().putError(errorPath, "error.prioritynumber.range", new String[]{"1", "11"});
            rulePassed = false;
        }
        return rulePassed;
    }

    protected boolean validateRoleQualifier(List<KimDocumentRoleMember> roleMembers, KimType kimType) {
        ArrayList<RemotableAttributeError> validationErrors = new ArrayList<RemotableAttributeError>();
        int memberCounter = 0;
        int roleMemberCount = 0;
        KimTypeService kimTypeService = KimFrameworkServiceLocator.getKimTypeService((KimType)kimType);
        GlobalVariables.getMessageMap().removeFromErrorPath("document");
        List attributeDefinitions = kimTypeService.getAttributeDefinitions(kimType.getId());
        Set<String> uniqueAttributeNames = this.figureOutUniqueQualificationSet(roleMembers, attributeDefinitions);
        for (KimDocumentRoleMember roleMember : roleMembers) {
            List errorsTemp = Collections.emptyList();
            Map<String, String> mapToValidate = this.attributeValidationHelper.convertQualifiersToMap(roleMember.getQualifiers());
            VersionedService<RoleTypeService> versionedRoleTypeService = this.getVersionedRoleTypeService(kimType);
            boolean shouldNotValidate = true;
            if (versionedRoleTypeService != null) {
                boolean versionOk = VersionHelper.compareVersion((String)versionedRoleTypeService.getVersion(), (String)"2.1.2") != -1;
                shouldNotValidate = versionOk ? versionedRoleTypeService.getService().shouldValidateQualifiersForMemberType(MemberType.fromCode((String)roleMember.getMemberTypeCode())) : false;
            }
            if (!shouldNotValidate) {
                errorsTemp = kimTypeService.validateAttributes(kimType.getId(), mapToValidate);
                validationErrors.addAll(this.attributeValidationHelper.convertErrorsForMappedFields("members[" + memberCounter + "]", errorsTemp));
                ++memberCounter;
            }
            if (uniqueAttributeNames.size() > 0) {
                this.validateUniquePersonRoleQualifiersUniqueForRoleMembership(roleMember, roleMemberCount, roleMembers, uniqueAttributeNames, validationErrors);
            }
            ++roleMemberCount;
        }
        GlobalVariables.getMessageMap().addToErrorPath("document");
        if (validationErrors.isEmpty()) {
            return true;
        }
        this.attributeValidationHelper.moveValidationErrorsToErrorMap(validationErrors);
        return false;
    }

    protected Set<String> figureOutUniqueQualificationSet(List<KimDocumentRoleMember> memberships, List<KimAttributeField> attributeDefinitions) {
        HashSet<String> uniqueAttributeIds = new HashSet<String>();
        if (memberships != null && memberships.size() > 1) {
            KimDocumentRoleMember membership = memberships.get(0);
            for (KimDocumentRoleQualifier qualifier : membership.getQualifiers()) {
                KimAttributeField relatedDefinition;
                if (qualifier == null || qualifier.getKimAttribute() == null || StringUtils.isBlank((String)qualifier.getKimAttribute().getAttributeName()) || (relatedDefinition = DataDictionaryTypeServiceHelper.findAttributeField((String)qualifier.getKimAttribute().getAttributeName(), attributeDefinitions)) == null || !relatedDefinition.isUnique()) continue;
                uniqueAttributeIds.add(qualifier.getKimAttrDefnId());
            }
        }
        return uniqueAttributeIds;
    }

    protected boolean validateUniquePersonRoleQualifiersUniqueForRoleMembership(KimDocumentRoleMember membershipToCheck, int membershipToCheckIndex, List<KimDocumentRoleMember> memberships, Set<String> uniqueQualifierIds, List<RemotableAttributeError> validationErrors) {
        boolean foundError = false;
        int count = 0;
        for (KimDocumentRoleMember membership : memberships) {
            if (membershipToCheckIndex != count && this.sameMembership(membershipToCheck, membership) && this.sameUniqueMembershipQualifications(membershipToCheck, membership, uniqueQualifierIds)) {
                foundError = true;
                int qualifierCount = 0;
                for (KimDocumentRoleQualifier qualifier : membership.getQualifiers()) {
                    if (qualifier != null && uniqueQualifierIds.contains(qualifier.getKimAttrDefnId())) {
                        KimAttributeBo attr = qualifier.getKimAttribute();
                        String attrName = "<unknown>";
                        if (attr == null && qualifier.getKimAttrDefnId() != null) {
                            attr = (KimAttributeBo)KradDataServiceLocator.getDataObjectService().find(KimAttributeBo.class, (Object)qualifier.getKimAttrDefnId());
                        }
                        if (attr != null) {
                            attrName = attr.getAttributeName();
                        }
                        validationErrors.add(RemotableAttributeError.Builder.create((String)("document.members[" + membershipToCheckIndex + "].qualifiers[" + qualifierCount + "].attrVal"), (String[])new String[]{"error.document.identityManagementPerson.qualifier.valueNotUnique:" + membership.getMemberId() + ";" + attrName + ";" + qualifier.getAttrVal()}).build());
                    }
                    ++qualifierCount;
                }
            }
            ++count;
        }
        return foundError;
    }

    protected boolean sameMembership(KimDocumentRoleMember membershipA, KimDocumentRoleMember membershipB) {
        if (!(StringUtils.isBlank((String)membershipA.getMemberTypeCode()) || StringUtils.isBlank((String)membershipB.getMemberTypeCode()) || StringUtils.isBlank((String)membershipA.getMemberId()) || StringUtils.isBlank((String)membershipB.getMemberId()))) {
            return membershipA.getMemberTypeCode().equals(membershipB.getMemberTypeCode()) && membershipA.getMemberId().equals(membershipB.getMemberId());
        }
        return false;
    }

    protected boolean sameUniqueMembershipQualifications(KimDocumentRoleMember membershipA, KimDocumentRoleMember membershipB, Set<String> uniqueAttributeIds) {
        boolean equalSoFar = true;
        for (String kimAttributeDefinitionId : uniqueAttributeIds) {
            KimDocumentRoleQualifier qualifierA = membershipA.getQualifier(kimAttributeDefinitionId);
            KimDocumentRoleQualifier qualifierB = membershipB.getQualifier(kimAttributeDefinitionId);
            if (qualifierA == null || qualifierB == null) continue;
            equalSoFar &= qualifierA.getAttrVal() == null && qualifierB.getAttrVal() == null || qualifierA.getAttrVal() == null || qualifierA.getAttrVal().equals(qualifierB.getAttrVal());
        }
        return equalSoFar;
    }

    protected KimDocumentRoleMember getRoleMemberForDelegation(List<KimDocumentRoleMember> roleMembers, RoleDocumentDelegationMember delegationMember, List<KimDocumentRoleMember> modifiedRoleMembers) {
        if (roleMembers == null && modifiedRoleMembers == null || delegationMember == null || delegationMember.getRoleMemberId() == null) {
            return null;
        }
        for (KimDocumentRoleMember roleMember : modifiedRoleMembers) {
            if (!delegationMember.getRoleMemberId().equals(roleMember.getRoleMemberId())) continue;
            return roleMember;
        }
        for (KimDocumentRoleMember roleMember : roleMembers) {
            if (!delegationMember.getRoleMemberId().equals(roleMember.getRoleMemberId())) continue;
            return roleMember;
        }
        return null;
    }

    protected boolean validateDelegationMemberRoleQualifier(List<KimDocumentRoleMember> modifiedRoleMembers, List<RoleDocumentDelegationMember> delegationMembers, KimType kimType, List<KimDocumentRoleMember> nonModifiedRoleMembers) {
        boolean valid;
        ArrayList<RemotableAttributeError> validationErrors = new ArrayList<RemotableAttributeError>();
        int memberCounter = 0;
        KimTypeService kimTypeService = KimFrameworkServiceLocator.getKimTypeService((KimType)kimType);
        GlobalVariables.getMessageMap().removeFromErrorPath("document");
        List attributeDefinitions = kimTypeService.getAttributeDefinitions(kimType.getId());
        Set<String> uniqueQualifierAttributes = this.figureOutUniqueQualificationSetForDelegation(delegationMembers, attributeDefinitions);
        for (RoleDocumentDelegationMember delegationMember : delegationMembers) {
            KimDocumentRoleMember roleMember;
            List errorsTemp;
            String errorPath = "delegationMembers[" + memberCounter + "]";
            Map<String, String> mapToValidate = this.attributeValidationHelper.convertQualifiersToMap(delegationMember.getQualifiers());
            if (!delegationMember.isRole()) {
                errorsTemp = kimTypeService.validateAttributes(kimType.getId(), mapToValidate);
                validationErrors.addAll(this.attributeValidationHelper.convertErrorsForMappedFields(errorPath, errorsTemp));
            }
            if ((roleMember = this.getRoleMemberForDelegation(nonModifiedRoleMembers, delegationMember, modifiedRoleMembers)) == null) {
                valid = false;
                GlobalVariables.getMessageMap().putError("document.delegationMembers[" + memberCounter + "]", "error.delegation.notassociatedwith.rolemember", new String[0]);
            } else {
                errorsTemp = kimTypeService.validateUnmodifiableAttributes(kimType.getId(), this.attributeValidationHelper.convertQualifiersToMap(roleMember.getQualifiers()), mapToValidate);
                validationErrors.addAll(this.attributeValidationHelper.convertErrorsForMappedFields(errorPath, errorsTemp));
            }
            if (uniqueQualifierAttributes.size() > 0) {
                this.validateUniquePersonRoleQualifiersUniqueForRoleDelegation(delegationMember, memberCounter, delegationMembers, uniqueQualifierAttributes, validationErrors);
            }
            ++memberCounter;
        }
        GlobalVariables.getMessageMap().addToErrorPath("document");
        if (validationErrors.isEmpty()) {
            valid = true;
        } else {
            this.attributeValidationHelper.moveValidationErrorsToErrorMap(validationErrors);
            valid = false;
        }
        return valid;
    }

    protected Set<String> figureOutUniqueQualificationSetForDelegation(List<RoleDocumentDelegationMember> memberships, List<KimAttributeField> attributeDefinitions) {
        HashSet<String> uniqueAttributeIds = new HashSet<String>();
        if (memberships != null && memberships.size() > 1) {
            RoleDocumentDelegationMember membership = memberships.get(0);
            for (RoleDocumentDelegationMemberQualifier qualifier : membership.getQualifiers()) {
                KimAttributeField relatedDefinition;
                if (qualifier == null || qualifier.getKimAttribute() == null || StringUtils.isBlank((String)qualifier.getKimAttribute().getAttributeName()) || !(relatedDefinition = DataDictionaryTypeServiceHelper.findAttributeField((String)qualifier.getKimAttribute().getAttributeName(), attributeDefinitions)).isUnique()) continue;
                uniqueAttributeIds.add(qualifier.getKimAttrDefnId());
            }
        }
        return uniqueAttributeIds;
    }

    protected boolean validateUniquePersonRoleQualifiersUniqueForRoleDelegation(RoleDocumentDelegationMember delegationMembershipToCheck, int membershipToCheckIndex, List<RoleDocumentDelegationMember> delegationMemberships, Set<String> uniqueQualifierIds, List<RemotableAttributeError> validationErrors) {
        boolean foundError = false;
        int count = 0;
        for (RoleDocumentDelegationMember delegationMembership : delegationMemberships) {
            if (membershipToCheckIndex != count && this.sameDelegationMembership(delegationMembershipToCheck, delegationMembership) && this.sameUniqueDelegationMembershipQualifications(delegationMembershipToCheck, delegationMembership, uniqueQualifierIds)) {
                foundError = true;
                int qualifierCount = 0;
                for (RoleDocumentDelegationMemberQualifier qualifier : delegationMembership.getQualifiers()) {
                    if (qualifier != null && uniqueQualifierIds.contains(qualifier.getKimAttrDefnId())) {
                        validationErrors.add(RemotableAttributeError.Builder.create((String)("document.delegationMembers[" + membershipToCheckIndex + "].qualifiers[" + qualifierCount + "].attrVal"), (String[])new String[]{"error.document.identityManagementPerson.qualifier.valueNotUnique:" + qualifier.getKimAttribute().getAttributeName() + ";" + qualifier.getAttrVal()}).build());
                    }
                    ++qualifierCount;
                }
            }
            ++count;
        }
        return foundError;
    }

    protected boolean sameDelegationMembership(RoleDocumentDelegationMember membershipA, RoleDocumentDelegationMember membershipB) {
        if (!(StringUtils.isBlank((String)membershipA.getMemberTypeCode()) || StringUtils.isBlank((String)membershipB.getMemberTypeCode()) || StringUtils.isBlank((String)membershipA.getMemberId()) || StringUtils.isBlank((String)membershipB.getMemberId()))) {
            return membershipA.getMemberTypeCode().equals(membershipB.getMemberTypeCode()) && membershipA.getMemberId().equals(membershipB.getMemberId());
        }
        return false;
    }

    protected boolean sameUniqueDelegationMembershipQualifications(RoleDocumentDelegationMember membershipA, RoleDocumentDelegationMember membershipB, Set<String> uniqueAttributeIds) {
        boolean equalSoFar = true;
        for (String kimAttributeDefinitionId : uniqueAttributeIds) {
            RoleDocumentDelegationMemberQualifier qualifierA = membershipA.getQualifier(kimAttributeDefinitionId);
            RoleDocumentDelegationMemberQualifier qualifierB = membershipB.getQualifier(kimAttributeDefinitionId);
            if (qualifierA == null || qualifierB == null) continue;
            equalSoFar &= qualifierA.getAttrVal() == null && qualifierB.getAttrVal() == null || qualifierA.getAttrVal() == null || qualifierA.getAttrVal().equals(qualifierB.getAttrVal());
        }
        return equalSoFar;
    }

    protected boolean validateActiveDate(String errorPath, Timestamp activeFromDate, Timestamp activeToDate) {
        boolean valid = true;
        if (activeFromDate != null && activeToDate != null && activeToDate.before(activeFromDate)) {
            MessageMap errorMap = GlobalVariables.getMessageMap();
            errorMap.putError(errorPath, "error.active.todate.before.fromdate", new String[0]);
            valid = false;
        }
        return valid;
    }

    protected boolean checkForCircularRoleMembership(AddMemberEvent addMemberEvent) {
        IdentityManagementRoleDocument document;
        RoleService roleService;
        KimDocumentRoleMember newMember = addMemberEvent.getMember();
        if (newMember == null || StringUtils.isBlank((String)newMember.getMemberId())) {
            MessageMap errorMap = GlobalVariables.getMessageMap();
            errorMap.putError("member.memberId", "error.invalid.role", new String[]{""});
            return false;
        }
        Set roleMemberIds = null;
        if (newMember.isRole() && (roleMemberIds = (roleService = KimApiServiceLocator.getRoleService()).getRoleTypeRoleMemberIds(newMember.getMemberId())).contains((document = (IdentityManagementRoleDocument)addMemberEvent.getDocument()).getRoleId())) {
            MessageMap errorMap = GlobalVariables.getMessageMap();
            errorMap.putError("member.memberId", "error.assign.role.member.circular", new String[]{newMember.getMemberId()});
            return false;
        }
        return true;
    }

    public AddResponsibilityRule getAddResponsibilityRule() {
        if (this.addResponsibilityRule == null) {
            try {
                this.addResponsibilityRule = this.addResponsibilityRuleClass.newInstance();
            }
            catch (Exception ex) {
                throw new RuntimeException("Unable to create AddResponsibilityRule instance using class: " + String.valueOf(this.addResponsibilityRuleClass), ex);
            }
        }
        return this.addResponsibilityRule;
    }

    public AddPermissionRule getAddPermissionRule() {
        if (this.addPermissionRule == null) {
            try {
                this.addPermissionRule = this.addPermissionRuleClass.newInstance();
            }
            catch (Exception ex) {
                throw new RuntimeException("Unable to create AddPermissionRule instance using class: " + String.valueOf(this.addPermissionRuleClass), ex);
            }
        }
        return this.addPermissionRule;
    }

    public AddMemberRule getAddMemberRule() {
        if (this.addMemberRule == null) {
            try {
                this.addMemberRule = this.addMemberRuleClass.newInstance();
            }
            catch (Exception ex) {
                throw new RuntimeException("Unable to create AddMemberRule instance using class: " + String.valueOf(this.addMemberRuleClass), ex);
            }
        }
        return this.addMemberRule;
    }

    public AddDelegationRule getAddDelegationRule() {
        if (this.addDelegationRule == null) {
            try {
                this.addDelegationRule = this.addDelegationRuleClass.newInstance();
            }
            catch (Exception ex) {
                throw new RuntimeException("Unable to create AddDelegationRule instance using class: " + String.valueOf(this.addDelegationRuleClass), ex);
            }
        }
        return this.addDelegationRule;
    }

    public AddDelegationMemberRule getAddDelegationMemberRule() {
        if (this.addDelegationMemberRule == null) {
            try {
                this.addDelegationMemberRule = this.addDelegationMemberRuleClass.newInstance();
            }
            catch (Exception ex) {
                throw new RuntimeException("Unable to create AddDelegationMemberRule instance using class: " + String.valueOf(this.addDelegationMemberRuleClass), ex);
            }
        }
        return this.addDelegationMemberRule;
    }

    @Override
    public boolean processAddPermission(AddPermissionEvent addPermissionEvent) {
        return this.getAddPermissionRule().processAddPermission(addPermissionEvent);
    }

    @Override
    public boolean hasPermissionToGrantPermission(Permission kimPermissionInfo, IdentityManagementRoleDocument document) {
        return this.getAddPermissionRule().hasPermissionToGrantPermission(kimPermissionInfo, document);
    }

    @Override
    public boolean processAddResponsibility(AddResponsibilityEvent addResponsibilityEvent) {
        return this.getAddResponsibilityRule().processAddResponsibility(addResponsibilityEvent);
    }

    @Override
    public boolean hasPermissionToGrantResponsibility(Responsibility kimResponsibilityInfo, IdentityManagementRoleDocument document) {
        return this.getAddResponsibilityRule().hasPermissionToGrantResponsibility(kimResponsibilityInfo, document);
    }

    @Override
    public boolean processAddMember(AddMemberEvent addMemberEvent) {
        boolean success = new KimDocumentMemberRule().processAddMember(addMemberEvent);
        success &= this.validateActiveDate("member.activeFromDate", addMemberEvent.getMember().getActiveFromDate(), addMemberEvent.getMember().getActiveToDate());
        return success &= this.checkForCircularRoleMembership(addMemberEvent);
    }

    @Override
    public boolean processAddDelegation(AddDelegationEvent addDelegationEvent) {
        return this.getAddDelegationRule().processAddDelegation(addDelegationEvent);
    }

    @Override
    public boolean processAddDelegationMember(AddDelegationMemberEvent addDelegationMemberEvent) {
        boolean success = new RoleDocumentDelegationMemberRule().processAddDelegationMember(addDelegationMemberEvent);
        RoleDocumentDelegationMember roleDocumentDelegationMember = addDelegationMemberEvent.getDelegationMember();
        return success &= this.validateActiveDate("delegationMember.activeFromDate", roleDocumentDelegationMember.getActiveFromDate(), roleDocumentDelegationMember.getActiveToDate());
    }

    public ResponsibilityInternalService getResponsibilityInternalService() {
        if (responsibilityInternalService == null) {
            responsibilityInternalService = KimImplServiceLocator.getResponsibilityInternalService();
        }
        return responsibilityInternalService;
    }

    protected RoleTypeService getRoleTypeService(KimType typeInfo) {
        String serviceName = typeInfo.getServiceName();
        if (serviceName != null) {
            try {
                KimTypeService service = (KimTypeService)GlobalResourceLoader.getService((QName)QName.valueOf(serviceName));
                if (service != null && service instanceof RoleTypeService) {
                    return (RoleTypeService)service;
                }
                return (RoleTypeService)KimImplServiceLocator.getService((String)"kimNoMembersRoleTypeService");
            }
            catch (Exception ex) {
                return (RoleTypeService)KimImplServiceLocator.getService((String)"kimNoMembersRoleTypeService");
            }
        }
        return null;
    }

    protected VersionedService<RoleTypeService> getVersionedRoleTypeService(KimType typeInfo) {
        String serviceName = typeInfo.getServiceName();
        if (serviceName != null) {
            String version = "2.0.0";
            RoleTypeService roleTypeService = null;
            try {
                KimTypeService service;
                ServiceBus serviceBus = KsbApiServiceLocator.getServiceBus();
                Endpoint endpoint = serviceBus.getEndpoint(QName.valueOf(serviceName));
                if (endpoint != null) {
                    version = endpoint.getServiceConfiguration().getServiceVersion();
                }
                roleTypeService = (service = (KimTypeService)GlobalResourceLoader.getService((QName)QName.valueOf(serviceName))) != null && service instanceof RoleTypeService ? (RoleTypeService)service : (RoleTypeService)KimImplServiceLocator.getService((String)"kimNoMembersRoleTypeService");
            }
            catch (Exception ex) {
                roleTypeService = (RoleTypeService)KimImplServiceLocator.getService((String)"kimNoMembersRoleTypeService");
            }
            return new VersionedService<RoleTypeService>(version, roleTypeService);
        }
        return null;
    }

    private static class VersionedService<T> {
        String version;
        T service;

        VersionedService(String version, T service) {
            this.version = version;
            this.service = service;
        }

        T getService() {
            return this.service;
        }

        String getVersion() {
            return this.version;
        }
    }
}

