/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.actions;

import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.ThreadContext;
import org.kuali.rice.kew.actionrequest.ActionRequestFactory;
import org.kuali.rice.kew.actionrequest.ActionRequestValue;
import org.kuali.rice.kew.actionrequest.KimPrincipalRecipient;
import org.kuali.rice.kew.actions.SuperUserActionTakenEvent;
import org.kuali.rice.kew.actiontaken.ActionTakenValue;
import org.kuali.rice.kew.api.action.ActionType;
import org.kuali.rice.kew.api.exception.InvalidActionTakenException;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kew.doctype.bo.DocumentType;
import org.kuali.rice.kew.exception.WorkflowServiceErrorException;
import org.kuali.rice.kew.exception.WorkflowServiceErrorImpl;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kim.api.identity.principal.PrincipalContract;

public class SuperUserActionRequestApproveEvent
extends SuperUserActionTakenEvent {
    private static final String UNDEFINED_ACTION_TAKEN_CODE = null;
    private static final Logger LOG = LogManager.getLogger(SuperUserActionRequestApproveEvent.class);
    private String actionRequestId;

    public SuperUserActionRequestApproveEvent(DocumentRouteHeaderValue routeHeader, PrincipalContract principal) {
        super(UNDEFINED_ACTION_TAKEN_CODE, "SU_ACTION_REQUEST_APPROVE", routeHeader, principal);
    }

    public SuperUserActionRequestApproveEvent(DocumentRouteHeaderValue routeHeader, PrincipalContract principal, String actionRequestId, String annotation, boolean runPostProcessor) {
        super(UNDEFINED_ACTION_TAKEN_CODE, "SU_ACTION_REQUEST_APPROVE", routeHeader, principal, annotation, runPostProcessor);
        this.actionRequestId = actionRequestId;
    }

    public void setActionTaken() {
        String actionRequestCode = "";
        ActionRequestValue actionRequest = this.getActionRequestService().findByActionRequestId(this.actionRequestId);
        this.setActionRequest(actionRequest);
        actionRequestCode = actionRequest.getActionRequested();
        ActionType suActionType = ActionType.toSuperUserActionType((ActionType)ActionType.fromCode((String)actionRequestCode, (boolean)true));
        if (suActionType == null) {
            LOG.error("Invalid SU delegation action request code: " + actionRequestCode);
            throw new RuntimeException("Invalid SU delegation action request code: " + actionRequestCode);
        }
        this.setActionTakenCode(suActionType.getCode());
    }

    @Override
    protected ActionTakenValue processActionRequests() throws InvalidActionTakenException {
        DocumentType docType = this.getRouteHeader().getDocumentType();
        String errorMessage = super.validateActionRules();
        if (!StringUtils.isEmpty((String)errorMessage)) {
            LOG.info("User not authorized");
            ArrayList<WorkflowServiceErrorImpl> errors = new ArrayList<WorkflowServiceErrorImpl>();
            errors.add(new WorkflowServiceErrorImpl(errorMessage, SuperUserActionTakenEvent.AUTHORIZATION));
            throw new WorkflowServiceErrorException(errorMessage, errors);
        }
        this.setActionTaken();
        ThreadContext.put((String)"docId", (String)this.getRouteHeader().getDocumentId());
        LOG.debug("Super User Delegation Action on action request: " + this.annotation);
        KimPrincipalRecipient superUserRecipient = null;
        if (this.getActionRequest().getPrincipal() != null) {
            superUserRecipient = new KimPrincipalRecipient((PrincipalContract)this.getActionRequest().getPrincipal());
        }
        ActionTakenValue actionTaken = this.saveActionTaken(superUserRecipient);
        LOG.debug("Deactivate this action request");
        ActionRequestValue request = this.getActionRequest();
        request = this.getActionRequestService().deactivateRequest(actionTaken, request);
        if (docType.getSuperUserApproveNotificationPolicy().getPolicyValue().booleanValue() && request.isApproveOrCompleteRequest()) {
            KEWServiceLocator.getActionRequestService().activateRequest(new ActionRequestFactory(this.getRouteHeader()).createNotificationRequest("K", (PrincipalContract)request.getPrincipal(), this.getActionTakenCode(), this.getPrincipal(), null));
        }
        this.notifyActionTaken(actionTaken);
        if (!"f".equals(this.getActionTakenCode()) || !"k".equals(this.getActionTakenCode())) {
            if (this.getRouteHeader().isInException()) {
                LOG.debug("Moving document back to Enroute from Exception");
                String oldStatus = this.getRouteHeader().getDocRouteStatus();
                this.getRouteHeader().markDocumentEnroute();
                String newStatus = this.getRouteHeader().getDocRouteStatus();
                this.notifyStatusChange(newStatus, oldStatus);
                DocumentRouteHeaderValue routeHeaderValue = KEWServiceLocator.getRouteHeaderService().saveRouteHeader(this.getRouteHeader());
                this.setRouteHeader(routeHeaderValue);
            } else if (this.getRouteHeader().isStateSaved() && "-3".equals(request.getResponsibilityId())) {
                LOG.debug("Moving document to Enroute from Saved because action request was request generated by save action");
                String oldStatus = this.getRouteHeader().getDocRouteStatus();
                this.getRouteHeader().markDocumentEnroute();
                String newStatus = this.getRouteHeader().getDocRouteStatus();
                this.notifyStatusChange(newStatus, oldStatus);
                DocumentRouteHeaderValue routeHeaderValue = KEWServiceLocator.getRouteHeaderService().saveRouteHeader(this.getRouteHeader());
                this.setRouteHeader(routeHeaderValue);
            }
        }
        return actionTaken;
    }

    @Override
    public void recordAction() throws InvalidActionTakenException {
        this.processActionRequests();
        this.queueDocumentProcessing();
    }

    @Override
    protected void markDocument() throws WorkflowException {
    }
}

