/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.impl.document.attribute;

import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.ThreadContext;
import org.joda.time.DateTime;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.WorkflowRuntimeException;
import org.kuali.rice.kew.api.document.Document;
import org.kuali.rice.kew.api.document.DocumentContent;
import org.kuali.rice.kew.api.document.DocumentWithContent;
import org.kuali.rice.kew.api.document.WorkflowDocumentService;
import org.kuali.rice.kew.api.document.attribute.DocumentAttribute;
import org.kuali.rice.kew.api.document.attribute.DocumentAttributeDateTime;
import org.kuali.rice.kew.api.document.attribute.DocumentAttributeDecimal;
import org.kuali.rice.kew.api.document.attribute.DocumentAttributeIndexingQueue;
import org.kuali.rice.kew.api.document.attribute.DocumentAttributeInteger;
import org.kuali.rice.kew.api.document.attribute.DocumentAttributeString;
import org.kuali.rice.kew.docsearch.SearchableAttributeBase;
import org.kuali.rice.kew.docsearch.SearchableAttributeDateTimeValue;
import org.kuali.rice.kew.docsearch.SearchableAttributeFloatValue;
import org.kuali.rice.kew.docsearch.SearchableAttributeLongValue;
import org.kuali.rice.kew.docsearch.SearchableAttributeStringValue;
import org.kuali.rice.kew.docsearch.SearchableAttributeValue;
import org.kuali.rice.kew.doctype.bo.DocumentType;
import org.kuali.rice.kew.framework.document.attribute.SearchableAttribute;
import org.kuali.rice.kew.impl.document.attribute.DocumentAttributeIndexingQueueAsyncCapableImpl;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.ksb.api.messaging.AsyncCapableService;
import org.kuali.rice.ksb.api.messaging.AsyncWrappable;

public class DocumentAttributeIndexingQueueImpl
implements DocumentAttributeIndexingQueue,
AsyncWrappable<DocumentAttributeIndexingQueue> {
    private static Logger LOG = LogManager.getLogger(DocumentAttributeIndexingQueueImpl.class);
    private AsyncCapableService asyncCapableService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void indexDocument(String documentId) {
        if (StringUtils.isBlank((String)documentId)) {
            throw new RiceIllegalArgumentException("documentId was null or blank");
        }
        ThreadContext.put((String)"docId", (String)documentId);
        try {
            long t1 = System.currentTimeMillis();
            LOG.info("Indexing document attributes for document " + documentId);
            Document document = this.getWorkflowDocumentService().getDocument(documentId);
            if (document == null) {
                throw new RiceIllegalArgumentException("Failed to locate document with the given id: " + documentId);
            }
            DocumentContent documentContent = KewApiServiceLocator.getWorkflowDocumentService().getDocumentContent(documentId);
            List<SearchableAttributeValue> attributes = this.buildSearchableAttributeValues(document, documentContent);
            KEWServiceLocator.getRouteHeaderService().updateRouteHeaderSearchValues(documentId, attributes);
            long t2 = System.currentTimeMillis();
            LOG.info("...finished indexing document " + documentId + " for document search, total time = " + (t2 - t1) + " ms.");
        }
        finally {
            ThreadContext.remove((String)"docId");
        }
    }

    private List<SearchableAttributeValue> buildSearchableAttributeValues(Document document, DocumentContent documentContent) {
        ArrayList<SearchableAttributeValue> searchableAttributeValues = new ArrayList<SearchableAttributeValue>();
        DocumentType documentTypeBo = KEWServiceLocator.getDocumentTypeService().findByName(document.getDocumentTypeName());
        for (DocumentType.ExtensionHolder<SearchableAttribute> searchableAttributeHolder : documentTypeBo.loadSearchableAttributes()) {
            DocumentWithContent documentWithContent = DocumentWithContent.create((Document)document, (DocumentContent)documentContent);
            SearchableAttribute searchableAttribute = searchableAttributeHolder.getExtension();
            if (searchableAttribute == null) {
                LOG.warn("Encountered a 'null' SearchableAttribute on " + document.getDocumentTypeName() + " : " + searchableAttributeHolder.getExtensionDefinition().getName());
                continue;
            }
            List documentAttributes = searchableAttribute.extractDocumentAttributes(searchableAttributeHolder.getExtensionDefinition(), documentWithContent);
            if (documentAttributes == null) continue;
            for (DocumentAttribute documentAttribute : documentAttributes) {
                if (documentAttribute == null) {
                    LOG.warn("Encountered a 'null' DocumentAttribute on " + document.getDocumentTypeName() + " from searchable attribute: " + String.valueOf(searchableAttribute));
                    continue;
                }
                SearchableAttributeBase searchableAttributeValue = null;
                if (documentAttribute instanceof DocumentAttributeString) {
                    searchableAttributeValue = new SearchableAttributeStringValue();
                    ((SearchableAttributeStringValue)searchableAttributeValue).setSearchableAttributeValue(((DocumentAttributeString)documentAttribute).getValue());
                } else if (documentAttribute instanceof DocumentAttributeDateTime) {
                    searchableAttributeValue = new SearchableAttributeDateTimeValue();
                    DateTime dateTimeValue = ((DocumentAttributeDateTime)documentAttribute).getValue();
                    Timestamp timestamp = dateTimeValue == null ? null : new Timestamp(dateTimeValue.getMillis());
                    ((SearchableAttributeDateTimeValue)searchableAttributeValue).setSearchableAttributeValue(timestamp);
                } else if (documentAttribute instanceof DocumentAttributeInteger) {
                    searchableAttributeValue = new SearchableAttributeLongValue();
                    BigInteger bigIntegerValue = ((DocumentAttributeInteger)documentAttribute).getValue();
                    Long longValue = bigIntegerValue == null ? null : Long.valueOf(bigIntegerValue.longValue());
                    ((SearchableAttributeLongValue)searchableAttributeValue).setSearchableAttributeValue(longValue);
                } else if (documentAttribute instanceof DocumentAttributeDecimal) {
                    searchableAttributeValue = new SearchableAttributeFloatValue();
                    ((SearchableAttributeFloatValue)searchableAttributeValue).setSearchableAttributeValue(((DocumentAttributeDecimal)documentAttribute).getValue());
                } else {
                    throw new WorkflowRuntimeException("Encountered an invalid instance of DocumentAttribute, was: " + String.valueOf(documentAttribute.getClass()));
                }
                searchableAttributeValue.setSearchableAttributeKey(documentAttribute.getName());
                searchableAttributeValue.setDocumentId(document.getDocumentId());
                searchableAttributeValue.setRouteHeader(null);
                searchableAttributeValues.add(searchableAttributeValue);
            }
        }
        return searchableAttributeValues;
    }

    protected WorkflowDocumentService getWorkflowDocumentService() {
        return KewApiServiceLocator.getWorkflowDocumentService();
    }

    public DocumentAttributeIndexingQueue wrap(QName qname, String applicationId) {
        return new DocumentAttributeIndexingQueueAsyncCapableImpl(this.asyncCapableService, this, qname, applicationId);
    }

    public AsyncCapableService getAsyncCapableService() {
        return this.asyncCapableService;
    }

    public void setAsyncCapableService(AsyncCapableService asyncCapableService) {
        this.asyncCapableService = asyncCapableService;
    }
}

