/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.impl.peopleflow;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlValue;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.config.ConfigurationException;
import org.kuali.rice.core.api.exception.RiceRuntimeException;
import org.kuali.rice.core.api.util.xml.XmlJotter;
import org.kuali.rice.kew.actionrequest.ActionRequestValue;
import org.kuali.rice.kew.api.action.ActionRequestType;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kew.api.peopleflow.PeopleFlowDefinition;
import org.kuali.rice.kew.api.peopleflow.PeopleFlowService;
import org.kuali.rice.kew.engine.RouteContext;
import org.kuali.rice.kew.engine.node.NodeState;
import org.kuali.rice.kew.engine.node.RouteNodeUtils;
import org.kuali.rice.kew.impl.peopleflow.PeopleFlowRequestGenerator;
import org.kuali.rice.kew.routemodule.RouteModule;
import org.kuali.rice.kew.util.ResponsibleParty;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PeopleFlowRouteModule
implements RouteModule {
    private static final String PEOPLE_FLOW_PROPERTY = "peopleFlow";
    public static final String PEOPLE_FLOW_SEQUENCE = "peopleFlowSequence";
    private static final JAXBContext jaxbContext;
    private PeopleFlowService peopleFlowService;
    private PeopleFlowRequestGenerator peopleFlowRequestGenerator;

    @Override
    public List<ActionRequestValue> findActionRequests(RouteContext context) throws Exception {
        List<PeopleFlowConfig> configurations = this.parsePeopleFlowConfiguration(context);
        ArrayList<ActionRequestValue> actionRequests = new ArrayList<ActionRequestValue>();
        for (PeopleFlowConfig configuration : configurations) {
            PeopleFlowDefinition peopleFlow = this.loadPeopleFlow(configuration);
            actionRequests.addAll(this.getPeopleFlowRequestGenerator().generateRequests(context, peopleFlow, configuration.actionRequested));
        }
        return actionRequests;
    }

    @Override
    public boolean isMoreRequestsAvailable(RouteContext context) {
        return false;
    }

    @Override
    public ResponsibleParty resolveResponsibilityId(String responsibilityId) throws WorkflowException {
        return null;
    }

    protected List<PeopleFlowConfig> parsePeopleFlowConfiguration(RouteContext context) {
        ArrayList<PeopleFlowConfig> configs;
        block7: {
            block6: {
                String[] peopleFlowValues;
                configs = new ArrayList<PeopleFlowConfig>();
                NodeState peopleFlowSequenceNodeState = context.getNodeInstance().getNodeState(PEOPLE_FLOW_SEQUENCE);
                if (peopleFlowSequenceNodeState == null) break block6;
                String peopleFlowSequence = peopleFlowSequenceNodeState.getValue();
                if (!StringUtils.isNotBlank((String)peopleFlowSequence)) break block7;
                for (String peopleFlowValue : peopleFlowValues = peopleFlowSequence.split(",")) {
                    String[] peopleFlowProperties = peopleFlowValue.split(":");
                    PeopleFlowConfig config = new PeopleFlowConfig();
                    config.actionRequested = ActionRequestType.fromCode((String)peopleFlowProperties[0]);
                    config.peopleFlowIdentifier = peopleFlowProperties[1];
                    configs.add(config);
                }
                break block7;
            }
            List<Element> peopleFlowElements = RouteNodeUtils.getCustomRouteNodeElements(context.getNodeInstance().getRouteNode(), PEOPLE_FLOW_PROPERTY);
            for (Element peopleFlowElement : peopleFlowElements) {
                try {
                    PeopleFlowConfig config = (PeopleFlowConfig)jaxbContext.createUnmarshaller().unmarshal((Node)peopleFlowElement);
                    if (config.actionRequested == null) {
                        config.actionRequested = ActionRequestType.APPROVE;
                    }
                    if (config == null) {
                        throw new IllegalStateException("People flow configuration element did not properly unmarshall from XML: " + XmlJotter.jotNode((Node)peopleFlowElement));
                    }
                    configs.add(config);
                }
                catch (JAXBException e) {
                    throw new RiceRuntimeException("Failed to unmarshall people flow configuration from route node.", (Throwable)e);
                }
            }
        }
        return configs;
    }

    protected PeopleFlowDefinition loadPeopleFlow(PeopleFlowConfig configuration) {
        if (configuration.isId()) {
            PeopleFlowDefinition peopleFlow = this.getPeopleFlowService().getPeopleFlow(configuration.getId());
            if (peopleFlow == null) {
                throw new ConfigurationException("Failed to locate a people flow with the given id of '" + configuration.getId() + "'");
            }
            return peopleFlow;
        }
        String namespaceCode = configuration.getName().namespaceCode;
        String name = configuration.getName().name;
        PeopleFlowDefinition peopleFlow = this.getPeopleFlowService().getPeopleFlowByName(namespaceCode, name);
        if (peopleFlow == null) {
            throw new ConfigurationException("Failed to locate a people flow with the given namespaceCode of '" + namespaceCode + "' and name of '" + name + "'");
        }
        return peopleFlow;
    }

    public PeopleFlowService getPeopleFlowService() {
        return this.peopleFlowService;
    }

    public void setPeopleFlowService(PeopleFlowService peopleFlowService) {
        this.peopleFlowService = peopleFlowService;
    }

    public PeopleFlowRequestGenerator getPeopleFlowRequestGenerator() {
        return this.peopleFlowRequestGenerator;
    }

    public void setPeopleFlowRequestGenerator(PeopleFlowRequestGenerator peopleFlowRequestGenerator) {
        this.peopleFlowRequestGenerator = peopleFlowRequestGenerator;
    }

    static {
        try {
            jaxbContext = JAXBContext.newInstance((Class[])new Class[]{PeopleFlowConfig.class});
        }
        catch (JAXBException e) {
            throw new RiceRuntimeException("Failed to initialize JAXB!", (Throwable)e);
        }
    }

    @XmlRootElement(name="peopleFlow")
    private static class PeopleFlowConfig {
        @XmlElement(name="actionRequested")
        ActionRequestType actionRequested;
        @XmlElements(value={@XmlElement(name="name", type=NameConfig.class), @XmlElement(name="id", type=String.class)})
        Object peopleFlowIdentifier;

        private PeopleFlowConfig() {
        }

        boolean isId() {
            return this.peopleFlowIdentifier instanceof String;
        }

        boolean isName() {
            return this.peopleFlowIdentifier instanceof NameConfig;
        }

        NameConfig getName() {
            return (NameConfig)this.peopleFlowIdentifier;
        }

        String getId() {
            return (String)this.peopleFlowIdentifier;
        }
    }

    private static class NameConfig {
        @XmlAttribute(name="namespace")
        String namespaceCode;
        @XmlValue
        String name;

        private NameConfig() {
        }
    }
}

