/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.validation;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.kew.api.WorkflowRuntimeException;
import org.kuali.rice.kew.api.validation.RuleValidationContext;
import org.kuali.rice.kew.api.validation.ValidationResults;
import org.kuali.rice.kew.framework.KewFrameworkServiceLocator;
import org.kuali.rice.kew.framework.validation.RuleValidationAttributeExporterService;
import org.kuali.rice.kew.rule.RuleValidationAttribute;
import org.kuali.rice.kew.validation.RuleValidationAttributeResolver;

public class RuleValidationAttributeResolverImpl
implements RuleValidationAttributeResolver {
    @Override
    public RuleValidationAttribute resolveRuleValidationAttribute(final String attributeName, String applicationId) throws Exception {
        final RuleValidationAttributeExporterService service = this.findRuleValidationAttributeExporterService(applicationId);
        return (RuleValidationAttribute)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{RuleValidationAttribute.class}, (InvocationHandler)new RuleValidationAttributeInvocationHandler(this){

            @Override
            protected ValidationResults invokeValidate(RuleValidationContext context) throws Exception {
                return service.validate(attributeName, context);
            }
        });
    }

    protected RuleValidationAttributeExporterService findRuleValidationAttributeExporterService(String applicationId) {
        RuleValidationAttributeExporterService service = KewFrameworkServiceLocator.getRuleValidationAttributeExporterService((String)applicationId);
        if (service == null) {
            throw new WorkflowRuntimeException("Failed to locate RuleValidationAttributeExporterService for applicationId: " + applicationId);
        }
        return service;
    }

    protected static abstract class RuleValidationAttributeInvocationHandler
    implements InvocationHandler {
        protected RuleValidationAttributeInvocationHandler() {
        }

        public ValidationResults invoke(Object o, Method method, Object[] objects) throws Throwable {
            if (!StringUtils.equals((String)method.getName(), (String)"validate")) {
                throw new UnsupportedOperationException("RuleValidationAttribute only supports 'validate'");
            }
            return this.invokeValidate((RuleValidationContext)objects[0]);
        }

        protected abstract ValidationResults invokeValidate(RuleValidationContext var1) throws Exception;
    }
}

