/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.lookup;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.criteria.PredicateFactory;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.kim.api.group.Group;
import org.kuali.rice.kim.api.group.GroupQueryResults;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kim.impl.role.RoleBo;
import org.kuali.rice.kim.impl.role.RoleMemberBo;
import org.kuali.rice.kim.lookup.KimLookupableHelperServiceImpl;
import org.kuali.rice.kns.web.ui.Field;
import org.kuali.rice.kns.web.ui.Row;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.lookup.CollectionIncomplete;

public abstract class RoleMemberLookupableHelperServiceImpl
extends KimLookupableHelperServiceImpl {
    protected static final String DETAIL_CRITERIA = "detailCriteria";
    protected static final String WILDCARD = "*";
    protected static final String TEMPLATE_NAMESPACE_CODE = "template.namespaceCode";
    protected static final String TEMPLATE_NAME = "template.name";
    protected static final String TEMPLATE_ID = "template.id";
    protected static final String NAMESPACE_CODE = "namespaceCode";
    protected static final String NAME = "name";
    protected static final String GROUP_NAME = "name";
    protected static final String ASSIGNED_TO_PRINCIPAL_NAME = "assignedToPrincipal.principalName";
    protected static final String ASSIGNED_TO_GROUP_NAMESPACE_CODE = "assignedToGroupNamespaceForLookup";
    protected static final String ASSIGNED_TO_GROUP_NAME = "assignedToGroup.name";
    protected static final String ASSIGNED_TO_NAMESPACE_FOR_LOOKUP = "assignedToRoleNamespaceForLookup";
    protected static final String ASSIGNED_TO_ROLE_NAME = "assignedToRole.name";
    protected static final String ATTRIBUTE_NAME = "attributeName";
    protected static final String ATTRIBUTE_VALUE = "attributeValue";
    protected static final String ASSIGNED_TO_ROLE_NAMESPACE_CODE = "namespaceCode";
    protected static final String ASSIGNED_TO_ROLE_ROLE_NAME = "name";
    protected static final String ASSIGNED_TO_ROLE_MEMBER_ID = "members.memberId";
    protected static final String DETAIL_OBJECTS_ATTRIBUTE_VALUE = "attributeDetails.attributeValue";
    protected static final String DETAIL_OBJECTS_ATTRIBUTE_NAME = "attributeDetails.kimAttribute.attributeName";

    protected List<? extends BusinessObject> getSearchResultsHelper(Map<String, String> fieldValues, boolean unbounded) {
        Map<String, String> searchCriteria = this.buildRoleSearchCriteria(fieldValues);
        if (searchCriteria == null) {
            return new ArrayList();
        }
        return this.getMemberSearchResults(fieldValues, unbounded);
    }

    protected abstract List<? extends BusinessObject> getMemberSearchResults(Map<String, String> var1, boolean var2);

    protected Map<String, String> buildSearchCriteria(Map<String, String> fieldValues) {
        String templateNamespaceCode = fieldValues.get(TEMPLATE_NAMESPACE_CODE);
        String templateName = fieldValues.get(TEMPLATE_NAME);
        String templateId = fieldValues.get(TEMPLATE_ID);
        String namespaceCode = fieldValues.get("namespaceCode");
        String name = fieldValues.get("name");
        String attributeDetailValue = fieldValues.get(ATTRIBUTE_VALUE);
        String attributeDetailName = fieldValues.get(ATTRIBUTE_NAME);
        String detailCriteria = fieldValues.get(DETAIL_CRITERIA);
        String active = fieldValues.get("active");
        HashMap<String, String> searchCriteria = new HashMap<String, String>();
        if (StringUtils.isNotEmpty((String)templateNamespaceCode)) {
            searchCriteria.put(TEMPLATE_NAMESPACE_CODE, WILDCARD + templateNamespaceCode + WILDCARD);
        }
        if (StringUtils.isNotEmpty((String)templateName)) {
            searchCriteria.put(TEMPLATE_NAME, WILDCARD + templateName + WILDCARD);
        }
        if (StringUtils.isNotEmpty((String)templateId)) {
            searchCriteria.put(TEMPLATE_ID, templateId);
        }
        if (StringUtils.isNotEmpty((String)namespaceCode)) {
            searchCriteria.put("namespaceCode", WILDCARD + namespaceCode + WILDCARD);
        }
        if (StringUtils.isNotEmpty((String)name)) {
            searchCriteria.put("name", WILDCARD + name + WILDCARD);
        }
        if (StringUtils.isNotEmpty((String)attributeDetailValue)) {
            searchCriteria.put(DETAIL_OBJECTS_ATTRIBUTE_VALUE, WILDCARD + attributeDetailValue + WILDCARD);
        }
        if (StringUtils.isNotEmpty((String)attributeDetailName)) {
            searchCriteria.put(DETAIL_OBJECTS_ATTRIBUTE_NAME, WILDCARD + attributeDetailName + WILDCARD);
        }
        if (StringUtils.isNotBlank((String)detailCriteria)) {
            searchCriteria.put(DETAIL_CRITERIA, detailCriteria);
        }
        if (StringUtils.isNotBlank((String)active)) {
            searchCriteria.put("active", active);
        }
        return searchCriteria;
    }

    protected String getQueryString(String parameter) {
        if (StringUtils.isEmpty((String)parameter)) {
            return WILDCARD;
        }
        return WILDCARD + parameter + WILDCARD;
    }

    protected Map<String, String> buildRoleSearchCriteria(Map<String, String> fieldValues) {
        String assignedToPrincipalName = fieldValues.get(ASSIGNED_TO_PRINCIPAL_NAME);
        ArrayList<Principal> principals = new ArrayList<Principal>();
        if (StringUtils.isNotEmpty((String)assignedToPrincipalName)) {
            if (assignedToPrincipalName.contains(WILDCARD)) {
                return null;
            }
            Principal principal = KimApiServiceLocator.getIdentityService().getPrincipalByPrincipalName(assignedToPrincipalName);
            if (principal == null) {
                return null;
            }
            principals.add(principal);
        }
        String assignedToGroupNamespaceCode = fieldValues.get(ASSIGNED_TO_GROUP_NAMESPACE_CODE);
        String assignedToGroupName = fieldValues.get(ASSIGNED_TO_GROUP_NAME);
        List groups = null;
        if (StringUtils.isNotEmpty((String)assignedToGroupNamespaceCode) && StringUtils.isEmpty((String)assignedToGroupName) || StringUtils.isEmpty((String)assignedToGroupNamespaceCode) && StringUtils.isNotEmpty((String)assignedToGroupName) || StringUtils.isNotEmpty((String)assignedToGroupNamespaceCode) && StringUtils.isNotEmpty((String)assignedToGroupName)) {
            QueryByCriteria.Builder builder = QueryByCriteria.Builder.create();
            builder.setPredicates(new org.kuali.rice.core.api.criteria.Predicate[]{PredicateFactory.and((org.kuali.rice.core.api.criteria.Predicate[])new org.kuali.rice.core.api.criteria.Predicate[]{PredicateFactory.like((String)"namespaceCode", (CharSequence)this.getQueryString(assignedToGroupNamespaceCode)), PredicateFactory.like((String)"name", (CharSequence)this.getQueryString(assignedToGroupName))})});
            GroupQueryResults qr = KimApiServiceLocator.getGroupService().findGroups(builder.build());
            if (qr.getResults() == null || qr.getResults().isEmpty()) {
                return null;
            }
            groups = qr.getResults();
        }
        String assignedToRoleNamespaceCode = fieldValues.get(ASSIGNED_TO_NAMESPACE_FOR_LOOKUP);
        String assignedToRoleName = fieldValues.get(ASSIGNED_TO_ROLE_NAME);
        HashMap<String, String> searchCriteria = new HashMap<String, String>();
        if (StringUtils.isNotEmpty((String)assignedToRoleNamespaceCode)) {
            searchCriteria.put("namespaceCode", WILDCARD + assignedToRoleNamespaceCode + WILDCARD);
        }
        if (StringUtils.isNotEmpty((String)assignedToRoleName)) {
            searchCriteria.put("name", WILDCARD + assignedToRoleName + WILDCARD);
        }
        StringBuffer memberQueryString = null;
        if (!principals.isEmpty()) {
            memberQueryString = new StringBuffer();
            for (Principal principal : principals) {
                memberQueryString.append(principal.getPrincipalId() + "|");
            }
            if (memberQueryString.toString().endsWith("|")) {
                memberQueryString.delete(memberQueryString.length() - "|".length(), memberQueryString.length());
            }
        }
        if (groups != null) {
            if (memberQueryString == null) {
                memberQueryString = new StringBuffer();
            } else if (StringUtils.isNotEmpty((String)memberQueryString.toString())) {
                memberQueryString.append("|");
            }
            for (Group group : groups) {
                memberQueryString.append(group.getId() + "|");
            }
            if (memberQueryString.toString().endsWith("|")) {
                memberQueryString.delete(memberQueryString.length() - "|".length(), memberQueryString.length());
            }
            searchCriteria.put(ASSIGNED_TO_ROLE_MEMBER_ID, memberQueryString.toString());
        }
        if (memberQueryString != null && StringUtils.isNotEmpty((String)memberQueryString.toString())) {
            searchCriteria.put(ASSIGNED_TO_ROLE_MEMBER_ID, memberQueryString.toString());
        }
        return searchCriteria;
    }

    protected boolean isMapSubset(Map<String, String> mainMap, Map<String, String> subsetMap) {
        for (Map.Entry<String, String> keyValue : subsetMap.entrySet()) {
            if (mainMap.containsKey(keyValue.getKey()) && StringUtils.equals((String)mainMap.get(keyValue.getKey()), (String)keyValue.getValue())) continue;
            return false;
        }
        return true;
    }

    protected Map<String, String> parseDetailCriteria(String detailCritiera) {
        if (StringUtils.isBlank((String)detailCritiera)) {
            return new HashMap<String, String>(0);
        }
        String[] keyValuePairs = StringUtils.split((String)detailCritiera, (char)',');
        if (keyValuePairs == null || keyValuePairs.length == 0) {
            return new HashMap<String, String>(0);
        }
        HashMap<String, String> parsedDetails = new HashMap<String, String>(keyValuePairs.length);
        for (String keyValueStr : keyValuePairs) {
            String[] keyValue = StringUtils.split((String)keyValueStr, (char)'=');
            if (keyValue.length < 2) continue;
            parsedDetails.put(keyValue[0], keyValue[1]);
        }
        return parsedDetails;
    }

    public List<Row> getRows() {
        List rows = super.getRows();
        Iterator i = rows.iterator();
        while (i.hasNext()) {
            Row row = (Row)i.next();
            int numFieldsRemoved = 0;
            boolean rowIsBlank = true;
            Iterator fieldIter = row.getFields().iterator();
            while (fieldIter.hasNext()) {
                Field field = (Field)fieldIter.next();
                String propertyName = field.getPropertyName();
                if (propertyName.equals(DETAIL_CRITERIA)) {
                    Object val = this.getParameters().get(propertyName);
                    String propVal = null;
                    if (val != null) {
                        String string = propVal = val instanceof String ? (String)val : ((String[])val)[0];
                    }
                    if (StringUtils.isBlank(propVal)) {
                        fieldIter.remove();
                        ++numFieldsRemoved;
                        continue;
                    }
                    field.setReadOnly(true);
                    rowIsBlank = false;
                    continue;
                }
                if ("blankSpace".equals(field.getFieldType())) continue;
                rowIsBlank = false;
            }
            if (numFieldsRemoved <= 0) continue;
            if (rowIsBlank) {
                i.remove();
                continue;
            }
            while (numFieldsRemoved > 0) {
                Field blankSpace = new Field();
                blankSpace.setFieldType("blankSpace");
                blankSpace.setPropertyName("blankSpace");
                row.getFields().add(blankSpace);
                --numFieldsRemoved;
            }
        }
        return rows;
    }

    protected Long getActualSizeIfTruncated(List result) {
        Long actualSizeIfTruncated = new Long(0L);
        if (result instanceof CollectionIncomplete) {
            actualSizeIfTruncated = ((CollectionIncomplete)result).getActualSizeIfTruncated();
        }
        return actualSizeIfTruncated;
    }

    protected List<RoleBo> searchRoles(Map<String, String> roleSearchCriteria, boolean unbounded) {
        List roles = (List)this.getLookupService().findCollectionBySearchHelper(RoleBo.class, roleSearchCriteria, unbounded);
        String membersCrt = roleSearchCriteria.get(ASSIGNED_TO_ROLE_MEMBER_ID);
        ArrayList<RoleBo> roles2Remove = new ArrayList<RoleBo>();
        if (StringUtils.isNotBlank((String)membersCrt)) {
            ArrayList<String> memberSearchIds = new ArrayList<String>();
            ArrayList<String> memberIds = new ArrayList<String>();
            if (membersCrt.contains("|")) {
                memberSearchIds = new ArrayList<String>(Arrays.asList(membersCrt.split("\\|")));
            } else {
                memberSearchIds.add(membersCrt);
            }
            for (RoleBo roleBo : roles) {
                List roleMembers = roleBo.getMembers();
                memberIds.clear();
                CollectionUtils.filter((Collection)roleMembers, (Predicate)new Predicate(this){

                    public boolean evaluate(Object object) {
                        RoleMemberBo member = (RoleMemberBo)object;
                        return member.isActive(new Timestamp(System.currentTimeMillis()));
                    }
                });
                if (roleMembers != null && !roleMembers.isEmpty()) {
                    for (RoleMemberBo memberImpl : roleMembers) {
                        memberIds.add(memberImpl.getMemberId());
                    }
                    if (!((List)CollectionUtils.intersection(memberSearchIds, memberIds)).isEmpty()) continue;
                    roles2Remove.add(roleBo);
                    continue;
                }
                roles2Remove.add(roleBo);
            }
        }
        if (!roles2Remove.isEmpty()) {
            roles.removeAll(roles2Remove);
        }
        return roles;
    }
}

