/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.engine.node;

/**
 * The result of the execution of a {@link SimpleNode}.  Simply wraps a boolean as
 * to whether or not the node has completed.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class SimpleResult implements ProcessResult {

	private boolean complete = false;
	
	public SimpleResult(boolean complete) {
		this.complete = complete;
	}
	
	@Override
    public boolean isComplete() {
		return complete;
	}
	
	protected void setComplete(boolean complete) {
		this.complete = complete;
	}
	
}
