/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.impl.action;

import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.kew.api.action.RolePokerQueue;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.ksb.api.messaging.AsyncCapableService;
import org.kuali.rice.ksb.api.messaging.AsyncWrappable;

import javax.xml.namespace.QName;

/**
 * Reference implementation of the {@code RokePokerQueue} which handle re-resolution of action requests which use roles.
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class RolePokerQueueImpl implements RolePokerQueue, AsyncWrappable<RolePokerQueue> {

	private AsyncCapableService asyncCapableService;

    @Override
	public void reResolveQualifiedRole(String documentId, String roleName, String qualifiedRoleNameLabel) {
        if (StringUtils.isBlank(documentId)) {
			throw new RiceIllegalArgumentException("documentId is null or blank");
		}
        if (StringUtils.isBlank(roleName)) {
			throw new RiceIllegalArgumentException("roleName is null or blank");
		}

		KEWServiceLocator.getRouteHeaderService().lockRouteHeader(documentId);
		DocumentRouteHeaderValue document = KEWServiceLocator.getRouteHeaderService().getRouteHeader(documentId);
		if (qualifiedRoleNameLabel == null) {
			KEWServiceLocator.getRoleService().reResolveRole(document, roleName);
		} else {
			KEWServiceLocator.getRoleService().reResolveQualifiedRole(document, roleName, qualifiedRoleNameLabel);
		}
	}

    @Override
	public void reResolveRole(String documentId, String roleName) {
		reResolveQualifiedRole(documentId, roleName, null);
	}


	@Override
	public RolePokerQueue wrap(QName qname, String applicationId) {
		return new RolePokerQueueAsyncCapableImpl(asyncCapableService,this, qname, applicationId);
	}

	public AsyncCapableService getAsyncCapableService() {
		return asyncCapableService;
	}

	public void setAsyncCapableService(AsyncCapableService asyncCapableService) {
		this.asyncCapableService = asyncCapableService;
	}
}
