/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.role.service;

import org.kuali.rice.kew.doctype.bo.DocumentType;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;


/**
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public interface RoleService {

	/**
	 * Re-resolves the given qualified role for all documents for the given document type (including children).
	 * This methods executes asynchronously.
	 */
	public void reResolveRole(DocumentType documentType, String roleName);

	/**
	 * Re-resolves the given qualified role for all documents for the given document type (including children).
	 * This methods executes asynchronously.
	 */
	public void reResolveQualifiedRole(DocumentType documentType, String roleName, String qualifiedRoleNameLabel);

	/**
	 * Re-resolves the given qualified role on the given document.  This method executes synchronously.
	 */
	public void reResolveQualifiedRole(DocumentRouteHeaderValue routeHeader, String roleName, String qualifiedRoleNameLabel);

	/**
	 * Re-resolves the given role on the given document.  This method executes synchronously.
	 */
	public void reResolveRole(DocumentRouteHeaderValue routeHeader, String roleName);

}
