/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.rule;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import org.kuali.rice.kew.actionrequest.ActionRequestValue;
import org.kuali.rice.kew.api.identity.Id;

/**
 * The resolution of a qualified role (role name + data) to a List of recipient
 * {@link Id}s.  In addition to the Ids of the recipients, a ResolvedQualifiedRole 
 * can also contain a label for the role (to be displayed on the Route Log) and
 * an annotation (to be displayed on the generated {@link ActionRequestValue}).
 * 
 * @see Id
 * @see ActionRequestValue
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class ResolvedQualifiedRole implements Serializable {

	private static final long serialVersionUID = 5397269690550273869L;
	
	private List<Id> recipients = new ArrayList<Id>();
    private String qualifiedRoleLabel;
    private String annotation;

    public ResolvedQualifiedRole() {
    }

    public ResolvedQualifiedRole(String qualifiedRoleLabel, List<Id> recipients) {
        this(qualifiedRoleLabel, recipients, "");
    }
    
    public ResolvedQualifiedRole(String qualifiedRoleLabel, List<Id> recipients, String annotation) {
        this.qualifiedRoleLabel = qualifiedRoleLabel;
        this.recipients = recipients;
        this.annotation = annotation;
    }
    
    public List<Id> getRecipients() {
        return recipients;
    }
    public void setRecipients(List<Id> users) {
        this.recipients = users;
    }
    public String getQualifiedRoleLabel() {
        return qualifiedRoleLabel;
    }
    public void setQualifiedRoleLabel(String qualifiedRoleLabel) {
        this.qualifiedRoleLabel = qualifiedRoleLabel;
    }
    public String getAnnotation() {
        return annotation;
    }
    public void setAnnotation(String annotation) {
        this.annotation = annotation;
    }
    
}
