/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.rule.bo;

import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.commons.lang.ArrayUtils;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.kuali.rice.kew.api.rule.RoleName;
import org.kuali.rice.kew.api.rule.RuleTemplate;
import org.kuali.rice.kew.api.rule.RuleTemplateContract;
import org.kuali.rice.kew.rule.RuleTemplateOptionBo;
import org.kuali.rice.kew.rule.bo.RuleTemplateAttributeBo;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.krad.bo.PersistableBusinessObjectBase;
import org.kuali.rice.krad.data.jpa.PortableSequenceGenerator;

@Entity
@Table(name="KREW_RULE_TMPL_T")
@NamedQueries(value={@NamedQuery(name="findAllOrderedByName", query="SELECT rt FROM RuleTemplateBo rt ORDER BY rt.name ASC")})
public class RuleTemplateBo
extends PersistableBusinessObjectBase
implements RuleTemplateContract,
PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups {
    private static final long serialVersionUID = -3387940485523951302L;
    public static final String[] DEFAULT_OPTION_KEYS = new String[]{"K", "A", "C", "F", "D"};
    @Id
    @PortableSequenceGenerator(name="KREW_RTE_TMPL_S")
    @GeneratedValue(generator="KREW_RTE_TMPL_S")
    @Column(name="RULE_TMPL_ID")
    private String id;
    @Column(name="NM")
    private String name;
    @Column(name="RULE_TMPL_DESC")
    private String description;
    @Column(name="DLGN_RULE_TMPL_ID", insertable=false, updatable=false)
    private String delegationTemplateId;
    @OneToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="DLGN_RULE_TMPL_ID")
    private RuleTemplateBo delegationTemplate;
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL}, mappedBy="ruleTemplate")
    private List<RuleTemplateAttributeBo> ruleTemplateAttributes = new ArrayList<RuleTemplateAttributeBo>();
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.PERSIST, CascadeType.REMOVE, CascadeType.MERGE}, mappedBy="ruleTemplate", orphanRemoval=true)
    private List<RuleTemplateOptionBo> ruleTemplateOptions = new ArrayList<RuleTemplateOptionBo>();
    @Transient
    private String returnUrl;

    public void removeNonDefaultOptions() {
        Iterator it = this._persistence_get_ruleTemplateOptions().iterator();
        while (it.hasNext()) {
            RuleTemplateOptionBo option = (RuleTemplateOptionBo)((Object)it.next());
            if (ArrayUtils.contains((Object[])DEFAULT_OPTION_KEYS, (Object)option.getCode())) continue;
            it.remove();
        }
    }

    public String getDelegateTemplateName() {
        if (this._persistence_get_delegationTemplate() != null) {
            return this._persistence_get_delegationTemplate().getName();
        }
        return "";
    }

    public String getRuleTemplateActionsUrl() {
        return "<a href=\"RuleTemplate.do?methodToCall=report&currentRuleTemplateId=" + this._persistence_get_id() + "\" >report</a>";
    }

    private RuleTemplateAttributeBo getRuleTemplateAttribute(RuleTemplateAttributeBo ruleTemplateAttribute, Boolean active) {
        for (RuleTemplateAttributeBo currentRuleTemplateAttribute : this.getRuleTemplateAttributes()) {
            if (!currentRuleTemplateAttribute.getRuleAttribute().getName().equals(ruleTemplateAttribute.getRuleAttribute().getName())) continue;
            if (active == null) {
                return currentRuleTemplateAttribute;
            }
            if (active.compareTo(currentRuleTemplateAttribute.getActive()) != 0) continue;
            return currentRuleTemplateAttribute;
        }
        return null;
    }

    public RuleTemplateAttributeBo getRuleTemplateAttribute(RuleTemplateAttributeBo ruleTemplateAttribute) {
        return this.getRuleTemplateAttribute(ruleTemplateAttribute, null);
    }

    public boolean containsActiveRuleTemplateAttribute(RuleTemplateAttributeBo templateAttribute) {
        return this.getRuleTemplateAttribute(templateAttribute, Boolean.TRUE) != null;
    }

    public boolean containsRuleTemplateAttribute(RuleTemplateAttributeBo templateAttribute) {
        return this.getRuleTemplateAttribute(templateAttribute, null) != null;
    }

    public RuleTemplateAttributeBo getRuleTemplateAttribute(int index) {
        while (this.getRuleTemplateAttributes().size() <= index) {
            this.getRuleTemplateAttributes().add(new RuleTemplateAttributeBo());
        }
        return this.getRuleTemplateAttributes().get(index);
    }

    public List<RuleTemplateAttributeBo> getRuleTemplateAttributes() {
        Collections.sort(this._persistence_get_ruleTemplateAttributes());
        return this._persistence_get_ruleTemplateAttributes();
    }

    public List<RuleTemplateAttributeBo> getActiveRuleTemplateAttributes() {
        ArrayList<RuleTemplateAttributeBo> activeAttributes = new ArrayList<RuleTemplateAttributeBo>();
        for (RuleTemplateAttributeBo templateAttribute : this.getRuleTemplateAttributes()) {
            if (!templateAttribute.isActive()) continue;
            activeAttributes.add(templateAttribute);
        }
        Collections.sort(activeAttributes);
        return activeAttributes;
    }

    public void setActiveRuleTemplateAttributes(List<RuleTemplateAttributeBo> ruleTemplateAttributes) {
        throw new UnsupportedOperationException("setActiveRuleTemplateAttributes is not implemented");
    }

    public void setRuleTemplateAttributes(List<RuleTemplateAttributeBo> ruleTemplateAttributes) {
        this._persistence_set_ruleTemplateAttributes(ruleTemplateAttributes);
    }

    public String getDescription() {
        return this._persistence_get_description();
    }

    public void setDescription(String description) {
        this._persistence_set_description(description);
    }

    public String getName() {
        return this._persistence_get_name();
    }

    public void setName(String name) {
        this._persistence_set_name(name);
    }

    public String getId() {
        return this._persistence_get_id();
    }

    public void setId(String id) {
        this._persistence_set_id(id);
    }

    public String getDelegationTemplateId() {
        return this._persistence_get_delegationTemplateId();
    }

    public void setDelegationTemplateId(String delegationTemplateId) {
        this._persistence_set_delegationTemplateId(delegationTemplateId);
    }

    public RuleTemplateBo getDelegationTemplate() {
        return this._persistence_get_delegationTemplate();
    }

    public void setDelegationTemplate(RuleTemplateBo delegationTemplate) {
        this._persistence_set_delegationTemplate(delegationTemplate);
    }

    public String getReturnUrl() {
        return this.returnUrl;
    }

    public void setReturnUrl(String returnUrl) {
        this.returnUrl = returnUrl;
    }

    public String getEncodedName() {
        return URLEncoder.encode(this.getName());
    }

    public List<RuleTemplateOptionBo> getRuleTemplateOptions() {
        return this._persistence_get_ruleTemplateOptions();
    }

    public void setRuleTemplateOptions(List<RuleTemplateOptionBo> ruleTemplateOptions) {
        this._persistence_set_ruleTemplateOptions(ruleTemplateOptions);
    }

    public RuleTemplateOptionBo getRuleTemplateOption(String key) {
        for (RuleTemplateOptionBo option : this._persistence_get_ruleTemplateOptions()) {
            if (!option.getCode().equals(key)) continue;
            return option;
        }
        return null;
    }

    public void setAcknowledge(RuleTemplateOptionBo acknowledge) {
        RuleTemplateOptionBo option = this.getRuleTemplateOption("K");
        option.setValue(acknowledge.getValue());
        option.setId(acknowledge.getId());
        option.setVersionNumber(acknowledge.getVersionNumber());
    }

    public void setComplete(RuleTemplateOptionBo complete) {
        RuleTemplateOptionBo option = this.getRuleTemplateOption("C");
        option.setValue(complete.getValue());
        option.setId(complete.getId());
        option.setVersionNumber(complete.getVersionNumber());
    }

    public void setApprove(RuleTemplateOptionBo approve) {
        RuleTemplateOptionBo option = this.getRuleTemplateOption("A");
        option.setValue(approve.getValue());
        option.setId(approve.getId());
        option.setVersionNumber(approve.getVersionNumber());
    }

    public void setFyi(RuleTemplateOptionBo fyi) {
        RuleTemplateOptionBo option = this.getRuleTemplateOption("F");
        option.setValue(fyi.getValue());
        option.setId(fyi.getId());
        option.setVersionNumber(fyi.getVersionNumber());
    }

    public void setDefaultActionRequestValue(RuleTemplateOptionBo defaultActionRequestValue) {
        RuleTemplateOptionBo option = this.getRuleTemplateOption("D");
        option.setValue(defaultActionRequestValue.getValue());
        option.setId(defaultActionRequestValue.getId());
        option.setVersionNumber(defaultActionRequestValue.getVersionNumber());
    }

    public RuleTemplateOptionBo getAcknowledge() {
        return this.getRuleTemplateOption("K");
    }

    public RuleTemplateOptionBo getComplete() {
        return this.getRuleTemplateOption("C");
    }

    public RuleTemplateOptionBo getApprove() {
        return this.getRuleTemplateOption("A");
    }

    public RuleTemplateOptionBo getFyi() {
        return this.getRuleTemplateOption("F");
    }

    public RuleTemplateOptionBo getDefaultActionRequestValue() {
        return this.getRuleTemplateOption("D");
    }

    public List<RoleName> getRoles() {
        ArrayList<RoleName> roleNames = new ArrayList<RoleName>();
        List<RuleTemplateAttributeBo> templateAttributes = this.getRuleTemplateAttributes();
        for (RuleTemplateAttributeBo templateAttribute : templateAttributes) {
            if (!templateAttribute.isWorkflowAttribute()) continue;
            roleNames.addAll(KEWServiceLocator.getWorkflowRuleAttributeMediator().getRoleNames(templateAttribute));
        }
        return roleNames;
    }

    public static RuleTemplate to(RuleTemplateBo bo) {
        if (bo == null) {
            return null;
        }
        return RuleTemplate.Builder.create((RuleTemplateContract)bo).build();
    }

    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new RuleTemplateBo();
    }

    public Object _persistence_get(String string) {
        if (string == "ruleTemplateOptions") {
            return this.ruleTemplateOptions;
        }
        if (string == "name") {
            return this.name;
        }
        if (string == "description") {
            return this.description;
        }
        if (string == "delegationTemplateId") {
            return this.delegationTemplateId;
        }
        if (string == "id") {
            return this.id;
        }
        if (string == "delegationTemplate") {
            return this.delegationTemplate;
        }
        if (string == "ruleTemplateAttributes") {
            return this.ruleTemplateAttributes;
        }
        return super._persistence_get(string);
    }

    public void _persistence_set(String string, Object object) {
        if (string == "ruleTemplateOptions") {
            this.ruleTemplateOptions = (List)object;
            return;
        }
        if (string == "name") {
            this.name = (String)object;
            return;
        }
        if (string == "description") {
            this.description = (String)object;
            return;
        }
        if (string == "delegationTemplateId") {
            this.delegationTemplateId = (String)object;
            return;
        }
        if (string == "id") {
            this.id = (String)object;
            return;
        }
        if (string == "delegationTemplate") {
            this.delegationTemplate = (RuleTemplateBo)((Object)object);
            return;
        }
        if (string == "ruleTemplateAttributes") {
            this.ruleTemplateAttributes = (List)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public List _persistence_get_ruleTemplateOptions() {
        this._persistence_checkFetched("ruleTemplateOptions");
        return this.ruleTemplateOptions;
    }

    public void _persistence_set_ruleTemplateOptions(List list) {
        this._persistence_checkFetchedForSet("ruleTemplateOptions");
        this.ruleTemplateOptions = list;
    }

    public String _persistence_get_name() {
        this._persistence_checkFetched("name");
        return this.name;
    }

    public void _persistence_set_name(String string) {
        this._persistence_checkFetchedForSet("name");
        this.name = string;
    }

    public String _persistence_get_description() {
        this._persistence_checkFetched("description");
        return this.description;
    }

    public void _persistence_set_description(String string) {
        this._persistence_checkFetchedForSet("description");
        this.description = string;
    }

    public String _persistence_get_delegationTemplateId() {
        this._persistence_checkFetched("delegationTemplateId");
        return this.delegationTemplateId;
    }

    public void _persistence_set_delegationTemplateId(String string) {
        this._persistence_checkFetchedForSet("delegationTemplateId");
        this.delegationTemplateId = string;
    }

    public String _persistence_get_id() {
        this._persistence_checkFetched("id");
        return this.id;
    }

    public void _persistence_set_id(String string) {
        this._persistence_checkFetchedForSet("id");
        this.id = string;
    }

    public RuleTemplateBo _persistence_get_delegationTemplate() {
        this._persistence_checkFetched("delegationTemplate");
        return this.delegationTemplate;
    }

    public void _persistence_set_delegationTemplate(RuleTemplateBo ruleTemplateBo) {
        this._persistence_checkFetchedForSet("delegationTemplate");
        this.delegationTemplate = ruleTemplateBo;
    }

    public List _persistence_get_ruleTemplateAttributes() {
        this._persistence_checkFetched("ruleTemplateAttributes");
        return this.ruleTemplateAttributes;
    }

    public void _persistence_set_ruleTemplateAttributes(List list) {
        this._persistence_checkFetchedForSet("ruleTemplateAttributes");
        this.ruleTemplateAttributes = list;
    }
}

