/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.xml;

import java.io.IOException;
import java.io.InputStream;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jdom2.Attribute;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.kuali.rice.core.api.delegation.DelegationType;
import org.kuali.rice.core.api.impex.xml.XmlConstants;
import org.kuali.rice.core.api.util.RiceConstants;
import org.kuali.rice.core.api.util.xml.XmlException;
import org.kuali.rice.core.api.util.xml.XmlHelper;
import org.kuali.rice.kew.rule.RuleBaseValues;
import org.kuali.rice.kew.rule.RuleDelegationBo;
import org.kuali.rice.kew.rule.RuleTemplateOptionBo;
import org.kuali.rice.kew.rule.bo.RuleAttribute;
import org.kuali.rice.kew.rule.bo.RuleTemplateAttributeBo;
import org.kuali.rice.kew.rule.bo.RuleTemplateBo;
import org.kuali.rice.kew.service.KEWServiceLocator;

public class RuleTemplateXmlParser {
    private static final Logger LOG = LogManager.getLogger(RuleTemplateXmlParser.class);
    private static final boolean DEFAULT_ATTRIBUTE_REQUIRED = true;
    private static final boolean DEFAULT_ATTRIBUTE_ACTIVE = true;
    private static final String DUMMY_DOCUMENT_TYPE = "dummyDocumentType";
    private int templateAttributeCounter = 0;

    public List<RuleTemplateBo> parseRuleTemplates(InputStream input) throws IOException, XmlException {
        try {
            Document doc = XmlHelper.trimSAXXml((InputStream)input);
            Element root = doc.getRootElement();
            return this.parseRuleTemplates(root);
        }
        catch (JDOMException e) {
            throw new XmlException("Parse error.", (Throwable)e);
        }
    }

    public List<RuleTemplateBo> parseRuleTemplates(Element element) throws XmlException {
        ArrayList<RuleTemplateBo> ruleTemplates = new ArrayList<RuleTemplateBo>();
        Collection ruleTemplatesElements = XmlHelper.findElements((Element)element, (String)"ruleTemplates");
        for (Element ruleTemplatesElement : ruleTemplatesElements) {
            Collection ruleTemplateElements = XmlHelper.findElements((Element)ruleTemplatesElement, (String)"ruleTemplate");
            Iterator iterator = ruleTemplateElements.iterator();
            while (iterator.hasNext()) {
                ruleTemplates.add(this.parseRuleTemplate((Element)iterator.next(), ruleTemplates));
            }
        }
        return ruleTemplates;
    }

    private RuleTemplateBo parseRuleTemplate(Element element, List<RuleTemplateBo> ruleTemplates) throws XmlException {
        String name = element.getChildText("name", XmlConstants.RULE_TEMPLATE_NAMESPACE);
        String description = element.getChildText("description", XmlConstants.RULE_TEMPLATE_NAMESPACE);
        Attribute allowOverwriteAttrib = element.getAttribute("allowOverwrite");
        boolean allowOverwrite = false;
        if (allowOverwriteAttrib != null) {
            allowOverwrite = Boolean.valueOf(allowOverwriteAttrib.getValue());
        }
        if (StringUtils.isEmpty((String)name)) {
            throw new XmlException("RuleTemplate must have a name");
        }
        if (StringUtils.isEmpty((String)description)) {
            throw new XmlException("RuleTemplate must have a description");
        }
        RuleTemplateBo ruleTemplate = KEWServiceLocator.getRuleTemplateService().findByRuleTemplateName(name);
        if (ruleTemplate == null) {
            ruleTemplate = new RuleTemplateBo();
        } else {
            if (!allowOverwrite) {
                throw new RuntimeException("Attempting to overwrite template " + name + " without allowOverwrite set");
            }
            assert (name.equals(ruleTemplate.getName())) : "Existing template definition name does not match incoming definition name";
        }
        ruleTemplate.setName(name);
        ruleTemplate.setDescription(description);
        this.updateDelegationTemplate(element, ruleTemplate, ruleTemplates);
        this.updateRuleTemplateAttributes(element, ruleTemplate);
        ruleTemplate = KEWServiceLocator.getRuleTemplateService().save(ruleTemplate);
        this.updateRuleTemplateDefaultOptions(element, ruleTemplate);
        ruleTemplate = KEWServiceLocator.getRuleTemplateService().save(ruleTemplate);
        return ruleTemplate;
    }

    protected void updateRuleTemplateDefaultOptions(Element ruleTemplateElement, RuleTemplateBo updatedRuleTemplate) throws XmlException {
        Element defaultsElement = ruleTemplateElement.getChild("ruleDefaults", XmlConstants.RULE_TEMPLATE_NAMESPACE);
        boolean isDelegation = this.updateRuleDefaults(defaultsElement, updatedRuleTemplate);
        this.updateRuleTemplateOptions(defaultsElement, updatedRuleTemplate, isDelegation);
    }

    protected void updateRuleTemplateOptions(Element defaultsElement, RuleTemplateBo updatedRuleTemplate, boolean isDelegation) throws XmlException {
        String defaultActionRequested = null;
        Boolean supportsComplete = null;
        Boolean supportsApprove = null;
        Boolean supportsAcknowledge = null;
        Boolean supportsFYI = null;
        updatedRuleTemplate.removeNonDefaultOptions();
        if (defaultsElement != null) {
            defaultActionRequested = defaultsElement.getChildText("defaultActionRequested", XmlConstants.RULE_TEMPLATE_NAMESPACE);
            supportsComplete = BooleanUtils.toBooleanObject((String)defaultsElement.getChildText("supportsComplete", XmlConstants.RULE_TEMPLATE_NAMESPACE));
            supportsApprove = BooleanUtils.toBooleanObject((String)defaultsElement.getChildText("supportsApprove", XmlConstants.RULE_TEMPLATE_NAMESPACE));
            supportsAcknowledge = BooleanUtils.toBooleanObject((String)defaultsElement.getChildText("supportsAcknowledge", XmlConstants.RULE_TEMPLATE_NAMESPACE));
            supportsFYI = BooleanUtils.toBooleanObject((String)defaultsElement.getChildText("supportsFYI", XmlConstants.RULE_TEMPLATE_NAMESPACE));
        }
        if (!isDelegation) {
            this.updateOrDeleteRuleTemplateOption(updatedRuleTemplate, "D", defaultActionRequested);
            this.updateOrDeleteRuleTemplateOption(updatedRuleTemplate, "A", supportsApprove);
            this.updateOrDeleteRuleTemplateOption(updatedRuleTemplate, "K", supportsAcknowledge);
            this.updateOrDeleteRuleTemplateOption(updatedRuleTemplate, "F", supportsFYI);
            this.updateOrDeleteRuleTemplateOption(updatedRuleTemplate, "C", supportsComplete);
        }
    }

    protected boolean updateRuleDefaults(Element defaultsElement, RuleTemplateBo updatedRuleTemplate) throws XmlException {
        RuleBaseValues ruleDefaults;
        if (updatedRuleTemplate.getId() != null && (ruleDefaults = KEWServiceLocator.getRuleService().findDefaultRuleByRuleTemplateId(updatedRuleTemplate.getId())) != null) {
            List<RuleDelegationBo> ruleDelegationDefaults = KEWServiceLocator.getRuleDelegationService().findByDelegateRuleId(ruleDefaults.getId());
            KEWServiceLocator.getRuleService().delete(ruleDefaults.getId());
            for (RuleDelegationBo ruleDelegation : ruleDelegationDefaults) {
                KEWServiceLocator.getRuleDelegationService().delete(ruleDelegation.getRuleDelegationId());
            }
        }
        boolean isDelegation = false;
        if (defaultsElement != null) {
            String delegationTypeCode = defaultsElement.getChildText("delegationType", XmlConstants.RULE_TEMPLATE_NAMESPACE);
            DelegationType delegationType = null;
            isDelegation = !StringUtils.isEmpty((String)delegationTypeCode);
            String description = defaultsElement.getChildText("description", XmlConstants.RULE_TEMPLATE_NAMESPACE);
            if (description == null) {
                throw new XmlException("Description must be specified in rule defaults");
            }
            String fromDate = defaultsElement.getChildText("fromDate", XmlConstants.RULE_TEMPLATE_NAMESPACE);
            String toDate = defaultsElement.getChildText("toDate", XmlConstants.RULE_TEMPLATE_NAMESPACE);
            Boolean forceAction = BooleanUtils.toBooleanObject((String)defaultsElement.getChildText("forceAction", XmlConstants.RULE_TEMPLATE_NAMESPACE));
            Boolean active = BooleanUtils.toBooleanObject((String)defaultsElement.getChildText("active", XmlConstants.RULE_TEMPLATE_NAMESPACE));
            if (isDelegation && (delegationType = DelegationType.parseCode((String)delegationTypeCode)) == null) {
                throw new XmlException("Invalid delegation type '" + String.valueOf(delegationType) + "'.  Expected one of: " + DelegationType.PRIMARY.getCode() + "," + DelegationType.SECONDARY.getCode());
            }
            RuleBaseValues ruleDefaults2 = new RuleBaseValues();
            ruleDefaults2.setRuleTemplate(updatedRuleTemplate);
            ruleDefaults2.setRuleTemplateId(updatedRuleTemplate.getId());
            ruleDefaults2.setDocTypeName(DUMMY_DOCUMENT_TYPE);
            ruleDefaults2.setTemplateRuleInd(Boolean.TRUE);
            ruleDefaults2.setCurrentInd(Boolean.TRUE);
            ruleDefaults2.setVersionNbr(new Integer(0));
            ruleDefaults2.setDescription(description);
            ruleDefaults2.setForceAction(BooleanUtils.isTrue((Boolean)forceAction));
            ruleDefaults2.setActive(BooleanUtils.isTrue((Boolean)active));
            if (ruleDefaults2.getActivationDate() == null) {
                ruleDefaults2.setActivationDate(new Timestamp(System.currentTimeMillis()));
            }
            ruleDefaults2.setFromDateValue(this.formatDate("fromDate", fromDate));
            ruleDefaults2.setToDateValue(this.formatDate("toDate", toDate));
            RuleDelegationBo ruleDelegationDefaults = null;
            if (isDelegation) {
                ruleDelegationDefaults = new RuleDelegationBo();
                ruleDelegationDefaults.setDelegationRule(ruleDefaults2);
                ruleDelegationDefaults.setDelegationType(delegationType);
                ruleDelegationDefaults.setResponsibilityId("-1");
            }
            KEWServiceLocator.getRuleTemplateService().saveRuleDefaults(ruleDelegationDefaults, ruleDefaults2);
        }
        return isDelegation;
    }

    protected void updateOrDeleteRuleTemplateOption(RuleTemplateBo updatedRuleTemplate, String key, Object value) {
        if (value != null) {
            RuleTemplateOptionBo option = updatedRuleTemplate.getRuleTemplateOption(key);
            if (option != null) {
                option.setValue(value.toString());
            } else {
                updatedRuleTemplate.getRuleTemplateOptions().add(new RuleTemplateOptionBo(key, value.toString()));
            }
        } else {
            Iterator<RuleTemplateOptionBo> options = updatedRuleTemplate.getRuleTemplateOptions().iterator();
            while (options.hasNext()) {
                RuleTemplateOptionBo opt = options.next();
                if (!key.equals(opt.getCode())) continue;
                options.remove();
                break;
            }
        }
    }

    protected void updateDelegationTemplate(Element ruleTemplateElement, RuleTemplateBo updatedRuleTemplate, List<RuleTemplateBo> parsedRuleTemplates) throws XmlException {
        String delegateTemplateName = ruleTemplateElement.getChildText("delegationTemplate", XmlConstants.RULE_TEMPLATE_NAMESPACE);
        if (delegateTemplateName != null) {
            RuleTemplateBo delegateTemplate = KEWServiceLocator.getRuleTemplateService().findByRuleTemplateName(delegateTemplateName);
            if (delegateTemplate == null) {
                for (RuleTemplateBo rt : parsedRuleTemplates) {
                    if (!delegateTemplateName.equalsIgnoreCase(rt.getName())) continue;
                    String ruleTemplateId = KEWServiceLocator.getRuleTemplateService().getNextRuleTemplateId();
                    rt.setId(ruleTemplateId);
                    delegateTemplate = rt;
                    break;
                }
            }
            if (delegateTemplate == null) {
                throw new XmlException("Cannot find delegation template " + delegateTemplateName);
            }
            updatedRuleTemplate.setDelegationTemplateId(delegateTemplate.getDelegationTemplateId());
            updatedRuleTemplate.setDelegationTemplate(delegateTemplate);
        }
    }

    protected void updateRuleTemplateAttributes(Element ruleTemplateElement, RuleTemplateBo updatedRuleTemplate) throws XmlException {
        Element attributesElement = ruleTemplateElement.getChild("attributes", XmlConstants.RULE_TEMPLATE_NAMESPACE);
        ArrayList<RuleTemplateAttributeBo> incomingAttributes = new ArrayList<RuleTemplateAttributeBo>();
        if (attributesElement != null) {
            incomingAttributes.addAll(this.parseRuleTemplateAttributes(attributesElement, updatedRuleTemplate));
        }
        for (RuleTemplateAttributeBo currentRuleTemplateAttribute : updatedRuleTemplate.getRuleTemplateAttributes()) {
            String ruleAttributeName = currentRuleTemplateAttribute.getRuleAttribute() != null ? currentRuleTemplateAttribute.getRuleAttribute().getName() : "(null)";
            LOG.debug("Inactivating rule template attribute with id " + currentRuleTemplateAttribute.getId() + " and rule attribute with name " + ruleAttributeName);
            currentRuleTemplateAttribute.setActive(Boolean.FALSE);
        }
        for (RuleTemplateAttributeBo ruleTemplateAttribute : incomingAttributes) {
            RuleTemplateAttributeBo potentialExistingTemplateAttribute = updatedRuleTemplate.getRuleTemplateAttribute(ruleTemplateAttribute);
            if (potentialExistingTemplateAttribute != null) {
                potentialExistingTemplateAttribute.setActive(ruleTemplateAttribute.getActive());
                potentialExistingTemplateAttribute.setRequired(ruleTemplateAttribute.getRequired());
                continue;
            }
            ruleTemplateAttribute.setRuleTemplate(updatedRuleTemplate);
            updatedRuleTemplate.getRuleTemplateAttributes().add(ruleTemplateAttribute);
        }
    }

    private List<RuleTemplateAttributeBo> parseRuleTemplateAttributes(Element attributesElement, RuleTemplateBo ruleTemplate) throws XmlException {
        ArrayList<RuleTemplateAttributeBo> ruleTemplateAttributes = new ArrayList<RuleTemplateAttributeBo>();
        Collection attributeElements = XmlHelper.findElements((Element)attributesElement, (String)"attribute");
        Iterator iterator = attributeElements.iterator();
        while (iterator.hasNext()) {
            ruleTemplateAttributes.add(this.parseRuleTemplateAttribute((Element)iterator.next(), ruleTemplate));
        }
        return ruleTemplateAttributes;
    }

    private RuleTemplateAttributeBo parseRuleTemplateAttribute(Element element, RuleTemplateBo ruleTemplate) throws XmlException {
        RuleAttribute ruleAttribute;
        String attributeName = element.getChildText("name", XmlConstants.RULE_TEMPLATE_NAMESPACE);
        String requiredValue = element.getChildText("required", XmlConstants.RULE_TEMPLATE_NAMESPACE);
        String activeValue = element.getChildText("active", XmlConstants.RULE_TEMPLATE_NAMESPACE);
        if (StringUtils.isEmpty((String)attributeName)) {
            throw new XmlException("Attribute name must be non-empty");
        }
        boolean required = true;
        if (requiredValue != null) {
            required = Boolean.parseBoolean(requiredValue);
        }
        boolean active = true;
        if (activeValue != null) {
            active = Boolean.parseBoolean(activeValue);
        }
        if ((ruleAttribute = KEWServiceLocator.getRuleAttributeService().findByName(attributeName)) == null) {
            throw new XmlException("Could not locate rule attribute for name '" + attributeName + "'");
        }
        RuleTemplateAttributeBo templateAttribute = new RuleTemplateAttributeBo();
        templateAttribute.setRuleAttribute(ruleAttribute);
        templateAttribute.setRuleAttributeId(ruleAttribute.getId());
        templateAttribute.setRuleTemplate(ruleTemplate);
        templateAttribute.setRequired(required);
        templateAttribute.setActive((Boolean)active);
        templateAttribute.setDisplayOrder(new Integer(this.templateAttributeCounter++));
        return templateAttribute;
    }

    public Timestamp formatDate(String dateLabel, String dateString) throws XmlException {
        if (StringUtils.isBlank((String)dateString)) {
            return null;
        }
        try {
            return new Timestamp(RiceConstants.getDefaultDateFormat().parse(dateString).getTime());
        }
        catch (ParseException e) {
            throw new XmlException(dateLabel + " is not in the proper format.  Should have been: hh:mm a MM/dd/yyyy", (Throwable)e);
        }
    }
}

