/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.impl.group;

import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.kew.api.group.GroupMembershipChangeQueue;
import org.kuali.rice.ksb.api.messaging.AsyncCapableService;
import org.kuali.rice.ksb.api.messaging.CallMetadata;

import javax.xml.namespace.QName;

final class GroupMembershipChangeQueueAsyncCapableImpl implements GroupMembershipChangeQueue {

    private final AsyncCapableService asyncCapableService;
    private final GroupMembershipChangeQueue groupMembershipChangeQueue;
    private final QName qname;
    private final String applicationId;

    GroupMembershipChangeQueueAsyncCapableImpl(AsyncCapableService asyncCapableService, GroupMembershipChangeQueue groupMembershipChangeQueue, QName qname, String applicationId) {
        if (asyncCapableService == null) {
            throw new IllegalArgumentException("asyncCapableService is null");
        }

        if (groupMembershipChangeQueue == null) {
            throw new IllegalArgumentException("groupMembershipChangeQueue is null");
        }

        if (qname == null) {
            throw new IllegalArgumentException("qname is null");
        }

        this.asyncCapableService = asyncCapableService;
        this.groupMembershipChangeQueue = groupMembershipChangeQueue;
        this.qname = qname;
        this.applicationId = applicationId;
    }

    @Override
    public void notifyMembershipChange(String operation, String groupId, String principalId) throws RiceIllegalArgumentException {
        asyncCapableService.executeCall(qname, applicationId, operation, groupId + "/" + principalId,
                new CallMetadata("notifyMembershipChange", new Class[]{String.class, String.class, String.class}, new Object[]{operation, groupId, principalId}),
                () -> groupMembershipChangeQueue.notifyMembershipChange(operation, groupId, principalId));
    }
}
