/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.routeheader;

import org.kuali.rice.core.api.util.xml.XmlException;
import org.kuali.rice.kew.rule.WorkflowRuleAttribute;
import org.kuali.rice.kew.rule.web.RoutingReportAction;
import org.kuali.rice.kew.api.KewApiConstants;

import java.util.Iterator;
import java.util.List;


/**
 * {@link DocumentContent} which is generated from a List of attributes.
 * Used by the {@link RoutingReportAction} to aid in generation of 
 * document content when running routing reports.
 * 
 * @see org.kuali.rice.kew.rule.WorkflowRuleAttribute
 * @see RoutingReportAction
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class AttributeDocumentContent extends StandardDocumentContent {
    
	private static final long serialVersionUID = 6789132279492877000L;

	public AttributeDocumentContent(List attributes) throws XmlException {
        super(generateDocContent(attributes));
    }
    
    private static String generateDocContent(List attributes) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<").append(KewApiConstants.DOCUMENT_CONTENT_ELEMENT).append(">");
        buffer.append("<").append(KewApiConstants.ATTRIBUTE_CONTENT_ELEMENT).append(">");
        for (Iterator iterator = attributes.iterator(); iterator.hasNext();) {
            WorkflowRuleAttribute attribute = (WorkflowRuleAttribute) iterator.next();
            buffer.append(attribute.getDocContent());
        }
        buffer.append("</").append(KewApiConstants.ATTRIBUTE_CONTENT_ELEMENT).append(">");
        buffer.append("</").append(KewApiConstants.DOCUMENT_CONTENT_ELEMENT).append(">");
        return buffer.toString();
    }

}
