/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.actionlist.web;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

import org.apache.commons.collections.comparators.ComparableComparator;
import org.kuali.rice.kew.actionrequest.Recipient;
import org.kuali.rice.kew.util.WebFriendlyRecipient;

/**
 * Internal Utility class for Action Lists.
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 *
 */
public final class ActionListUtil {
	
	private ActionListUtil() {
		throw new UnsupportedOperationException("do not call");
	}

    /**
     * Converts a collection of Recipients into a collection of WebFriendlyRecipients which can be displayed in the UI
     * @param recipients recipients to convert
     * @return a collection of WebFriendlyRecipients which can be displayed in the UI
     */
    public static List<WebFriendlyRecipient> getWebFriendlyRecipients(Collection<Recipient> recipients) {
        Collection<WebFriendlyRecipient> newRecipients = new ArrayList<WebFriendlyRecipient>(recipients.size());
        for (Recipient recipient : recipients) {
            newRecipients.add(new WebFriendlyRecipient(recipient));
        }
        List<WebFriendlyRecipient> recipientList = new ArrayList<WebFriendlyRecipient>(newRecipients);
        Collections.sort(recipientList, new Comparator<WebFriendlyRecipient>() {
            Comparator<String> comp = new ComparableComparator();

            @Override
			public int compare(WebFriendlyRecipient o1, WebFriendlyRecipient o2) {
                return comp.compare(o1.getDisplayName().trim().toLowerCase(), o2.getDisplayName().trim().toLowerCase());
            }
        });
        return recipientList;
    }
}
