/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.engine.node;

import org.kuali.rice.kew.engine.RouteContext;
import org.kuali.rice.kew.engine.RouteHelper;

/**
 * A simple implementation of a {@link JoinNode} which indicates it is complete once all branches
 * have joined.
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class SimpleJoinNode implements JoinNode {
        
    protected final org.apache.logging.log4j.Logger LOG = org.apache.logging.log4j.LogManager.getLogger(getClass());
    
    @Override
    public JoinResult process(RouteContext context, RouteHelper helper) throws Exception {
        RouteNodeInstance nodeInstance = context.getNodeInstance();
        LOG.debug("Processing join node " + nodeInstance.getRouteNodeInstanceId());
        if (helper.getJoinEngine().isJoined(nodeInstance)) {
            LOG.debug("Join node is completely joined "+nodeInstance.getRouteNodeInstanceId());
            return new JoinResult(true);
        }
        return new JoinResult(false);
    }
    
    
	
}
