/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.impl.document;

import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.document.Document;
import org.kuali.rice.kew.api.document.DocumentContentUpdate;
import org.kuali.rice.kew.api.document.DocumentUpdate;
import org.kuali.rice.kew.service.KEWServiceLocator;

/**
 * TODO 
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 *
 */
public final class DefaultWorkflowDocumentProvider implements WorkflowDocumentProvider {

    @Override
    public WorkflowDocument createDocument(String principalId, String documentTypeName, DocumentUpdate documentUpdate, DocumentContentUpdate documentContentUpdate) {
        Document document = KewApiServiceLocator.getWorkflowDocumentActionsService().create(documentTypeName, principalId, documentUpdate, documentContentUpdate);
        return initializePrototype(principalId, document);
    }

    @Override
    public WorkflowDocument loadDocument(String principalId, String documentId) {
        Document document = KewApiServiceLocator.getWorkflowDocumentService().getDocument(documentId);
        if (document == null) {
            throw new IllegalArgumentException("Failed to locate workflow document for given documentId: " + documentId);
        }
        return initializePrototype(principalId, document);
    }
    
    private WorkflowDocumentPrototype initializePrototype(String principalId, Document document) {
        WorkflowDocumentPrototype prototype = KEWServiceLocator.getWorkflowDocumentPrototype();
        prototype.init(principalId, document);
        return prototype;
    }

}
