/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.impl.mail;

import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.kew.api.action.ActionItem;
import org.kuali.rice.kew.api.mail.ImmediateEmailReminderQueue;
import org.kuali.rice.ksb.api.messaging.AsyncCapableService;
import org.kuali.rice.ksb.api.messaging.CallMetadata;

import javax.xml.namespace.QName;

final class ImmediateEmailReminderQueueAsyncCapableImpl implements ImmediateEmailReminderQueue {

    private final AsyncCapableService asyncCapableService;
    private final ImmediateEmailReminderQueue immediateEmailReminderQueue;
    private final QName qname;
    private final String applicationId;

    ImmediateEmailReminderQueueAsyncCapableImpl(AsyncCapableService asyncCapableService, ImmediateEmailReminderQueue immediateEmailReminderQueue, QName qname, String applicationId) {
        if (asyncCapableService == null) {
            throw new IllegalArgumentException("asyncCapableService is null");
        }

        if (immediateEmailReminderQueue == null) {
            throw new IllegalArgumentException("immediateEmailReminderQueue is null");
        }

        if (qname == null) {
            throw new IllegalArgumentException("qname is null");
        }

        this.asyncCapableService = asyncCapableService;
        this.immediateEmailReminderQueue = immediateEmailReminderQueue;
        this.qname = qname;
        this.applicationId = applicationId;
    }

    @Override
    public void sendReminder(ActionItem actionItem, Boolean skipOnApprovals) throws RiceIllegalArgumentException {
        asyncCapableService.executeCall(qname, applicationId, actionItem != null ? actionItem.toString() : null, skipOnApprovals != null ? skipOnApprovals.toString() : null,
                new CallMetadata("sendReminder", new Class[]{ActionItem.class, Boolean.class}, new Object[]{actionItem, skipOnApprovals }), () -> immediateEmailReminderQueue.sendReminder(actionItem, skipOnApprovals));
    }
}
